/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.Reflector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public interface StatefulAggregateInstanceFactory {
    public <ID, AGGREGATE> AGGREGATE create(ID var1, Class<AGGREGATE> var2);

    public static StatefulAggregateInstanceFactory reflectionBasedAggregateRootFactory() {
        return new ReflectionBasedAggregateInstanceFactory();
    }

    public static StatefulAggregateInstanceFactory objenesisAggregateRootFactory() {
        return new ObjenesisAggregateInstanceFactory();
    }

    public static class ReflectionBasedAggregateInstanceFactory
    implements StatefulAggregateInstanceFactory {
        @Override
        public <ID, AGGREGATE> AGGREGATE create(ID id, Class<AGGREGATE> aggregateType) {
            FailFast.requireNonNull(id, (String)"You must provide an id value");
            FailFast.requireNonNull(aggregateType, (String)"You must provide an aggregateTypeClass");
            Reflector reflector = Reflector.reflectOn(aggregateType);
            Optional defaultNoArgsConstructor = reflector.getDefaultConstructor();
            if (defaultNoArgsConstructor.isPresent() && Modifier.isPublic(((Constructor)defaultNoArgsConstructor.get()).getModifiers())) {
                return (AGGREGATE)reflector.newInstance(new Object[0]);
            }
            if (reflector.hasMatchingConstructorBasedOnArguments(new Object[]{id})) {
                return (AGGREGATE)reflector.newInstance(new Object[]{id});
            }
            throw new IllegalArgumentException(MessageFormatter.msg((String)"Couldn't find default constructor nor a constructor that accepts an aggregateId of type {}", (Object[])new Object[]{id.getClass().getName()}));
        }
    }

    public static class ObjenesisAggregateInstanceFactory
    implements StatefulAggregateInstanceFactory {
        private Objenesis objenesis;
        private final ConcurrentMap<Class<?>, ObjectInstantiator<?>> instantiatorMap = new ConcurrentHashMap();

        @Override
        public <ID, AGGREGATE> AGGREGATE create(ID id, Class<AGGREGATE> aggregateType) {
            FailFast.requireNonNull(aggregateType, (String)"You must provide an aggregateType");
            if (this.objenesis == null) {
                this.objenesis = new ObjenesisStd();
            }
            return (AGGREGATE)this.instantiatorMap.computeIfAbsent(aggregateType, arg_0 -> ((Objenesis)this.objenesis).getInstantiatorOf(arg_0)).newInstance();
        }
    }
}

