/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.state;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventsToPersist;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.AggregateRoot;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.Event;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.state.AggregateState;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.shared.reflection.Reflector;
import dk.cloudcreate.essentials.shared.types.GenericType;
import java.util.stream.Stream;

public abstract class AggregateRootWithState<ID, EVENT_TYPE extends Event<ID>, STATE extends AggregateState<ID, EVENT_TYPE>, AGGREGATE_TYPE extends AggregateRootWithState<ID, EVENT_TYPE, STATE, AGGREGATE_TYPE>>
extends AggregateRoot<ID, EVENT_TYPE, AGGREGATE_TYPE> {
    protected STATE state;

    @Override
    protected void initialize() {
        Class<AggregateState> stateType = this.resolveStateImplementationClass();
        this.state = (AggregateState)Reflector.reflectOn(stateType).newInstance(new Object[0]);
    }

    @Override
    public AGGREGATE_TYPE rehydrate(Stream<EVENT_TYPE> previousEvents) {
        if (this.state == null) {
            this.initialize();
        }
        ((AggregateState)this.state).rehydrate(previousEvents);
        return (AGGREGATE_TYPE)this;
    }

    @Override
    public EventOrder eventOrderOfLastRehydratedEvent() {
        return ((AggregateState)this.state).getEventOrderOfLastRehydratedEvent();
    }

    @Override
    protected void apply(EVENT_TYPE event) {
        ((AggregateState)this.state).apply(event);
    }

    @Override
    public ID aggregateId() {
        return ((AggregateState)this.state).aggregateId();
    }

    @Override
    public EventOrder eventOrderOfLastAppliedEvent() {
        return ((AggregateState)this.state).eventOrderOfLastAppliedEvent();
    }

    @Override
    public EventsToPersist<ID, EVENT_TYPE> getUncommittedChanges() {
        return new EventsToPersist(this.aggregateId(), this.eventOrderOfLastRehydratedEvent(), ((AggregateState)this.state).uncommittedChanges());
    }

    @Override
    public void markChangesAsCommitted() {
        ((AggregateState)this.state).markChangesAsCommitted();
    }

    protected Class<AggregateState> resolveStateImplementationClass() {
        return GenericType.resolveGenericTypeOnSuperClass(this.getClass(), (int)2);
    }
}

