/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.decider;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.decider.AggregateIdResolver;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.decider.Decider;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.decider.HandlerResult;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.snapshot.AggregateSnapshotRepository;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.ConfigurableEventStore;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateType;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.persistence.AggregateEventStreamConfiguration;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkLifecycleCallback;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.functional.tuple.Pair;
import dk.cloudcreate.essentials.types.LongRange;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface CommandHandler<COMMAND, EVENT, ERROR> {
    public HandlerResult<ERROR, EVENT> handle(COMMAND var1);

    public static <CONFIG extends AggregateEventStreamConfiguration, ID, COMMAND, EVENT, ERROR, STATE> CommandHandler<COMMAND, EVENT, ERROR> deciderBasedCommandHandler(final ConfigurableEventStore<CONFIG> eventStore, final AggregateType aggregateType, Class<ID> aggregateIdType, final AggregateIdResolver<COMMAND, ID> aggregateIdFromCommandResolver, final AggregateIdResolver<EVENT, ID> aggregateIdFromEventResolver, AggregateSnapshotRepository aggregateSnapshotRepository, final Class<STATE> stateType, final Decider<COMMAND, EVENT, ERROR, STATE> decider) {
        FailFast.requireNonNull(eventStore, (String)"No eventStore provided");
        FailFast.requireNonNull((Object)aggregateType, (String)"No aggregateType provided");
        FailFast.requireNonNull(aggregateIdType, (String)"No aggregateIdType provided");
        FailFast.requireNonNull(aggregateIdFromCommandResolver, (String)"No aggregateIdFromCommandResolver provided");
        FailFast.requireNonNull(aggregateIdFromEventResolver, (String)"No aggregateIdFromEventResolver provided");
        FailFast.requireNonNull(stateType, (String)"No stateType provided");
        FailFast.requireNonNull(decider, (String)"No decider provided");
        if (eventStore.findAggregateEventStreamConfiguration(aggregateType).isEmpty()) {
            eventStore.addAggregateEventStreamConfiguration(aggregateType, aggregateIdType);
        }
        final Optional<AggregateSnapshotRepository> optionalAggregateSnapshotRepository = Optional.ofNullable(aggregateSnapshotRepository);
        return new CommandHandler<COMMAND, EVENT, ERROR>(){
            private static final Logger log = LoggerFactory.getLogger(CommandHandler.class);

            @Override
            public HandlerResult<ERROR, EVENT> handle(COMMAND cmd) {
                Optional optionalAggregateId = aggregateIdFromCommandResolver.resolveFrom(cmd);
                AtomicReference<EventOrder> eventOrderOfLastRehydratedEvent = new AtomicReference<EventOrder>(EventOrder.NO_EVENTS_PREVIOUSLY_PERSISTED);
                Object finalState = optionalAggregateId.map(aggregateId -> {
                    Optional<Pair> possibleAggregateSnapshot = optionalAggregateSnapshotRepository.flatMap(repository -> repository.loadSnapshot(aggregateType, optionalAggregateId.get(), stateType));
                    Pair initialStateAndEventStream = possibleAggregateSnapshot.map(aggregateSnapshot -> {
                        log.trace("[{}] Preparing to handle command '{}' with associated aggregateId '{}' using '{}' snapshot with eventOrderOfLastIncludedEvent {}", new Object[]{aggregateType, cmd.getClass().getName(), aggregateId, stateType.getName(), aggregateSnapshot.eventOrderOfLastIncludedEvent});
                        Optional eventStream = eventStore.fetchStream(aggregateType, optionalAggregateId.get(), LongRange.from((long)aggregateSnapshot.eventOrderOfLastIncludedEvent.increment().longValue()));
                        return Pair.of(aggregateSnapshot.aggregateSnapshot, (Object)eventStream);
                    }).orElseGet(() -> {
                        log.trace("[{}] Preparing to handle command '{}' with associated aggregateId '{}' and not using a snapshot", new Object[]{aggregateType, cmd.getClass().getName(), aggregateId});
                        return Pair.of(decider.initialState(), (Object)eventStore.fetchStream(aggregateType, optionalAggregateId.get()));
                    });
                    Object state = initialStateAndEventStream._1;
                    boolean applyEvents = ((Optional)initialStateAndEventStream._2).isPresent();
                    if (applyEvents) {
                        log.trace("[{}] ApplyEvents: Preparing state '{}' to handle command '{}', associated aggregateId '{}'", new Object[]{aggregateType, stateType.getName(), cmd.getClass().getName(), aggregateId});
                        state = ((AggregateEventStream)((Optional)initialStateAndEventStream._2).get()).events().reduce(initialStateAndEventStream._1, (deltaState, event) -> {
                            eventOrderOfLastRehydratedEvent.set(event.eventOrder());
                            return decider.applyEvent(event.event().deserialize(), deltaState);
                        }, (deltaState, deltaState2) -> deltaState2);
                    }
                    return state;
                }).orElseGet(() -> {
                    log.trace("[{}] No aggregate-id resolved. Preparing initial-state '{}' to handle command '{}'", new Object[]{aggregateType, stateType.getName(), cmd.getClass().getName()});
                    return decider.initialState();
                });
                log.debug("[{}] Handling command '{}' using state '{}'", new Object[]{aggregateType, cmd.getClass().getName(), stateType.getName()});
                HandlerResult result = decider.handle(cmd, finalState);
                if (result.isSuccess()) {
                    List events = result.asSuccess().events();
                    if (!events.isEmpty()) {
                        log.debug("[{}] Successfully handled command '{}' against state '{}' associated with aggregateId '{}'. Resulted in {} events of type {}", new Object[]{aggregateType, cmd.getClass().getName(), stateType.getName(), optionalAggregateId, events.size(), events.stream().map(event -> event.getClass().getSimpleName()).toList()});
                        Object firstEvent = events.get(0);
                        Object aggregateId2 = optionalAggregateId.orElseGet(() -> {
                            Object resolvesAggregateIdFromFirstEvent = aggregateIdFromEventResolver.resolveFrom(firstEvent).orElseThrow(() -> new IllegalStateException(MessageFormatter.msg((String)"First event didn't an aggregateId. First Event type: '{}'", (Object[])new Object[]{firstEvent.getClass().getName()})));
                            log.debug("[{}] Resolved aggregateId '{}' from first-event '{}'", new Object[]{aggregateType, resolvesAggregateIdFromFirstEvent, firstEvent.getClass().getName()});
                            return resolvesAggregateIdFromFirstEvent;
                        });
                        eventStore.getUnitOfWorkFactory().getCurrentUnitOfWork().ifPresentOrElse(eventStoreUnitOfWork -> {
                            log.debug("[{}] Registering UnitOfWorkCallback to persist {} events associated with '{}' with aggregateId '{}'", new Object[]{aggregateType, events.size(), stateType.getName(), aggregateId2});
                            eventStoreUnitOfWork.registerLifecycleCallbackForResource(new EventsToAppendToStream(finalState, aggregateType, aggregateId2, (EventOrder)eventOrderOfLastRehydratedEvent.get(), events), (UnitOfWorkLifecycleCallback)new DeciderUnitOfWorkLifecycleCallback());
                        }, () -> log.debug("[{}] !!! No active UnitOfWork so will NOT persist {} events associated with\ufb01 '{}' with aggregateId '{}'", new Object[]{aggregateType, events.size(), stateType.getName(), aggregateId2}));
                    } else {
                        log.debug("[{}] Successfully handled command '{}' against state '{}' associated with aggregateId '{}', but it didn't result in any events", new Object[]{aggregateType, cmd.getClass().getName(), stateType.getName(), optionalAggregateId});
                    }
                } else {
                    log.debug("[{}] Failed to handle command '{}' against '{}' with associated aggregateId '{}'. Resulted in error: {}", new Object[]{aggregateType, cmd.getClass().getName(), stateType.getName(), optionalAggregateId, result.asError().error()});
                    eventStore.getUnitOfWorkFactory().getCurrentUnitOfWork().ifPresent(UnitOfWork::markAsRollbackOnly);
                }
                return result;
            }

            record EventsToAppendToStream<ID, EVENT, STATE>(STATE state, AggregateType aggregateType, ID aggregateId, EventOrder eventOrderOfLastRehydratedEvent, List<EVENT> events) {
            }

            class DeciderUnitOfWorkLifecycleCallback
            implements UnitOfWorkLifecycleCallback<EventsToAppendToStream<ID, EVENT, STATE>> {
                DeciderUnitOfWorkLifecycleCallback() {
                }

                public UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus beforeCommit(UnitOfWork unitOfWork, List<EventsToAppendToStream<ID, EVENT, STATE>> associatedResources) {
                    log.trace("[{}] beforeCommit processing {} '{}' registered with the UnitOfWork being committed", new Object[]{aggregateType, associatedResources.size(), stateType.getName()});
                    associatedResources.forEach(eventsToAppendToStream -> {
                        log.trace("[{}] beforeCommit processing '{}' with id '{}'", new Object[]{aggregateType, stateType.getName(), eventsToAppendToStream.aggregateId()});
                        if (log.isTraceEnabled()) {
                            log.trace("[{}] Persisting {} event(s) related to '{}' with id '{}': {}", new Object[]{aggregateType, eventsToAppendToStream.events().size(), stateType.getName(), eventsToAppendToStream.aggregateId(), eventsToAppendToStream.events().stream().map(persistableEvent -> persistableEvent.getClass().getName()).reduce((s, s2) -> s + ", " + s2)});
                        } else {
                            log.debug("[{}] Persisting {} event(s) related to '{}' with id '{}'", new Object[]{aggregateType, eventsToAppendToStream.events().size(), stateType.getName(), eventsToAppendToStream.aggregateId()});
                        }
                        AggregateEventStream persistedEvents = eventStore.appendToStream(aggregateType, eventsToAppendToStream.aggregateId(), eventsToAppendToStream.eventOrderOfLastRehydratedEvent(), eventsToAppendToStream.events());
                        optionalAggregateSnapshotRepository.ifPresent(repository -> repository.aggregateUpdated(eventsToAppendToStream.state(), persistedEvents));
                    });
                    return UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.COMPLETED;
                }

                public void afterCommit(UnitOfWork unitOfWork, List<EventsToAppendToStream<ID, EVENT, STATE>> associatedResources) {
                }

                public void beforeRollback(UnitOfWork unitOfWork, List<EventsToAppendToStream<ID, EVENT, STATE>> associatedResources, Exception causeOfTheRollback) {
                }

                public void afterRollback(UnitOfWork unitOfWork, List<EventsToAppendToStream<ID, EVENT, STATE>> associatedResources, Exception causeOfTheRollback) {
                }
            }
        };
    }
}

