/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.flex.FlexAggregate;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class EventsToPersist<ID, EVENT_TYPE> {
    public final ID aggregateId;
    public final EventOrder eventOrderOfLastRehydratedEvent;
    public final List<EVENT_TYPE> events;
    private boolean committed;

    public EventsToPersist(ID aggregateId, EventOrder eventOrderOfLastRehydratedEvent, List<EVENT_TYPE> events) {
        this.aggregateId = FailFast.requireNonNull(aggregateId, (String)"You must supply an aggregate id");
        this.eventOrderOfLastRehydratedEvent = eventOrderOfLastRehydratedEvent;
        this.events = (List)FailFast.requireNonNull(events, (String)"No events list provided");
    }

    public EventsToPersist(ID aggregateId, EventOrder eventOrderOfLastRehydratedEvent, EVENT_TYPE ... events) {
        this.aggregateId = FailFast.requireNonNull(aggregateId, (String)"You must supply an aggregate id");
        this.eventOrderOfLastRehydratedEvent = eventOrderOfLastRehydratedEvent;
        this.events = List.of(events);
    }

    public static <ID, EVENT_TYPE> EventsToPersist<ID, EVENT_TYPE> initialAggregateEvents(ID aggregateId, EVENT_TYPE ... eventsToPersist) {
        FailFast.requireNonNull(aggregateId, (String)"You must supply an aggregateId");
        return new EventsToPersist<ID, EVENT_TYPE>(aggregateId, EventOrder.NO_EVENTS_PERSISTED, List.of(eventsToPersist));
    }

    public static <ID, EVENT_TYPE> EventsToPersist<ID, EVENT_TYPE> events(ID aggregateId, EventOrder eventOrderOfLastRehydratedEvent, EVENT_TYPE ... eventsToPersist) {
        return new EventsToPersist<ID, EVENT_TYPE>(aggregateId, eventOrderOfLastRehydratedEvent, eventsToPersist);
    }

    public static <ID, EVENT_TYPE, AGGREGATE_TYPE extends FlexAggregate<ID, AGGREGATE_TYPE>> EventsToPersist<ID, EVENT_TYPE> events(FlexAggregate<ID, AGGREGATE_TYPE> aggregate, EVENT_TYPE ... eventsToPersist) {
        return new EventsToPersist<Object, EVENT_TYPE>(FailFast.requireNonNull(aggregate.aggregateId(), (String)"Aggregate doesn't have an aggregateId, please use initialAggregateEvents(id, events)"), aggregate.eventOrderOfLastRehydratedEvent(), eventsToPersist);
    }

    public static <ID, EVENT_TYPE> EventsToPersist<ID, EVENT_TYPE> noEvents(ID aggregateId) {
        return new EventsToPersist<ID, Object>(aggregateId, null, new Object[0]);
    }

    public static <ID, EVENT_TYPE, AGGREGATE_TYPE extends FlexAggregate<ID, AGGREGATE_TYPE>> EventsToPersist<ID, EVENT_TYPE> noEvents(FlexAggregate<ID, AGGREGATE_TYPE> aggregate) {
        return new EventsToPersist<ID, Object>(aggregate.aggregateId(), aggregate.eventOrderOfLastRehydratedEvent(), new Object[0]);
    }

    public void markEventsAsCommitted() {
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public EventsToPersist<ID, EVENT_TYPE> append(EventsToPersist<ID, EVENT_TYPE> appendEventsToPersist) {
        FailFast.requireNonNull(appendEventsToPersist, (String)"You must supply an appendEventsToPersist instance");
        if (!this.aggregateId.equals(appendEventsToPersist.aggregateId)) {
            throw new IllegalArgumentException(MessageFormatter.msg((String)"Cannot append appendEventsToPersist since aggregate id's are not the same. this.aggregateId='{}', appendEventsToPersist.aggregateId='{}'", (Object[])new Object[]{this.aggregateId, appendEventsToPersist.aggregateId}));
        }
        if (this.eventOrderOfLastRehydratedEvent == null && !this.events.isEmpty()) {
            throw new IllegalStateException("this.eventOrderOfLastRehydratedEvent is null and therefore doesn't support appending");
        }
        if (appendEventsToPersist.eventOrderOfLastRehydratedEvent == null) {
            throw new IllegalStateException("appendEventsToPersist.eventOrderOfLastRehydratedEvent is null");
        }
        long expectedEventOrderOfLastRehydratedEvent = this.eventOrderOfLastRehydratedEvent.longValue() + (long)this.events.size();
        if (expectedEventOrderOfLastRehydratedEvent != appendEventsToPersist.eventOrderOfLastRehydratedEvent.longValue()) {
            throw new IllegalArgumentException(MessageFormatter.msg((String)"Cannot append appendEventsToPersist as appendEventsToPersist.eventOrderOfLastRehydratedEvent was {} but it was expected to be {}", (Object[])new Object[]{appendEventsToPersist.eventOrderOfLastRehydratedEvent, expectedEventOrderOfLastRehydratedEvent}));
        }
        ArrayList<EVENT_TYPE> allEventsToPersist = new ArrayList<EVENT_TYPE>(this.events);
        allEventsToPersist.addAll(appendEventsToPersist.events);
        return new EventsToPersist<ID, EVENT_TYPE>(this.aggregateId, this.eventOrderOfLastRehydratedEvent, allEventsToPersist);
    }

    public String toString() {
        return "EventsToPersist{aggregateId=" + this.aggregateId + ", eventOrderOfLastRehydratedEvent=" + this.eventOrderOfLastRehydratedEvent + ", eventsToPersist=" + this.events.size() + ", committed=" + this.committed + "}";
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public Stream<EVENT_TYPE> stream() {
        return this.events.stream();
    }

    public int size() {
        return this.events.size();
    }

    public Object get(int index) {
        return this.events.get(index);
    }
}

