/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.flex;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.Aggregate;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventHandler;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventsToPersist;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.AggregateEventStream;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.eventstream.PersistedEvent;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationStrategy;
import dk.cloudcreate.essentials.shared.reflection.invocation.MethodPatternMatcher;
import dk.cloudcreate.essentials.shared.reflection.invocation.PatternMatchingMethodInvoker;
import dk.cloudcreate.essentials.shared.reflection.invocation.SingleArgumentAnnotatedMethodPatternMatcher;
import java.util.List;
import java.util.stream.Stream;

public abstract class FlexAggregate<ID, AGGREGATE_TYPE extends FlexAggregate<ID, AGGREGATE_TYPE>>
implements Aggregate<ID, AGGREGATE_TYPE> {
    private transient PatternMatchingMethodInvoker<Object> invoker;
    private ID aggregateId;
    private EventOrder eventOrderOfLastRehydratedEvent;
    private boolean hasBeenRehydrated;

    public FlexAggregate() {
        this.initialize();
    }

    protected void initialize() {
        this.invoker = new PatternMatchingMethodInvoker((Object)this, (MethodPatternMatcher)new SingleArgumentAnnotatedMethodPatternMatcher(EventHandler.class, Object.class), InvocationStrategy.InvokeMostSpecificTypeMatched);
    }

    @Override
    public AGGREGATE_TYPE rehydrate(AggregateEventStream<ID> persistedEvents) {
        FailFast.requireNonNull(persistedEvents, (String)"You must provide an EventStream");
        PersistedEvent firstEvent = (PersistedEvent)persistedEvents.eventList().get(0);
        return this.rehydrate(firstEvent.aggregateId(), persistedEvents.map(persistedEvent -> persistedEvent.event().deserialize()));
    }

    public AGGREGATE_TYPE rehydrate(EventsToPersist<ID, Object> eventsToPersist) {
        FailFast.requireNonNull(eventsToPersist, (String)"You must supply an EventsToPersist instance");
        return this.rehydrate(eventsToPersist.aggregateId, eventsToPersist.events);
    }

    public AGGREGATE_TYPE rehydrate(ID aggregateId, List<Object> historicEvents) {
        FailFast.requireNonNull(historicEvents, (String)"You must supply historicEvents");
        return this.rehydrate(aggregateId, historicEvents.stream());
    }

    public AGGREGATE_TYPE rehydrate(ID aggregateId, Stream<Object> persistedEvents) {
        this.aggregateId = FailFast.requireNonNull(aggregateId, (String)"You must provide an aggregateId when initializing a FlexAggregate from a list of previous events");
        FailFast.requireNonNull(persistedEvents, (String)"You must provide a list of persisted events");
        this.eventOrderOfLastRehydratedEvent = EventOrder.NO_EVENTS_PERSISTED;
        persistedEvents.forEach(this::rehydrateEvent);
        return (AGGREGATE_TYPE)this;
    }

    public static <ID> EventsToPersist<ID, Object> newAggregateEvents(ID aggregateId, Object ... eventsToPersist) {
        return EventsToPersist.initialAggregateEvents(aggregateId, eventsToPersist);
    }

    protected EventsToPersist<ID, Object> events(Object ... eventsToPersist) {
        return EventsToPersist.events(this, eventsToPersist);
    }

    protected EventsToPersist<ID, Object> noEvents() {
        return EventsToPersist.noEvents(this);
    }

    private void rehydrateEvent(Object event) {
        FailFast.requireNonNull((Object)event, (String)"You must supply an event");
        this.applyRehydratedEventToTheAggregate(event);
        this.hasBeenRehydrated = true;
        this.eventOrderOfLastRehydratedEvent = this.eventOrderOfLastRehydratedEvent.increment();
    }

    protected void applyRehydratedEventToTheAggregate(Object event) {
        if (this.invoker == null) {
            this.initialize();
        }
        this.invoker.invoke(event, unmatchedEvent -> {});
    }

    @Override
    public ID aggregateId() {
        FailFast.requireNonNull(this.aggregateId, (String)"The aggregate id has not been set on the AggregateRoot and not supplied using one of the Event applied to it. At least the first event MUST supply it");
        return this.aggregateId;
    }

    @Override
    public boolean hasBeenRehydrated() {
        return this.hasBeenRehydrated;
    }

    @Override
    public final EventOrder eventOrderOfLastRehydratedEvent() {
        if (this.eventOrderOfLastRehydratedEvent == null) {
            this.eventOrderOfLastRehydratedEvent = EventOrder.NO_EVENTS_PERSISTED;
        }
        return this.eventOrderOfLastRehydratedEvent;
    }
}

