/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.state;

import dk.cloudcreate.essentials.components.eventsourced.aggregates.EventHandler;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.Event;
import dk.cloudcreate.essentials.components.eventsourced.aggregates.stateful.classic.InitialEventIsMissingAggregateIdException;
import dk.cloudcreate.essentials.components.eventsourced.eventstore.postgresql.types.EventOrder;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationStrategy;
import dk.cloudcreate.essentials.shared.reflection.invocation.MethodPatternMatcher;
import dk.cloudcreate.essentials.shared.reflection.invocation.PatternMatchingMethodInvoker;
import dk.cloudcreate.essentials.shared.reflection.invocation.SingleArgumentAnnotatedMethodPatternMatcher;
import dk.cloudcreate.essentials.shared.types.GenericType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class AggregateState<ID, EVENT_TYPE extends Event<ID>> {
    private PatternMatchingMethodInvoker<Event<ID>> invoker = new PatternMatchingMethodInvoker((Object)this, (MethodPatternMatcher)new SingleArgumentAnnotatedMethodPatternMatcher(EventHandler.class, new GenericType<Event<ID>>(){}), InvocationStrategy.InvokeMostSpecificTypeMatched);
    private ID aggregateId;
    private List<EVENT_TYPE> uncommittedChanges;
    private EventOrder eventOrderOfLastAppliedEvent;
    private boolean hasBeenRehydrated;
    private boolean isRehydrating;
    private EventOrder eventOrderOfLastRehydratedEvent;

    public void rehydrate(Stream<EVENT_TYPE> previousEvents) {
        FailFast.requireNonNull(previousEvents, (String)"You must provide a previousEvents stream");
        this.isRehydrating = true;
        previousEvents.forEach(event -> {
            if (this.aggregateId == null) {
                this.aggregateId = event.aggregateId();
                FailFast.requireNonNull(this.aggregateId, (String)MessageFormatter.msg((String)"The first previous/historic Event '{}' applied to Aggregate {}'s state didn't contain an aggregateId", (Object[])new Object[]{event.getClass().getName(), this.getClass().getName()}));
            }
            this.applyEventToTheAggregate((Event<ID>)event);
            this.eventOrderOfLastAppliedEvent = event.eventOrder();
        });
        this.eventOrderOfLastRehydratedEvent = this.eventOrderOfLastAppliedEvent;
        this.isRehydrating = false;
        this.hasBeenRehydrated = true;
    }

    public EventOrder getEventOrderOfLastAppliedEvent() {
        return this.eventOrderOfLastAppliedEvent;
    }

    public EventOrder getEventOrderOfLastRehydratedEvent() {
        return this.eventOrderOfLastRehydratedEvent;
    }

    protected final void apply(EVENT_TYPE event) {
        FailFast.requireNonNull(event, (String)"You must supply an event");
        Object eventAggregateId = ((Event)event).aggregateId();
        if (this.aggregateId == null) {
            this.aggregateId = eventAggregateId;
            if (this.aggregateId == null) {
                throw new InitialEventIsMissingAggregateIdException(MessageFormatter.msg((String)"The first Event '{}' applied to Aggregate '{}' didn't contain an aggregateId", (Object[])new Object[]{event.getClass().getName(), this.getClass().getName()}));
            }
        }
        if (eventAggregateId == null) {
            ((Event)event).aggregateId(this.aggregateId());
        } else {
            FailFast.requireTrue((boolean)Objects.equals(eventAggregateId, this.aggregateId), (String)MessageFormatter.msg((String)"Aggregate Id's do not match! Cannot apply Event '{}' with aggregateId '{}' to Aggregate '{}' with aggregateId '{}'", (Object[])new Object[]{event.getClass().getName(), eventAggregateId, this.getClass().getName(), this.aggregateId}));
        }
        EventOrder nextEventOrderToBeApplied = this.eventOrderOfLastAppliedEvent().increment();
        ((Event)event).eventOrder(nextEventOrderToBeApplied);
        this.applyEventToTheAggregate((Event<ID>)event);
        this.eventOrderOfLastAppliedEvent = nextEventOrderToBeApplied;
        this._uncommittedChanges().add(event);
    }

    public ID aggregateId() {
        FailFast.requireNonNull(this.aggregateId, (String)"The aggregate id has not been set on the AggregateRoot and not supplied using one of the Event applied to it. At least the first event MUST supply it");
        return this.aggregateId;
    }

    public boolean hasBeenRehydrated() {
        return this.hasBeenRehydrated;
    }

    protected final boolean isRehydrating() {
        return this.isRehydrating;
    }

    protected void applyEventToTheAggregate(Event<ID> event) {
        this.invoker.invoke(event, unmatchedEvent -> {});
    }

    public final EventOrder eventOrderOfLastAppliedEvent() {
        if (this.eventOrderOfLastAppliedEvent == null) {
            this.eventOrderOfLastAppliedEvent = EventOrder.NO_EVENTS_PERSISTED;
        }
        return this.eventOrderOfLastAppliedEvent;
    }

    public List<EVENT_TYPE> uncommittedChanges() {
        return this._uncommittedChanges();
    }

    public void markChangesAsCommitted() {
        this.uncommittedChanges = new ArrayList<EVENT_TYPE>();
    }

    private List<EVENT_TYPE> _uncommittedChanges() {
        if (this.uncommittedChanges == null) {
            this.uncommittedChanges = new ArrayList<EVENT_TYPE>();
        }
        return this.uncommittedChanges;
    }
}

