/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.test.fencedlock;

import dk.cloudcreate.essentials.components.foundation.fencedlock.DBFencedLockManager;
import dk.cloudcreate.essentials.components.foundation.fencedlock.FencedLock;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockCallback;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockName;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DBFencedLockManagerIT<LOCK_MANAGER extends DBFencedLockManager<?, ?>> {
    private LOCK_MANAGER lockManagerNode1;
    private LOCK_MANAGER lockManagerNode2;

    protected LOCK_MANAGER getLockManagerNode1() {
        return this.lockManagerNode1;
    }

    protected LOCK_MANAGER getLockManagerNode2() {
        return this.lockManagerNode2;
    }

    @BeforeEach
    void setup() {
        if (this.lockManagerNode1 != null) {
            throw new IllegalStateException("LockManager for node1 is non-null during setup");
        }
        if (this.lockManagerNode2 != null) {
            throw new IllegalStateException("LockManager for node2 is non-null during setup");
        }
        this.lockManagerNode1 = this.createLockManagerNode1();
        Assertions.assertThat(this.lockManagerNode1).isNotNull();
        this.lockManagerNode1.start();
        this.lockManagerNode1.deleteAllLocksInDB();
        this.lockManagerNode2 = this.createLockManagerNode2();
        Assertions.assertThat(this.lockManagerNode1).isNotNull();
        this.lockManagerNode2.start();
    }

    protected abstract LOCK_MANAGER createLockManagerNode2();

    protected abstract LOCK_MANAGER createLockManagerNode1();

    protected abstract void disruptDatabaseConnection();

    protected abstract void restoreDatabaseConnection();

    @AfterEach
    void cleanup() {
        System.out.println("*******  Cleaning up  *******");
        if (this.lockManagerNode1 != null) {
            this.lockManagerNode1.stop();
            this.lockManagerNode1 = null;
        }
        if (this.lockManagerNode2 != null) {
            this.lockManagerNode2.stop();
            this.lockManagerNode2 = null;
        }
    }

    @Test
    void verify_that_we_can_perform_tryAcquire_on_a_lock_and_release_it_again() {
        LockName lockName = LockName.of((CharSequence)"testLock");
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isFalse();
        Optional lockOptionNode1 = this.lockManagerNode1.tryAcquireLock(lockName);
        Optional lockOptionNode2 = this.lockManagerNode2.tryAcquireLock(lockName);
        Assertions.assertThat((Optional)lockOptionNode1).isNotNull();
        Assertions.assertThat((Optional)lockOptionNode1).isPresent();
        Assertions.assertThat((boolean)((FencedLock)lockOptionNode1.get()).isLocked()).isTrue();
        Assertions.assertThat((Long)((FencedLock)lockOptionNode1.get()).getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)((FencedLock)lockOptionNode1.get()).isLockedByThisLockManagerInstance()).isTrue();
        Optional actualLock = this.lockManagerNode1.lookupLock(lockName);
        Assertions.assertThat((Optional)actualLock).isEqualTo((Object)lockOptionNode1);
        Assertions.assertThat((Long)((FencedLock)actualLock.get()).getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((Optional)lockOptionNode2).isNotNull();
        Assertions.assertThat((Optional)lockOptionNode2).isEmpty();
        ((FencedLock)lockOptionNode1.get()).release();
        Assertions.assertThat((boolean)((FencedLock)lockOptionNode1.get()).isLocked()).isFalse();
        Assertions.assertThat((Long)((FencedLock)lockOptionNode1.get()).getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)((FencedLock)lockOptionNode1.get()).isLockedByThisLockManagerInstance()).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isFalse();
    }

    @Test
    void verify_that_we_can_acquire_a_lock_and_release_it_again() {
        LockName lockName = LockName.of((CharSequence)"testLock");
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isFalse();
        FencedLock lockNode1 = this.lockManagerNode1.acquireLock(lockName);
        Optional lockOptionNode2 = this.lockManagerNode2.tryAcquireLock(lockName);
        Assertions.assertThat((Object)lockNode1).isNotNull();
        Assertions.assertThat((boolean)lockNode1.isLocked()).isTrue();
        Assertions.assertThat((Long)lockNode1.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)lockNode1.isLockedByThisLockManagerInstance()).isTrue();
        Assertions.assertThat((Optional)lockOptionNode2).isNotNull();
        Assertions.assertThat((Optional)lockOptionNode2).isEmpty();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
        lockNode1.release();
        Assertions.assertThat((boolean)lockNode1.isLocked()).isFalse();
        Assertions.assertThat((boolean)lockNode1.isLockedByThisLockManagerInstance()).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isFalse();
    }

    @Test
    void stopping_a_lockManager_releases_all_acquired_locks() {
        LockName lock1 = LockName.of((CharSequence)"lock1");
        LockName lock2 = LockName.of((CharSequence)"lock2");
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lock1)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lock1)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lock2)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lock2)).isFalse();
        FencedLock lock1Node1 = this.lockManagerNode1.acquireLock(lock1);
        FencedLock lock2Node1 = this.lockManagerNode1.acquireLock(lock2);
        Optional lock1OptionNode2 = this.lockManagerNode2.tryAcquireLock(lock1);
        Optional lock2OptionNode2 = this.lockManagerNode2.tryAcquireLock(lock2);
        Assertions.assertThat((boolean)lock1Node1.isLocked()).isTrue();
        Assertions.assertThat((Long)lock1Node1.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)lock2Node1.isLocked()).isTrue();
        Assertions.assertThat((Long)lock2Node1.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((Optional)lock1OptionNode2).isEmpty();
        Assertions.assertThat((Optional)lock2OptionNode2).isEmpty();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lock1)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lock1)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lock1)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lock1)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lock1)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lock1)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lock2)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lock2)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lock2)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lock2)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lock2)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lock2)).isTrue();
        this.lockManagerNode1.stop();
        Assertions.assertThat((boolean)lock1Node1.isLocked()).isFalse();
        Assertions.assertThat((boolean)lock2Node1.isLocked()).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lock1)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lock1)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lock1)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lock2)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lock2)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lock2)).isFalse();
        lock1OptionNode2 = this.lockManagerNode2.tryAcquireLock(lock1);
        lock2OptionNode2 = this.lockManagerNode2.tryAcquireLock(lock2);
        Assertions.assertThat((Optional)lock1OptionNode2).isPresent();
        Assertions.assertThat((boolean)((FencedLock)lock1OptionNode2.get()).isLocked()).isTrue();
        Assertions.assertThat((Long)((FencedLock)lock1OptionNode2.get()).getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue() + 1L);
        Assertions.assertThat((boolean)((FencedLock)lock1OptionNode2.get()).isLockedByThisLockManagerInstance()).isTrue();
        Assertions.assertThat((Optional)lock2OptionNode2).isPresent();
        Assertions.assertThat((Optional)lock2OptionNode2).isPresent();
        Assertions.assertThat((boolean)((FencedLock)lock2OptionNode2.get()).isLocked()).isTrue();
        Assertions.assertThat((Long)((FencedLock)lock2OptionNode2.get()).getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue() + 1L);
        Assertions.assertThat((boolean)((FencedLock)lock2OptionNode2.get()).isLockedByThisLockManagerInstance()).isTrue();
    }

    @Test
    void verify_that_acquireLockAsync_allows_us_to_acquire_locks_asynchronously() throws InterruptedException {
        LockName lockName = LockName.of((CharSequence)"testLock");
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isFalse();
        TestLockCallback lockNode1Callback = new TestLockCallback();
        TestLockCallback lockNode2Callback = new TestLockCallback();
        this.lockManagerNode1.acquireLockAsync(lockName, (LockCallback)lockNode1Callback);
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(2L)).untilAsserted(() -> Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue());
        this.lockManagerNode2.acquireLockAsync(lockName, (LockCallback)lockNode2Callback);
        Thread.sleep(1000L);
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((Object)lockNode1Callback.lockAcquired).isNotNull();
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLocked());
        Assertions.assertThat((CharSequence)lockNode1Callback.lockAcquired.getName()).isEqualTo((Object)lockName);
        Assertions.assertThat((Long)lockNode1Callback.lockAcquired.getCurrentToken()).isGreaterThanOrEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLockedByThisLockManagerInstance());
        Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNull();
        Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
        OffsetDateTime lastLockConfirmedTimestamp = ((FencedLock)this.lockManagerNode1.lookupLock(lockName).get()).getLockLastConfirmedTimestamp();
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(2L)).untilAsserted(() -> {
            Optional lock = this.lockManagerNode1.lookupLock(lockName);
            Assertions.assertThat((Optional)lock).isPresent();
            Assertions.assertThat((Long)((FencedLock)lock.get()).getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
            Assertions.assertThat((OffsetDateTime)((FencedLock)lock.get()).getLockLastConfirmedTimestamp()).isAfter(lastLockConfirmedTimestamp);
        });
        Optional lock = this.lockManagerNode2.lookupLock(lockName);
        Assertions.assertThat((Optional)lock).isPresent();
        Assertions.assertThat((OffsetDateTime)((FencedLock)lock.get()).getLockLastConfirmedTimestamp()).isAfter(lastLockConfirmedTimestamp);
        lockNode1Callback.lockAcquired.release();
        this.lockManagerNode1.pause();
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNotNull());
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNotNull();
        Assertions.assertThat((boolean)lockNode1Callback.lockReleased.isLocked()).isFalse();
        Assertions.assertThat((boolean)lockNode1Callback.lockReleased.isLockedByThisLockManagerInstance()).isFalse();
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNotNull());
        this.lockManagerNode1.resume();
        Assertions.assertThat((boolean)lockNode2Callback.lockAcquired.isLocked()).isTrue();
        Assertions.assertThat((CharSequence)lockNode2Callback.lockAcquired.getName()).isEqualTo((Object)lockName);
        Assertions.assertThat((boolean)lockNode2Callback.lockAcquired.isLockedByThisLockManagerInstance()).isTrue();
        Assertions.assertThat((OffsetDateTime)lockNode2Callback.lockAcquired.getLockAcquiredTimestamp()).isAfter(lastLockConfirmedTimestamp);
        Assertions.assertThat((Long)lockNode2Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue() + 1L);
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
    }

    @Test
    void verify_that_acquireLockAsync_allows_us_to_acquire_a_timedout_lock_asynchronously() throws InterruptedException {
        LockName lockName = LockName.of((CharSequence)"testLock");
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isFalse();
        TestLockCallback lockNode1Callback = new TestLockCallback();
        TestLockCallback lockNode2Callback = new TestLockCallback();
        this.lockManagerNode1.acquireLockAsync(lockName, (LockCallback)lockNode1Callback);
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue());
        this.lockManagerNode2.acquireLockAsync(lockName, (LockCallback)lockNode2Callback);
        Thread.sleep(1000L);
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((Object)lockNode1Callback.lockAcquired).isNotNull();
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLocked());
        Assertions.assertThat((CharSequence)lockNode1Callback.lockAcquired.getName()).isEqualTo((Object)lockName);
        Assertions.assertThat((Long)lockNode1Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLockedByThisLockManagerInstance());
        Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNull();
        Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
        this.lockManagerNode1.pause();
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNotNull());
        this.lockManagerNode1.resume();
        Assertions.assertThat((boolean)lockNode2Callback.lockAcquired.isLocked()).isTrue();
        Assertions.assertThat((CharSequence)lockNode2Callback.lockAcquired.getName()).isEqualTo((Object)lockName);
        Assertions.assertThat((Long)lockNode2Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue() + 1L);
        Assertions.assertThat((boolean)lockNode2Callback.lockAcquired.isLockedByThisLockManagerInstance()).isTrue();
        this.lockManagerNode1.resume();
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNotNull());
        Assertions.assertThat((boolean)lockNode1Callback.lockReleased.isLocked()).isFalse();
        Assertions.assertThat((boolean)lockNode1Callback.lockReleased.isLockedByThisLockManagerInstance()).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
    }

    @Test
    void verify_loosing_db_connection_no_locks_are_released() throws InterruptedException {
        LockName lockName = LockName.of((CharSequence)"testLock");
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isFalse();
        TestLockCallback lockNode1Callback = new TestLockCallback();
        TestLockCallback lockNode2Callback = new TestLockCallback();
        this.lockManagerNode1.acquireLockAsync(lockName, (LockCallback)lockNode1Callback);
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue());
        this.lockManagerNode2.acquireLockAsync(lockName, (LockCallback)lockNode2Callback);
        Thread.sleep(1000L);
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((Object)lockNode1Callback.lockAcquired).isNotNull();
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLocked());
        Assertions.assertThat((CharSequence)lockNode1Callback.lockAcquired.getName()).isEqualTo((Object)lockName);
        Assertions.assertThat((Long)lockNode1Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLockedByThisLockManagerInstance());
        Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNull();
        Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
        System.out.println("------ Disrupting the database connection ------");
        this.disruptDatabaseConnection();
        Thread.sleep(5000L);
        System.out.println("------ Checking the node 1 didn't release the lock ------");
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLocked()).isTrue();
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLockedByThisLockManagerInstance()).isTrue();
        Assertions.assertThat((Long)lockNode1Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNull();
        Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
        System.out.println("------ Restoring the database connection ------");
        this.restoreDatabaseConnection();
        Thread.sleep(7000L);
        System.out.println("------ Checking which node has the lock ------");
        if (lockNode1Callback.lockReleased != null) {
            System.out.println("====== Node 1 lost the lock and node 2 should have acquired it ======");
            Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNotNull();
            Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isTrue();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
            System.out.println("Lock token in DB " + ((FencedLock)this.lockManagerNode2.lookupLock(lockName).get()).getCurrentToken());
            Assertions.assertThat((Long)lockNode2Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode2.getInitialTokenValue() + 1L);
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        } else {
            System.out.println("====== Node 1 kept the lock and node 2 should not have acquired it ======");
            Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNull();
            Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
            Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
            Assertions.assertThat((Long)lockNode1Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        }
    }

    private static class TestLockCallback
    implements LockCallback {
        FencedLock lockReleased;
        FencedLock lockAcquired;

        private TestLockCallback() {
        }

        public void lockAcquired(FencedLock lock) {
            this.lockAcquired = lock;
        }

        public void lockReleased(FencedLock lock) {
            this.lockReleased = lock;
        }

        public void reset() {
            this.lockReleased = null;
            this.lockAcquired = null;
        }
    }
}

