/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.test.messaging.queue.test_data;

import dk.cloudcreate.essentials.components.foundation.test.messaging.queue.test_data.CustomerId;
import dk.cloudcreate.essentials.components.foundation.test.messaging.queue.test_data.OrderId;
import dk.cloudcreate.essentials.components.foundation.test.messaging.queue.test_data.ProductId;
import java.util.Objects;

public class OrderEvent {
    public final OrderId orderId;

    public OrderEvent(OrderId orderId) {
        this.orderId = orderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderEvent that = (OrderEvent)o;
        return this.orderId.equals((Object)that.orderId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderId});
    }

    public static class OrderAccepted
    extends OrderEvent {
        public OrderAccepted(OrderId orderId) {
            super(orderId);
        }
    }

    public static class ProductRemovedFromOrder
    extends OrderEvent {
        public final ProductId productId;

        public ProductRemovedFromOrder(OrderId orderId, ProductId productId) {
            super(orderId);
            this.productId = productId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ProductRemovedFromOrder that = (ProductRemovedFromOrder)o;
            return this.productId.equals((Object)that.productId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.productId});
        }
    }

    public static class ProductOrderQuantityAdjusted
    extends OrderEvent {
        public final ProductId productId;
        public final int newQuantity;

        public ProductOrderQuantityAdjusted(OrderId orderId, ProductId productId, int newQuantity) {
            super(orderId);
            this.productId = productId;
            this.newQuantity = newQuantity;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ProductOrderQuantityAdjusted that = (ProductOrderQuantityAdjusted)o;
            return this.newQuantity == that.newQuantity && this.productId.equals((Object)that.productId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.productId, this.newQuantity});
        }
    }

    public static class ProductAddedToOrder
    extends OrderEvent {
        public final ProductId productId;
        public final int quantity;

        public ProductAddedToOrder(OrderId orderId, ProductId productId, int quantity) {
            super(orderId);
            this.productId = productId;
            this.quantity = quantity;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ProductAddedToOrder that = (ProductAddedToOrder)o;
            return this.quantity == that.quantity && this.productId.equals((Object)that.productId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.productId, this.quantity});
        }
    }

    public static class OrderAdded
    extends OrderEvent {
        public final CustomerId orderingCustomerId;
        public final long orderNumber;

        public OrderAdded(OrderId orderId, CustomerId orderingCustomerId, long orderNumber) {
            super(orderId);
            this.orderingCustomerId = orderingCustomerId;
            this.orderNumber = orderNumber;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OrderAdded that = (OrderAdded)o;
            return this.orderNumber == that.orderNumber && this.orderingCustomerId.equals((Object)that.orderingCustomerId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.orderingCustomerId, this.orderNumber});
        }
    }
}

