/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.test.fencedlock;

import dk.cloudcreate.essentials.components.foundation.fencedlock.DBFencedLockManager;
import dk.cloudcreate.essentials.components.foundation.fencedlock.FencedLock;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockCallback;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockName;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DBFencedLockManager_MultiNode_ReleaseLockIT<LOCK_MANAGER extends DBFencedLockManager<?, ?>> {
    private LOCK_MANAGER lockManagerNode1;
    private LOCK_MANAGER lockManagerNode2;

    protected LOCK_MANAGER getLockManagerNode1() {
        return this.lockManagerNode1;
    }

    protected LOCK_MANAGER getLockManagerNode2() {
        return this.lockManagerNode2;
    }

    @BeforeEach
    void setup() {
        if (this.lockManagerNode1 != null) {
            throw new IllegalStateException("LockManager for node1 is non-null during setup");
        }
        if (this.lockManagerNode2 != null) {
            throw new IllegalStateException("LockManager for node2 is non-null during setup");
        }
        this.lockManagerNode1 = this.createLockManagerNode1();
        Assertions.assertThat(this.lockManagerNode1).isNotNull();
        this.lockManagerNode1.start();
        this.lockManagerNode1.deleteAllLocksInDB();
        this.lockManagerNode2 = this.createLockManagerNode2();
        Assertions.assertThat(this.lockManagerNode1).isNotNull();
        this.lockManagerNode2.start();
    }

    protected abstract LOCK_MANAGER createLockManagerNode2();

    protected abstract LOCK_MANAGER createLockManagerNode1();

    protected abstract void disruptDatabaseConnection();

    protected abstract void restoreDatabaseConnection();

    @AfterEach
    void cleanup() {
        System.out.println("*******  Cleaning up  *******");
        if (this.lockManagerNode1 != null) {
            this.lockManagerNode1.stop();
            this.lockManagerNode1 = null;
        }
        if (this.lockManagerNode2 != null) {
            this.lockManagerNode2.stop();
            this.lockManagerNode2 = null;
        }
    }

    @Test
    void verify_loosing_db_connection_all_locally_acquired_locks_are_released() throws InterruptedException {
        LockName lockName = LockName.of((CharSequence)"testLock");
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isFalse();
        TestLockCallback lockNode1Callback = new TestLockCallback();
        TestLockCallback lockNode2Callback = new TestLockCallback();
        this.lockManagerNode1.acquireLockAsync(lockName, (LockCallback)lockNode1Callback);
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue());
        this.lockManagerNode2.acquireLockAsync(lockName, (LockCallback)lockNode2Callback);
        Thread.sleep(1000L);
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
        Assertions.assertThat((Object)lockNode1Callback.lockAcquired).isNotNull();
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLocked());
        Assertions.assertThat((CharSequence)lockNode1Callback.lockAcquired.getName()).isEqualTo((Object)lockName);
        Assertions.assertThat((Long)lockNode1Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLockedByThisLockManagerInstance());
        Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNull();
        Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
        System.out.println("------ Disrupting the database connection ------");
        this.disruptDatabaseConnection();
        Thread.sleep(5000L);
        System.out.println("------ Checking the node 1 released the lock ------");
        Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNotNull();
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLocked()).isFalse();
        Assertions.assertThat((boolean)lockNode1Callback.lockAcquired.isLockedByThisLockManagerInstance()).isFalse();
        Assertions.assertThat((Long)lockNode1Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue());
        Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNull();
        Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
        System.out.println("------ Restoring the database connection ------");
        lockNode1Callback.reset();
        lockNode2Callback.reset();
        this.restoreDatabaseConnection();
        Thread.sleep(7000L);
        System.out.println("------ Checking which node has the lock ------");
        if (lockNode2Callback.lockAcquired != null) {
            System.out.println("====== Node 2 should have acquired the lock and node 1 should not have acquired it ======");
            Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNotNull();
            Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
            Assertions.assertThat((Object)lockNode1Callback.lockAcquired).isNull();
            Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isTrue();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
            Assertions.assertThat((Long)lockNode2Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode2.getInitialTokenValue() + 1L);
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isFalse();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        } else {
            System.out.println("====== Node 1 acquired the lock and node 2 should not have acquired it ======");
            Assertions.assertThat((Object)lockNode1Callback.lockAcquired).isNotNull();
            Assertions.assertThat((Object)lockNode1Callback.lockReleased).isNull();
            Assertions.assertThat((Object)lockNode2Callback.lockAcquired).isNull();
            Assertions.assertThat((Object)lockNode2Callback.lockReleased).isNull();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquiredByAnotherLockManagerInstance(lockName)).isFalse();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockedByThisLockManagerInstance(lockName)).isTrue();
            Assertions.assertThat((boolean)this.lockManagerNode1.isLockAcquired(lockName)).isTrue();
            Assertions.assertThat((Long)lockNode1Callback.lockAcquired.getCurrentToken()).isEqualTo(this.lockManagerNode1.getInitialTokenValue() + 1L);
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockedByThisLockManagerInstance(lockName)).isFalse();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquired(lockName)).isTrue();
            Assertions.assertThat((boolean)this.lockManagerNode2.isLockAcquiredByAnotherLockManagerInstance(lockName)).isTrue();
        }
    }

    private static class TestLockCallback
    implements LockCallback {
        FencedLock lockReleased;
        FencedLock lockAcquired;

        private TestLockCallback() {
        }

        public void lockAcquired(FencedLock lock) {
            this.lockAcquired = lock;
        }

        public void lockReleased(FencedLock lock) {
            this.lockReleased = lock;
        }

        public void reset() {
            this.lockReleased = null;
            this.lockAcquired = null;
        }
    }
}

