/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.test.messaging.queue;

import dk.cloudcreate.essentials.components.foundation.json.JSONSerializer;
import java.nio.charset.StandardCharsets;

public class ProxyJSONSerializer
implements JSONSerializer {
    private final JSONSerializer delegate;
    private boolean corruptJSONDuringDeserializationEnabled = false;
    private Class<?> onlyCorruptForPayloadType;

    public ProxyJSONSerializer(JSONSerializer delegate) {
        this.delegate = delegate;
    }

    public void enableJSONCorruptionDuringDeserialization(Class<?> payloadType) {
        this.corruptJSONDuringDeserializationEnabled = true;
        this.onlyCorruptForPayloadType = payloadType;
    }

    public void disableJSONCorruptionDuringDeserialization() {
        this.corruptJSONDuringDeserializationEnabled = false;
        this.onlyCorruptForPayloadType = null;
    }

    public String serialize(Object obj) {
        return this.delegate.serialize(obj);
    }

    public byte[] serializeAsBytes(Object obj) {
        return this.delegate.serializeAsBytes(obj);
    }

    public <T> T deserialize(String json, String javaType) {
        if (this.corruptJSONDuringDeserializationEnabled && javaType.equals(this.onlyCorruptForPayloadType.getName())) {
            json = json.substring(0, json.length() - 1);
            this.disableJSONCorruptionDuringDeserialization();
        }
        return (T)this.delegate.deserialize(json, javaType);
    }

    public <T> T deserialize(String json, Class<T> javaType) {
        if (this.corruptJSONDuringDeserializationEnabled && javaType.getName().equals(this.onlyCorruptForPayloadType.getName())) {
            json = json.substring(0, json.length() - 1);
            this.disableJSONCorruptionDuringDeserialization();
        }
        return (T)this.delegate.deserialize(json, javaType);
    }

    public <T> T deserialize(byte[] json, String javaType) {
        if (this.corruptJSONDuringDeserializationEnabled && javaType.equals(this.onlyCorruptForPayloadType.getName())) {
            String jsonStr = new String(json, StandardCharsets.UTF_8);
            jsonStr = jsonStr.substring(0, jsonStr.length() - 1);
            json = jsonStr.getBytes(StandardCharsets.UTF_8);
            this.disableJSONCorruptionDuringDeserialization();
        }
        return (T)this.delegate.deserialize(json, javaType);
    }

    public <T> T deserialize(byte[] json, Class<T> javaType) {
        if (this.corruptJSONDuringDeserializationEnabled && javaType.getName().equals(this.onlyCorruptForPayloadType.getName())) {
            String jsonStr = new String(json, StandardCharsets.UTF_8);
            jsonStr = jsonStr.substring(0, jsonStr.length() - 1);
            json = jsonStr.getBytes(StandardCharsets.UTF_8);
            this.disableJSONCorruptionDuringDeserialization();
        }
        return (T)this.delegate.deserialize(json, javaType);
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.delegate.setClassLoader(classLoader);
    }
}

