/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging;

import dk.cloudcreate.essentials.components.foundation.messaging.MessageDeliveryErrorHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import java.time.Duration;

public final class LinearBackoffBuilder {
    private Duration redeliveryDelay;
    private Duration maximumFollowupRedeliveryDelayThreshold;
    private int maximumNumberOfRedeliveries;
    private MessageDeliveryErrorHandler deliveryErrorHandler = MessageDeliveryErrorHandler.alwaysRetry();

    public LinearBackoffBuilder setRedeliveryDelay(Duration redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
        return this;
    }

    public LinearBackoffBuilder setMaximumFollowupRedeliveryDelayThreshold(Duration maximumFollowupRedeliveryDelayThreshold) {
        this.maximumFollowupRedeliveryDelayThreshold = maximumFollowupRedeliveryDelayThreshold;
        return this;
    }

    public LinearBackoffBuilder setMaximumNumberOfRedeliveries(int maximumNumberOfRedeliveries) {
        this.maximumNumberOfRedeliveries = maximumNumberOfRedeliveries;
        return this;
    }

    public LinearBackoffBuilder setDeliveryErrorHandler(MessageDeliveryErrorHandler deliveryErrorHandler) {
        this.deliveryErrorHandler = deliveryErrorHandler;
        return this;
    }

    public RedeliveryPolicy build() {
        return RedeliveryPolicy.builder().setInitialRedeliveryDelay(this.redeliveryDelay).setFollowupRedeliveryDelay(this.redeliveryDelay).setFollowupRedeliveryDelayMultiplier(1.0).setMaximumFollowupRedeliveryDelayThreshold(this.maximumFollowupRedeliveryDelayThreshold).setMaximumNumberOfRedeliveries(this.maximumNumberOfRedeliveries).setDeliveryErrorHandler(this.deliveryErrorHandler).build();
    }
}

