/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue.operations;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.Message;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.MessageMetaData;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessageBuilder;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.util.Optional;

public final class QueueMessage {
    public final QueueName queueName;
    private Message message;
    private Optional<Exception> causeOfEnqueuing;
    private Optional<Duration> deliveryDelay;

    public static QueueMessageBuilder builder() {
        return new QueueMessageBuilder();
    }

    public QueueMessage(QueueName queueName, Message message, Optional<Exception> causeOfEnqueuing, Optional<Duration> deliveryDelay) {
        this.queueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided"));
        this.message = (Message)((Object)FailFast.requireNonNull((Object)((Object)message), (String)"No message provided"));
        this.causeOfEnqueuing = (Optional)FailFast.requireNonNull(causeOfEnqueuing, (String)"No causeOfEnqueuing option provided");
        this.deliveryDelay = (Optional)FailFast.requireNonNull(deliveryDelay, (String)"No deliveryDelay option provided");
    }

    public QueueMessage(QueueName queueName, Message message, Exception causeOfEnqueuing, Duration deliveryDelay) {
        this(queueName, message, Optional.ofNullable(causeOfEnqueuing), Optional.ofNullable(deliveryDelay));
    }

    public QueueName getQueueName() {
        return this.queueName;
    }

    public Object getPayload() {
        return this.message.getPayload();
    }

    public Optional<Exception> getCauseOfEnqueuing() {
        return this.causeOfEnqueuing;
    }

    public Optional<Duration> getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public void setMessage(Message message) {
        this.message = (Message)((Object)FailFast.requireNonNull((Object)((Object)message), (String)"No message provided"));
    }

    public Message getMessage() {
        return this.message;
    }

    public void setDeliveryDelay(Optional<Duration> deliveryDelay) {
        this.deliveryDelay = (Optional)FailFast.requireNonNull(deliveryDelay, (String)"No deliveryDelay provided");
    }

    public MessageMetaData getMetaData() {
        return this.message.getMetaData();
    }

    public void setCauseOfEnqueuing(Optional<Exception> causeOfEnqueuing) {
        this.causeOfEnqueuing = (Optional)FailFast.requireNonNull(causeOfEnqueuing, (String)"No causeOfEnqueuing provided");
    }

    public void setDeliveryDelay(Duration deliveryDelay) {
        this.deliveryDelay = Optional.ofNullable(deliveryDelay);
    }

    public void setCauseOfEnqueuing(Exception causeOfEnqueuing) {
        this.causeOfEnqueuing = Optional.ofNullable(causeOfEnqueuing);
    }

    public String toString() {
        return "QueueMessage{queueName=" + this.queueName + ", message=" + this.message + ", causeOfEnqueuing=" + this.causeOfEnqueuing + ", deliveryDelay=" + this.deliveryDelay + "}";
    }
}

