/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.reactive.command;

import dk.cloudcreate.essentials.components.foundation.Lifecycle;
import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueueConsumer;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueues;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.Message;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.TransactionalMode;
import dk.cloudcreate.essentials.components.foundation.reactive.command.DurableLocalCommandBusBuilder;
import dk.cloudcreate.essentials.reactive.command.AbstractCommandBus;
import dk.cloudcreate.essentials.reactive.command.CommandHandler;
import dk.cloudcreate.essentials.reactive.command.SendAndDontWaitErrorHandler;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptor;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptorChain;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DurableLocalCommandBus
extends AbstractCommandBus
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(DurableLocalCommandBus.class);
    public static final QueueName DEFAULT_COMMAND_QUEUE_NAME = QueueName.of("DefaultCommandQueue");
    public static final RedeliveryPolicy DEFAULT_REDELIVERY_POLICY = RedeliveryPolicy.linearBackoff(Duration.ofMillis(150L), Duration.ofMillis(1000L), 20);
    private DurableQueues durableQueues;
    private int parallelSendAndDontWaitConsumers = 10;
    private QueueName commandQueueName = DEFAULT_COMMAND_QUEUE_NAME;
    private RedeliveryPolicy commandQueueRedeliveryPolicy = DEFAULT_REDELIVERY_POLICY;
    private boolean started;
    private DurableQueueConsumer durableQueueConsumer;

    public static DurableLocalCommandBusBuilder builder() {
        return new DurableLocalCommandBusBuilder();
    }

    public DurableLocalCommandBus(DurableQueues durableQueues) {
        super((SendAndDontWaitErrorHandler)new SendAndDontWaitErrorHandler.RethrowingSendAndDontWaitErrorHandler(), List.of());
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, QueueName commandQueueName, RedeliveryPolicy commandQueueRedeliveryPolicy) {
        super((SendAndDontWaitErrorHandler)new SendAndDontWaitErrorHandler.RethrowingSendAndDontWaitErrorHandler(), List.of());
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
        this.commandQueueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)commandQueueName), (String)"No commandQueueName provided"));
        this.commandQueueRedeliveryPolicy = (RedeliveryPolicy)FailFast.requireNonNull((Object)commandQueueRedeliveryPolicy, (String)"No commandQueueRedeliveryPolicy provided");
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler) {
        super(sendAndDontWaitErrorHandler, List.of());
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, QueueName commandQueueName, SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler) {
        super(sendAndDontWaitErrorHandler, List.of());
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
        this.commandQueueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)commandQueueName), (String)"No commandQueueName provided"));
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, List<CommandBusInterceptor> interceptors) {
        super((SendAndDontWaitErrorHandler)new SendAndDontWaitErrorHandler.RethrowingSendAndDontWaitErrorHandler(), interceptors);
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, QueueName commandQueueName, List<CommandBusInterceptor> interceptors) {
        super((SendAndDontWaitErrorHandler)new SendAndDontWaitErrorHandler.RethrowingSendAndDontWaitErrorHandler(), interceptors);
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
        this.commandQueueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)commandQueueName), (String)"No commandQueueName provided"));
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler, List<CommandBusInterceptor> interceptors) {
        super(sendAndDontWaitErrorHandler, interceptors);
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, int parallelSendAndDontWaitConsumers, QueueName commandQueueName, RedeliveryPolicy commandQueueRedeliveryPolicy, SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler, List<CommandBusInterceptor> interceptors) {
        super(sendAndDontWaitErrorHandler, interceptors);
        FailFast.requireTrue((parallelSendAndDontWaitConsumers >= 1 ? 1 : 0) != 0, (String)"parallelSendAndDontWaitConsumers is < 1");
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
        this.parallelSendAndDontWaitConsumers = parallelSendAndDontWaitConsumers;
        this.commandQueueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)commandQueueName), (String)"No commandQueueName provided"));
        this.commandQueueRedeliveryPolicy = (RedeliveryPolicy)FailFast.requireNonNull((Object)commandQueueRedeliveryPolicy, (String)"No commandQueueRedeliveryPolicy provided");
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, QueueName commandQueueName, SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler, List<CommandBusInterceptor> interceptors) {
        super(sendAndDontWaitErrorHandler, interceptors);
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
        this.commandQueueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)commandQueueName), (String)"No commandQueueName provided"));
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, CommandBusInterceptor ... interceptors) {
        this(durableQueues, List.of(interceptors));
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, QueueName commandQueueName, CommandBusInterceptor ... interceptors) {
        this(durableQueues, List.of(interceptors));
        this.commandQueueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)commandQueueName), (String)"No commandQueueName provided"));
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler, CommandBusInterceptor ... interceptors) {
        this(durableQueues, sendAndDontWaitErrorHandler, List.of(interceptors));
    }

    public DurableLocalCommandBus(DurableQueues durableQueues, int parallelSendAndDontWaitConsumers, QueueName commandQueueName, RedeliveryPolicy commandQueueRedeliveryPolicy, SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler, CommandBusInterceptor ... interceptors) {
        this(durableQueues, parallelSendAndDontWaitConsumers, commandQueueName, commandQueueRedeliveryPolicy, sendAndDontWaitErrorHandler, List.of(interceptors));
    }

    @Override
    public void start() {
        if (!this.started) {
            log.info("Starting...");
            this.started = true;
            this.durableQueueConsumer = this.durableQueues.consumeFromQueue(this.commandQueueName, this.commandQueueRedeliveryPolicy, this.parallelSendAndDontWaitConsumers, this::processSendAndDontWaitMessage);
            log.info("Started");
        }
    }

    @Override
    public void stop() {
        if (this.started) {
            log.info("Stopping...");
            this.started = false;
            if (this.durableQueueConsumer != null) {
                this.durableQueueConsumer.stop();
                this.durableQueueConsumer = null;
            }
            log.info("Stopped");
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public <C> void sendAndDontWait(C command) {
        this._sendAndDontWait(command, Optional.empty());
    }

    public <C> void sendAndDontWait(C command, Duration delayMessageDelivery) {
        this._sendAndDontWait(command, Optional.ofNullable(delayMessageDelivery));
    }

    private <C> void _sendAndDontWait(C command, Optional<Duration> messageDeliveryDelay) {
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        FailFast.requireNonNull(messageDeliveryDelay, (String)"You must provide a messageDeliveryDelay value");
        if (messageDeliveryDelay.isPresent()) {
            log.debug("[{}] Queuing Durable delayed {} sendAndDontWait for command of type '{}' to {} '{}'. TransactionalMode: {}", new Object[]{this.commandQueueName, messageDeliveryDelay, command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString(), this.durableQueues.getTransactionalMode()});
        } else {
            log.debug("[{}] Queuing Durable sendAndDontWait command of type '{}' to {} '{}'. TransactionalMode: {}", new Object[]{this.commandQueueName, command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString(), this.durableQueues.getTransactionalMode()});
        }
        if (this.durableQueues.getTransactionalMode() == TransactionalMode.FullyTransactional) {
            this.durableQueues.getUnitOfWorkFactory().get().usingUnitOfWork(() -> this.durableQueues.queueMessage(this.commandQueueName, Message.of(command), messageDeliveryDelay));
        } else {
            this.durableQueues.queueMessage(this.commandQueueName, Message.of(command), messageDeliveryDelay);
        }
    }

    private void processSendAndDontWaitMessage(QueuedMessage queuedMessage) {
        Object command = queuedMessage.getMessage().getPayload();
        CommandHandler commandHandler = this.findCommandHandlerCapableOfHandling(command);
        log.debug("[{}] Handling Durable sendAndDontWait command of type '{}' to {} '{}'", new Object[]{queuedMessage.getQueueName(), command.getClass().getName(), CommandHandler.class.getSimpleName(), commandHandler.toString()});
        CommandBusInterceptorChain.newInterceptorChain((Object)queuedMessage, (CommandHandler)commandHandler, (List)this.interceptors, (interceptor, commandBusInterceptorChain) -> {
            interceptor.interceptSendAndDontWait((Object)queuedMessage, commandBusInterceptorChain);
            return null;
        }, msg -> {
            try {
                return commandHandler.handle(command);
            }
            catch (Throwable e) {
                this.sendAndDontWaitErrorHandler.handleError(e, (Object)queuedMessage, commandHandler);
                return null;
            }
        }).proceed();
    }

    public int getParallelSendAndDontWaitConsumers() {
        return this.parallelSendAndDontWaitConsumers;
    }

    public QueueName getCommandQueueName() {
        return this.commandQueueName;
    }

    public RedeliveryPolicy getCommandQueueRedeliveryPolicy() {
        return this.commandQueueRedeliveryPolicy;
    }
}

