/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation;

import com.mongodb.MongoSocketException;
import dk.cloudcreate.essentials.shared.Exceptions;
import dk.cloudcreate.essentials.shared.FailFast;
import java.io.IOException;
import java.sql.SQLTransientException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdbi.v3.core.ConnectionException;

public final class IOExceptionUtil {
    private static final ConcurrentMap<String, Boolean> classCache = new ConcurrentHashMap<String, Boolean>();

    public static boolean isIOException(Throwable e) {
        FailFast.requireNonNull((Object)e, (String)"No exception provided");
        String message = e.getMessage() != null ? e.getMessage() : "";
        Throwable rootCause = Exceptions.getRootCause((Throwable)e);
        return e instanceof IOException || rootCause instanceof IOException || e instanceof SQLTransientException || rootCause instanceof SQLTransientException || IOExceptionUtil.containsKnownErrorMessage(message) || IOExceptionUtil.isJdbiRelatedException(e) || IOExceptionUtil.isMongoRelatedException(e);
    }

    private static boolean containsKnownErrorMessage(String message) {
        return message.contains("An I/O error occurred while sending to the backend") || message.contains("Could not open JDBC Connection for transaction") || message.contains("Connection is closed") || message.contains("Unable to acquire JDBC Connection") || message.contains("Could not open JPA EntityManager for transaction");
    }

    private static boolean isMongoRelatedException(Throwable e) {
        return IOExceptionUtil.isClassAvailable("com.mongodb.MongoSocketException") && Exceptions.doesStackTraceContainExceptionOfType((Throwable)e, MongoSocketException.class);
    }

    private static boolean isJdbiRelatedException(Throwable e) {
        return e.getClass().getName().equals("org.jdbi.v3.core.ConnectionException") || IOExceptionUtil.isClassAvailable("org.jdbi.v3.core.ConnectionException") && Exceptions.doesStackTraceContainExceptionOfType((Throwable)e, ConnectionException.class);
    }

    static boolean isClassAvailable(String className) {
        return classCache.computeIfAbsent(className, key -> {
            try {
                Class.forName(key);
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        });
    }
}

