/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.fencedlock;

import dk.cloudcreate.essentials.components.foundation.IOExceptionUtil;
import dk.cloudcreate.essentials.components.foundation.fencedlock.DBFencedLock;
import dk.cloudcreate.essentials.components.foundation.fencedlock.FencedLock;
import dk.cloudcreate.essentials.components.foundation.fencedlock.FencedLockEvents;
import dk.cloudcreate.essentials.components.foundation.fencedlock.FencedLockManager;
import dk.cloudcreate.essentials.components.foundation.fencedlock.FencedLockStorage;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockCallback;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockName;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkException;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkFactory;
import dk.cloudcreate.essentials.reactive.EventBus;
import dk.cloudcreate.essentials.shared.Exceptions;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.concurrent.ThreadFactoryBuilder;
import dk.cloudcreate.essentials.shared.functional.CheckedConsumer;
import dk.cloudcreate.essentials.shared.functional.CheckedFunction;
import dk.cloudcreate.essentials.shared.network.Network;
import java.time.Clock;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class DBFencedLockManager<UOW extends UnitOfWork, LOCK extends DBFencedLock>
implements FencedLockManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FencedLockStorage<UOW, LOCK> lockStorage;
    private final ConcurrentMap<LockName, LOCK> locksAcquiredByThisLockManager;
    private final ConcurrentMap<LockName, ScheduledFuture<?>> asyncLockAcquirings;
    private final Duration lockTimeOut;
    private final Duration lockConfirmationInterval;
    private final String lockManagerInstanceId;
    private final UnitOfWorkFactory<? extends UOW> unitOfWorkFactory;
    private final Optional<EventBus> eventBus;
    private final ReentrantLock reentrantLock = new ReentrantLock(true);
    private final boolean releaseAcquiredLocksInCaseOfIOExceptionsDuringLockConfirmation;
    private volatile boolean started;
    private volatile boolean stopping;
    private volatile boolean paused;
    private ScheduledExecutorService lockConfirmationExecutor;
    private ScheduledExecutorService asyncLockAcquiringExecutor;
    protected int syncAcquireLockPauseIntervalMs = 100;
    private ScheduledFuture<?> confirmationScheduledFuture;

    protected DBFencedLockManager(FencedLockStorage<UOW, LOCK> lockStorage, UnitOfWorkFactory<? extends UOW> unitOfWorkFactory, Optional<String> lockManagerInstanceId, Duration lockTimeOut, Duration lockConfirmationInterval, boolean releaseAcquiredLocksInCaseOfIOExceptionsDuringLockConfirmation, Optional<EventBus> eventBus) {
        FailFast.requireNonNull(lockManagerInstanceId, (String)"No lockManagerInstanceId option provided");
        this.lockStorage = (FencedLockStorage)FailFast.requireNonNull(lockStorage, (String)"No lockStorage provided");
        this.unitOfWorkFactory = (UnitOfWorkFactory)FailFast.requireNonNull(unitOfWorkFactory, (String)"No unitOfWorkFactory provided");
        this.lockManagerInstanceId = (String)FailFast.requireNonNull((Object)lockManagerInstanceId.orElseGet(Network::hostName), (String)"Couldn't resolve a LockManager instanceId");
        this.lockTimeOut = (Duration)FailFast.requireNonNull((Object)lockTimeOut, (String)"No lockTimeOut value provided");
        this.lockConfirmationInterval = (Duration)FailFast.requireNonNull((Object)lockConfirmationInterval, (String)"No lockConfirmationInterval value provided");
        if (lockConfirmationInterval.compareTo(lockTimeOut) >= 1) {
            throw new IllegalArgumentException(MessageFormatter.msg((String)"lockConfirmationInterval {} duration MUST not be larger than the lockTimeOut {} duration, because locks will then always timeout", (Object[])new Object[]{lockConfirmationInterval, lockTimeOut}));
        }
        this.releaseAcquiredLocksInCaseOfIOExceptionsDuringLockConfirmation = releaseAcquiredLocksInCaseOfIOExceptionsDuringLockConfirmation;
        this.eventBus = (Optional)FailFast.requireNonNull(eventBus, (String)"No eventBus option provided");
        this.locksAcquiredByThisLockManager = new ConcurrentHashMap<LockName, LOCK>();
        this.asyncLockAcquirings = new ConcurrentHashMap();
        this.log.info("[{}] Initializing '{}' using storage '{}' and lockConfirmationInterval: {} ms, lockTimeOut: {} ms", new Object[]{this.lockManagerInstanceId, this.getClass().getName(), lockStorage.getClass().getName(), lockConfirmationInterval.toMillis(), lockTimeOut.toMillis()});
        this.usingUnitOfWork(uow -> lockStorage.initializeLockStorage(this, uow), (CheckedConsumer<Throwable>)((CheckedConsumer)e -> {
            throw new IllegalStateException(MessageFormatter.msg((String)"[{}] Failed to initialize lock storage", (Object[])new Object[]{this.lockManagerInstanceId}), (Throwable)e);
        }));
    }

    public void start() {
        if (!this.started) {
            this.log.info("[{}] Starting lock manager", (Object)this.lockManagerInstanceId);
            this.stopping = false;
            this.lockConfirmationExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().nameFormat(this.lockManagerInstanceId + "-FencedLock-Confirmation-%d").daemon(true).build());
            this.asyncLockAcquiringExecutor = Executors.newScheduledThreadPool(2, ThreadFactoryBuilder.builder().nameFormat(this.lockManagerInstanceId + "-Lock-Acquiring-%d").daemon(true).build());
            this.confirmationScheduledFuture = this.lockConfirmationExecutor.scheduleAtFixedRate(this::confirmAllLocallyAcquiredLocks, this.lockConfirmationInterval.toMillis(), this.lockConfirmationInterval.toMillis(), TimeUnit.MILLISECONDS);
            this.started = true;
            this.log.info("[{}] Started lock manager", (Object)this.lockManagerInstanceId);
            this.notify(new FencedLockEvents.FencedLockManagerStarted(this));
        } else {
            this.log.debug("[{}] Lock Manager was already started", (Object)this.lockManagerInstanceId);
        }
    }

    protected void notify(FencedLockEvents event) {
        this.eventBus.ifPresent(localEventBus -> localEventBus.publish((Object)event));
    }

    public void pause() {
        this.log.info("[{}] Pausing async lock acquiring and lock confirmation", (Object)this.lockManagerInstanceId);
        this.paused = true;
    }

    public void resume() {
        this.log.info("[{}] Resuming async lock acquiring and lock confirmation", (Object)this.lockManagerInstanceId);
        this.paused = false;
    }

    private void confirmAllLocallyAcquiredLocks() {
        if (this.stopping) {
            this.log.debug("[{}] Shutting down, skipping confirmAllLocallyAcquiredLocks", (Object)this.lockManagerInstanceId);
            return;
        }
        if (this.locksAcquiredByThisLockManager.isEmpty()) {
            this.log.debug("[{}] No locks to confirm for this Lock Manager instance", (Object)this.lockManagerInstanceId);
            return;
        }
        if (this.paused) {
            this.log.info("[{}] Lock Manager is paused, skipping confirmAllLocallyAcquiredLocks", (Object)this.lockManagerInstanceId);
            return;
        }
        try {
            this.reentrantLock.lock();
            int numberOfLocallyAcquiredLocksBeforeConfirmation = this.locksAcquiredByThisLockManager.size();
            if (this.log.isTraceEnabled()) {
                this.log.trace("[{}] Confirming {} locks acquired by this Lock Manager Instance: {}", new Object[]{this.lockManagerInstanceId, numberOfLocallyAcquiredLocksBeforeConfirmation, this.locksAcquiredByThisLockManager.keySet()});
            } else {
                this.log.debug("[{}] Confirming {} locks acquired by this Lock Manager Instance", (Object)this.lockManagerInstanceId, (Object)numberOfLocallyAcquiredLocksBeforeConfirmation);
            }
            OffsetDateTime confirmedTimestamp = OffsetDateTime.now(Clock.systemUTC());
            this.usingUnitOfWork(uow -> this.locksAcquiredByThisLockManager.forEach((lockName, fencedLock) -> {
                if (fencedLock.getLockedByLockManagerInstanceId() == null) {
                    this.log.debug("[{}] Skipping confirming lock '{}' since lockedByLockManagerInstanceId is NULL: {}", new Object[]{this.lockManagerInstanceId, fencedLock.getName(), fencedLock});
                    return;
                }
                try {
                    this.log.trace("[{}] Attempting to confirm lock '{}': {}", new Object[]{this.lockManagerInstanceId, fencedLock.getName(), fencedLock});
                    boolean confirmedWithSuccess = false;
                    try {
                        confirmedWithSuccess = this.lockStorage.confirmLockInDB(this, (UnitOfWork)uow, (DBFencedLock)fencedLock, confirmedTimestamp);
                    }
                    catch (Exception e) {
                        if (IOExceptionUtil.isIOException(e)) {
                            if (this.releaseAcquiredLocksInCaseOfIOExceptionsDuringLockConfirmation) {
                                this.log.debug(MessageFormatter.msg((String)"[{}] IO related failure while attempting to perform confirmLockInDB for '{}' - will release lock: {}", (Object[])new Object[]{this.lockManagerInstanceId, fencedLock.getName(), fencedLock}), (Throwable)e);
                            }
                            this.log.debug(MessageFormatter.msg((String)"[{}] IO related failure while attempting to perform confirmLockInDB for '{}' - will retain lock: {}", (Object[])new Object[]{this.lockManagerInstanceId, fencedLock.getName(), fencedLock}), (Throwable)e);
                            return;
                        }
                        this.log.error(MessageFormatter.msg((String)"[{}] Technical failure while attempting to perform confirmLockInDB for '{}': {}", (Object[])new Object[]{this.lockManagerInstanceId, fencedLock.getName(), fencedLock}), (Throwable)e);
                    }
                    if (confirmedWithSuccess) {
                        fencedLock.markAsConfirmed(confirmedTimestamp);
                        this.log.debug("[{}] Confirmed lock '{}': {}", new Object[]{this.lockManagerInstanceId, fencedLock.getName(), fencedLock});
                        this.notify(new FencedLockEvents.LockAcquired((FencedLock)fencedLock, this));
                    } else {
                        this.log.info("[{}] Failed to confirm lock '{}': {}", new Object[]{this.lockManagerInstanceId, fencedLock.getName(), fencedLock});
                        try {
                            fencedLock.release();
                        }
                        catch (Exception e) {
                            this.log.error(MessageFormatter.msg((String)"[{}] Failed to release lock '{}'", (Object[])new Object[]{this.lockManagerInstanceId, fencedLock.getName()}), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error(MessageFormatter.msg((String)"[{}] Technical failure while trying to confirm lock '{}'", (Object[])new Object[]{this.lockManagerInstanceId, fencedLock.getName()}), (Throwable)e);
                }
            }), (CheckedConsumer<Throwable>)((CheckedConsumer)e -> {
                if (IOExceptionUtil.isIOException(e)) {
                    this.log.debug("[{}] Failed to acknowledge the {} locks acquired by this Lock Manager Instance", new Object[]{this.lockManagerInstanceId, this.locksAcquiredByThisLockManager.size(), e});
                } else {
                    this.log.error("[{}] Failed to acknowledge the {} locks acquired by this Lock Manager Instance", new Object[]{this.lockManagerInstanceId, this.locksAcquiredByThisLockManager.size(), e});
                }
                if (IOExceptionUtil.isIOException(e) && this.releaseAcquiredLocksInCaseOfIOExceptionsDuringLockConfirmation) {
                    this.log.info("[{}] Releasing all locally acquired locks due to IO Exception", (Object)this.lockManagerInstanceId);
                    this.locksAcquiredByThisLockManager.forEach((lockName, fencedLock) -> {
                        try {
                            fencedLock.release();
                        }
                        catch (Exception ex) {
                            this.log.error(MessageFormatter.msg((String)"[{}] Failed to release lock '{}'", (Object[])new Object[]{this.lockManagerInstanceId, fencedLock.getName()}), (Throwable)ex);
                        }
                    });
                }
            }));
            if (this.log.isTraceEnabled()) {
                this.log.trace("[{}] Completed confirmation of {} locks acquired by this Lock Manager Instance. Number of Locks acquired locally after confirmation {}: {}", new Object[]{this.lockManagerInstanceId, numberOfLocallyAcquiredLocksBeforeConfirmation, this.locksAcquiredByThisLockManager.size(), this.locksAcquiredByThisLockManager.keySet()});
            } else {
                this.log.debug("[{}] Completed confirmation of {} locks acquired by this Lock Manager Instance. Number of Locks acquired locally after confirmation {}", new Object[]{this.lockManagerInstanceId, numberOfLocallyAcquiredLocksBeforeConfirmation, this.locksAcquiredByThisLockManager.size()});
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    protected void releaseLock(LOCK lock) {
        FailFast.requireNonNull(lock, (String)"No lock was provided");
        if (this.locksAcquiredByThisLockManager.containsKey((Object)((DBFencedLock)lock).getName())) {
            this.log.debug("[{}] Releasing lock '{}': {}", new Object[]{this.lockManagerInstanceId, ((DBFencedLock)lock).getName(), lock});
            Boolean releaseWithSuccess = (Boolean)this.withUnitOfWork(uow -> this.lockStorage.releaseLockInDB(this, (UnitOfWork)uow, (DBFencedLock)lock), e -> {
                this.log.error("[{}] Failed to release lock '{}' in DB", new Object[]{this.lockManagerInstanceId, lock.getName(), e});
                return false;
            });
            this.log.trace("[{}] Removing {} DB released lock '{}' locally, marking and notifying it as released: {}", new Object[]{this.lockManagerInstanceId, releaseWithSuccess != false ? "successfully" : "failed", ((DBFencedLock)lock).getName(), lock});
            this.locksAcquiredByThisLockManager.remove((Object)((DBFencedLock)lock).getName());
            ((DBFencedLock)lock).markAsReleased();
            this.notify(new FencedLockEvents.LockReleased((FencedLock)lock, this));
            if (releaseWithSuccess.booleanValue()) {
                this.log.debug("[{}] Released Lock '{}': {}", new Object[]{this.lockManagerInstanceId, ((DBFencedLock)lock).getName(), lock});
            } else {
                this.log.trace("[{}] Checking '{}' lock status in the DB", (Object)this.lockManagerInstanceId, (Object)((DBFencedLock)lock).getName());
                this.usingUnitOfWork(uow -> this.lockStorage.lookupLockInDB(this, (UnitOfWork)uow, lock.getName()).ifPresent(lockAcquiredByAnotherLockManager -> this.log.debug("[{}] Post release of Lock '{}' DB reported current-owner status: {}", new Object[]{this.lockManagerInstanceId, lock.getName(), lockAcquiredByAnotherLockManager})), (CheckedConsumer<Throwable>)((CheckedConsumer)e -> this.log.debug("[{}] Post release of Lock '{}' - failed to look-up in the DB which node has acquired the lock", new Object[]{this.lockManagerInstanceId, lock.getName(), e})));
            }
            this.log.trace("[{}] Completed releasing lock '{}'", (Object)this.lockManagerInstanceId, (Object)((DBFencedLock)lock).getName());
        }
    }

    @Override
    public Optional<FencedLock> lookupLock(LockName lockName) {
        FailFast.requireNonNull((Object)((Object)lockName), (String)"No lockName provided");
        if (!this.started) {
            throw new IllegalStateException(MessageFormatter.msg((String)"The {} isn't started", (Object[])new Object[]{this.getClass().getSimpleName()}));
        }
        Optional fencedLock = (Optional)this.withUnitOfWork(uow -> this.lockStorage.lookupLockInDB(this, (UnitOfWork)uow, lockName).map(FencedLock.class::cast), e -> {
            this.log.trace("[{}] Failed to lookup lock '{}'", new Object[]{this.lockManagerInstanceId, lockName, e});
            return Optional.empty();
        });
        this.log.trace("[{}] Lookup FencedLock with name '{}' result: {}", new Object[]{this.lockManagerInstanceId, lockName, fencedLock});
        return fencedLock;
    }

    public void stop() {
        if (this.started) {
            this.log.info("[{}] Stopping lock manager", (Object)this.lockManagerInstanceId);
            this.stopping = true;
            if (this.confirmationScheduledFuture != null) {
                this.log.debug("[{}] Stopping confirmationScheduledFuture", (Object)this.lockManagerInstanceId);
                this.confirmationScheduledFuture.cancel(true);
                this.confirmationScheduledFuture = null;
                this.log.debug("[{}] Stopped confirmationScheduledFuture", (Object)this.lockManagerInstanceId);
            }
            this.locksAcquiredByThisLockManager.values().forEach(lock -> {
                this.log.debug("[{}] Releasing acquired Lock '{}' due to Stopping", (Object)this.lockManagerInstanceId, (Object)lock.getName());
                try {
                    lock.release();
                }
                catch (Exception e) {
                    if (IOExceptionUtil.isIOException(e)) {
                        this.log.debug(MessageFormatter.msg((String)"[{}] Failed to release FencedLock with name '{}'", (Object[])new Object[]{this.lockManagerInstanceId, lock.getName()}), (Throwable)e);
                    }
                    this.log.warn(MessageFormatter.msg((String)"[{}] Failed to release FencedLock with name '{}'", (Object[])new Object[]{this.lockManagerInstanceId, lock.getName()}), (Throwable)e);
                }
            });
            this.locksAcquiredByThisLockManager.clear();
            this.asyncLockAcquirings.forEach((lockName, scheduledFuture) -> {
                this.log.debug("[{}] Cancelling acquiring of Lock '{}' due to Stopping", (Object)this.lockManagerInstanceId, (Object)lockName);
                try {
                    scheduledFuture.cancel(true);
                }
                catch (Exception e) {
                    if (IOExceptionUtil.isIOException(e)) {
                        this.log.debug(MessageFormatter.msg((String)"[{}] Failed to stop acquiring of FencedLock with name '{}'", (Object[])new Object[]{this.lockManagerInstanceId, lockName}), (Throwable)e);
                    }
                    this.log.warn(MessageFormatter.msg((String)"[{}] Failed to stop acquiring of FencedLock with name '{}'", (Object[])new Object[]{this.lockManagerInstanceId, lockName}), (Throwable)e);
                }
            });
            this.asyncLockAcquirings.clear();
            if (this.asyncLockAcquiringExecutor != null) {
                this.log.debug("[{}] Shutting down asyncLockAcquiringExecutor", (Object)this.lockManagerInstanceId);
                this.asyncLockAcquiringExecutor.shutdownNow();
                this.asyncLockAcquiringExecutor = null;
                this.log.debug("[{}] Shutdown asyncLockAcquiringExecutor", (Object)this.lockManagerInstanceId);
            }
            if (this.lockConfirmationExecutor != null) {
                this.log.debug("[{}] Shutting down lockConfirmationExecutor", (Object)this.lockManagerInstanceId);
                this.lockConfirmationExecutor.shutdownNow();
                this.lockConfirmationExecutor = null;
                this.log.debug("[{}] Shutdown lockConfirmationExecutor", (Object)this.lockManagerInstanceId);
            }
            this.started = false;
            this.stopping = false;
            this.log.info("[{}] Stopped lock manager", (Object)this.lockManagerInstanceId);
            this.notify(new FencedLockEvents.FencedLockManagerStopped(this));
        } else {
            this.log.info("[{}] Lock Manager was already stopped", (Object)this.lockManagerInstanceId);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public Optional<FencedLock> tryAcquireLock(LockName lockName) {
        DBFencedLock result = (DBFencedLock)this._tryAcquireLock(lockName).block();
        return Optional.ofNullable(result);
    }

    @Override
    public Optional<FencedLock> tryAcquireLock(LockName lockName, Duration timeout) {
        FailFast.requireNonNull((Object)timeout, (String)"No timeout value provided");
        return Optional.ofNullable((FencedLock)this._tryAcquireLock(lockName).repeatWhenEmpty(longFlux -> longFlux.delayElements(Duration.ofMillis(this.syncAcquireLockPauseIntervalMs))).onErrorReturn(null).block(timeout));
    }

    private Mono<LOCK> _tryAcquireLock(LockName lockName) {
        FailFast.requireNonNull((Object)((Object)lockName), (String)"No lockName provided");
        if (!this.started) {
            throw new IllegalStateException(MessageFormatter.msg((String)"The {} isn't started", (Object[])new Object[]{this.getClass().getSimpleName()}));
        }
        this.log.debug("[{}] Attempting to acquire lock '{}'", (Object)this.lockManagerInstanceId, (Object)lockName);
        DBFencedLock alreadyAcquiredLock = (DBFencedLock)this.locksAcquiredByThisLockManager.get((Object)lockName);
        if (alreadyAcquiredLock != null && alreadyAcquiredLock.isLocked() && !this.isLockTimedOut(alreadyAcquiredLock)) {
            if (alreadyAcquiredLock.isLockedByThisLockManagerInstance()) {
                this.log.debug("[{}] Returned cached locally acquired lock '{}", (Object)this.lockManagerInstanceId, (Object)lockName);
                return Mono.just((Object)alreadyAcquiredLock);
            }
            this.releaseLock(alreadyAcquiredLock);
        }
        return (Mono)this.withUnitOfWork(uow -> {
            DBFencedLock lock = this.lockStorage.lookupLockInDB(this, (UnitOfWork)uow, lockName).orElseGet(() -> this.lockStorage.createUninitializedLock(this, lockName));
            return this.resolveLock(uow, lock);
        }, e -> {
            this.log.debug("[{}] Failed to lookup lock '{}'", new Object[]{this.lockManagerInstanceId, lockName, e});
            return Mono.empty();
        });
    }

    private Mono<LOCK> resolveLock(UOW uow, LOCK existingLock) {
        FailFast.requireNonNull(uow, (String)"No uow provided");
        FailFast.requireNonNull(existingLock, (String)"No existingLock provided");
        if (((DBFencedLock)existingLock).isLocked()) {
            if (((DBFencedLock)existingLock).isLockedByThisLockManagerInstance()) {
                this.log.debug("[{}] Will try to confirm Lock as the DB reports the lock '{}' was already acquired by this JVM node: '{}'", new Object[]{this.lockManagerInstanceId, ((DBFencedLock)existingLock).getName(), existingLock});
            }
            if (this.isLockTimedOut(existingLock)) {
                OffsetDateTime now = OffsetDateTime.now(Clock.systemUTC());
                LOCK newLock = this.lockStorage.createInitializedLock(this, ((DBFencedLock)existingLock).getName(), ((DBFencedLock)existingLock).getCurrentToken() + 1L, this.lockManagerInstanceId, now, now);
                this.log.debug("[{}] Found a TIMED-OUT lock '{}', that was acquired by Lock Manager '{}'. Will attempt to acquire the lock. Timed-out lock: {} - New lock: {}", new Object[]{this.lockManagerInstanceId, ((DBFencedLock)existingLock).getName(), ((DBFencedLock)existingLock).getLockedByLockManagerInstanceId(), existingLock, newLock});
                return this.updateLock(uow, existingLock, newLock);
            }
            return Mono.empty();
        }
        if (Objects.equals(((DBFencedLock)existingLock).getCurrentToken(), this.lockStorage.getUninitializedTokenValue())) {
            return this.insertLock(uow, existingLock);
        }
        OffsetDateTime now = OffsetDateTime.now(Clock.systemUTC());
        LOCK newLock = this.lockStorage.createInitializedLock(this, ((DBFencedLock)existingLock).getName(), ((DBFencedLock)existingLock).getCurrentToken() + 1L, this.lockManagerInstanceId, now, now);
        this.log.debug("[{}] Found un-acquired lock '{}'. Have Acquired lock. Existing lock: {} - New lock: {}", new Object[]{this.lockManagerInstanceId, ((DBFencedLock)existingLock).getName(), existingLock, newLock});
        return this.updateLock(uow, existingLock, newLock);
    }

    private Mono<LOCK> insertLock(UOW uow, LOCK initialLock) {
        FailFast.requireNonNull(uow, (String)"No uow provided");
        FailFast.requireNonNull(initialLock, (String)"No initialLock provided");
        OffsetDateTime now = OffsetDateTime.now(Clock.systemUTC());
        boolean insertedSuccessfully = this.lockStorage.insertLockIntoDB(this, uow, initialLock, now);
        if (insertedSuccessfully) {
            ((DBFencedLock)initialLock).markAsLocked(now, this.lockManagerInstanceId, this.lockStorage.getInitialTokenValue());
            this.log.debug("[{}] Acquired lock '{}' for the first time (insert): {}", new Object[]{this.lockManagerInstanceId, ((DBFencedLock)initialLock).getName(), initialLock});
            this.locksAcquiredByThisLockManager.put(((DBFencedLock)initialLock).getName(), initialLock);
            this.notify(new FencedLockEvents.LockAcquired((FencedLock)initialLock, this));
            return Mono.just(initialLock);
        }
        this.log.debug("[{}] Failed to acquire lock '{}' for the first time (insert)", (Object)this.lockManagerInstanceId, (Object)((DBFencedLock)initialLock).getName());
        return Mono.empty();
    }

    private Mono<LOCK> updateLock(UOW uow, LOCK timedOutLock, LOCK newLockReadyToBeAcquiredLocally) {
        FailFast.requireNonNull(uow, (String)"No uow provided");
        FailFast.requireNonNull(timedOutLock, (String)"No timedOutLock provided");
        FailFast.requireNonNull(newLockReadyToBeAcquiredLocally, (String)"No newLockReadyToBeAcquiredLocally provided");
        boolean updatedSuccessfully = this.lockStorage.updateLockInDB(this, uow, timedOutLock, newLockReadyToBeAcquiredLocally);
        if (updatedSuccessfully) {
            this.log.debug("[{}] Acquired lock '{}' (update): {}", new Object[]{this.lockManagerInstanceId, ((DBFencedLock)timedOutLock).getName(), newLockReadyToBeAcquiredLocally});
            this.locksAcquiredByThisLockManager.put(((DBFencedLock)timedOutLock).getName(), newLockReadyToBeAcquiredLocally);
            ((DBFencedLock)newLockReadyToBeAcquiredLocally).markAsLocked(((DBFencedLock)newLockReadyToBeAcquiredLocally).getLockAcquiredTimestamp(), ((DBFencedLock)newLockReadyToBeAcquiredLocally).getLockedByLockManagerInstanceId(), ((DBFencedLock)newLockReadyToBeAcquiredLocally).getCurrentToken());
            this.notify(new FencedLockEvents.LockAcquired((FencedLock)newLockReadyToBeAcquiredLocally, this));
            return Mono.just(newLockReadyToBeAcquiredLocally);
        }
        this.log.debug("[{}] Didn't acquire timed out lock '{}', someone else acquired it or confirmed it in the mean time (update): {}", new Object[]{this.lockManagerInstanceId, ((DBFencedLock)timedOutLock).getName(), this.lockStorage.lookupLockInDB(this, uow, ((DBFencedLock)timedOutLock).getName())});
        return Mono.empty();
    }

    private boolean isLockTimedOut(LOCK lock) {
        FailFast.requireNonNull(lock, (String)"No lock provided");
        Duration durationSinceLastConfirmation = ((DBFencedLock)lock).getDurationSinceLastConfirmation();
        return durationSinceLastConfirmation.compareTo(this.lockTimeOut) >= 1;
    }

    @Override
    public FencedLock acquireLock(LockName lockName) {
        return (FencedLock)this._tryAcquireLock(lockName).repeatWhenEmpty(longFlux -> longFlux.delayElements(Duration.ofMillis(this.syncAcquireLockPauseIntervalMs))).onErrorStop().block();
    }

    @Override
    public boolean isLockAcquired(LockName lockName) {
        Optional lock = (Optional)this.withUnitOfWork(uow -> this.lockStorage.lookupLockInDB(this, (UnitOfWork)uow, lockName), e -> {
            this.log.debug("[{}] Failed to lookup lock '{}'", new Object[]{this.lockManagerInstanceId, lockName, e});
            return Optional.empty();
        });
        return lock.map(FencedLock::isLocked).orElse(false);
    }

    @Override
    public boolean isLockedByThisLockManagerInstance(LockName lockName) {
        Optional lock = (Optional)this.withUnitOfWork(uow -> this.lockStorage.lookupLockInDB(this, (UnitOfWork)uow, lockName), e -> {
            this.log.debug("[{}] Failed to lookup lock '{}'", new Object[]{this.lockManagerInstanceId, lockName, e});
            return Optional.empty();
        });
        return lock.map(FencedLock::isLockedByThisLockManagerInstance).orElse(false);
    }

    @Override
    public boolean isLockAcquiredByAnotherLockManagerInstance(LockName lockName) {
        Optional lock = (Optional)this.withUnitOfWork(uow -> this.lockStorage.lookupLockInDB(this, (UnitOfWork)uow, lockName), e -> {
            this.log.debug("[{}] Failed to lookup lock '{}'", new Object[]{this.lockManagerInstanceId, lockName, e});
            return Optional.empty();
        });
        return lock.map(value -> value.isLocked() && !value.isLockedByThisLockManagerInstance()).orElse(false);
    }

    @Override
    public void acquireLockAsync(LockName lockName, LockCallback lockCallback) {
        FailFast.requireNonNull((Object)((Object)lockName), (String)"You must supply a lockName");
        FailFast.requireNonNull((Object)lockCallback, (String)"You must supply a lockCallback");
        this.asyncLockAcquirings.computeIfAbsent(lockName, _lockName -> {
            this.log.debug("[{}] Starting async Lock acquiring for lock '{}'", (Object)this.lockManagerInstanceId, (Object)lockName);
            return this.asyncLockAcquiringExecutor.scheduleAtFixedRate(() -> {
                block17: {
                    try {
                        this.reentrantLock.lock();
                        if (!this.started) {
                            return;
                        }
                        DBFencedLock existingLock = (DBFencedLock)this.locksAcquiredByThisLockManager.get((Object)lockName);
                        if (existingLock == null) {
                            Optional<FencedLock> lock;
                            if (this.paused) {
                                this.log.info("[{}] Lock Manager is paused, skipping async acquiring for lock '{}'", (Object)this.lockManagerInstanceId, (Object)lockName);
                                return;
                            }
                            try {
                                lock = this.tryAcquireLock(lockName);
                            }
                            catch (Exception e) {
                                this.log.error(MessageFormatter.msg((String)"[{}] Technical error while performing tryAcquireLock for lock '{}'", (Object[])new Object[]{this.lockManagerInstanceId, lockName}), (Throwable)e);
                                this.reentrantLock.unlock();
                                return;
                            }
                            if (lock.isPresent()) {
                                this.log.debug("[{}] Async Acquired lock '{}'", (Object)this.lockManagerInstanceId, (Object)lockName);
                                FencedLock fencedLock = lock.get();
                                fencedLock.registerCallback(lockCallback);
                                this.locksAcquiredByThisLockManager.put(lockName, (DBFencedLock)fencedLock);
                                lockCallback.lockAcquired(lock.get());
                            } else if (this.log.isTraceEnabled()) {
                                this.log.trace("[{}] Couldn't async Acquire lock '{}' as it is acquired by another Lock Manager instance: {}", new Object[]{this.lockManagerInstanceId, lockName, this.lookupLock(lockName)});
                            }
                            break block17;
                        }
                        if (!existingLock.isLockedByThisLockManagerInstance()) {
                            this.log.debug("[{}] Noticed that lock '{}' isn't locked by this Lock Manager instance anymore. Releasing the lock", (Object)this.lockManagerInstanceId, (Object)lockName);
                            this.locksAcquiredByThisLockManager.remove((Object)lockName);
                            lockCallback.lockReleased(existingLock);
                        }
                    }
                    catch (Exception e) {
                        this.log.error(MessageFormatter.msg((String)"[{}] Technical error while trying to acquire lock '{}'", (Object[])new Object[]{this.lockManagerInstanceId, lockName}), (Throwable)e);
                    }
                    finally {
                        this.reentrantLock.unlock();
                    }
                }
            }, 0L, this.lockConfirmationInterval.toMillis(), TimeUnit.MILLISECONDS);
        });
    }

    @Override
    public void cancelAsyncLockAcquiring(LockName lockName) {
        FailFast.requireNonNull((Object)((Object)lockName), (String)"You must supply a lockName");
        ScheduledFuture scheduledFuture = (ScheduledFuture)this.asyncLockAcquirings.remove((Object)lockName);
        if (scheduledFuture != null) {
            this.log.debug("[{}] Canceling async Lock acquiring for lock '{}'", (Object)this.lockManagerInstanceId, (Object)lockName);
            scheduledFuture.cancel(true);
            DBFencedLock acquiredLock = (DBFencedLock)this.locksAcquiredByThisLockManager.get((Object)lockName);
            if (acquiredLock != null) {
                this.log.debug("[{}] Releasing Lock due to cancelling the lock acquiring '{}'", (Object)this.lockManagerInstanceId, (Object)lockName);
                acquiredLock.release();
            }
        }
    }

    @Override
    public String getLockManagerInstanceId() {
        return this.lockManagerInstanceId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{lockManagerInstanceId='" + this.lockManagerInstanceId + "'}";
    }

    public Long getUninitializedTokenValue() {
        return this.lockStorage.getUninitializedTokenValue();
    }

    public long getInitialTokenValue() {
        return this.lockStorage.getInitialTokenValue();
    }

    public void deleteAllLocksInDB() {
        this.usingUnitOfWork(uow -> this.lockStorage.deleteAllLocksInDB(this, (UnitOfWork)uow), (CheckedConsumer<Throwable>)((CheckedConsumer)e -> {
            throw new UnitOfWorkException(MessageFormatter.msg((String)"[{}] Failed to delete all Locks in the lock storage", (Object[])new Object[]{this.lockManagerInstanceId}), (Throwable)e);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void usingUnitOfWork(CheckedConsumer<UOW> unitOfWorkConsumer, CheckedConsumer<Throwable> onError) {
        this.reentrantLock.lock();
        try {
            this.unitOfWorkFactory.usingUnitOfWork(arg_0 -> unitOfWorkConsumer.accept(arg_0));
        }
        catch (Throwable e) {
            Exceptions.rethrowIfCriticalError((Throwable)e);
            this.log.debug(MessageFormatter.msg((String)"[{}] Technical error performing usingUnitOfWork", (Object[])new Object[]{this.lockManagerInstanceId}), e);
            try {
                onError.accept((Object)e);
            }
            catch (Exception subException) {
                throw new UnitOfWorkException(MessageFormatter.msg((String)"[{}] Technical error while handling onError related to a usingUnitOfWork call that failed with '{}'", (Object[])new Object[]{this.lockManagerInstanceId, e.getMessage()}), subException);
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    protected <R> R withUnitOfWork(CheckedFunction<UOW, R> unitOfWorkFunction, CheckedFunction<Throwable, R> onError) {
        this.reentrantLock.lock();
        try {
            Object r = this.unitOfWorkFactory.withUnitOfWork(arg_0 -> unitOfWorkFunction.apply(arg_0));
            return r;
        }
        catch (Throwable e) {
            Object object;
            Exceptions.rethrowIfCriticalError((Throwable)e);
            this.log.debug(MessageFormatter.msg((String)"[{}] Technical error performing withUnitOfWork", (Object[])new Object[]{this.lockManagerInstanceId}), e);
            try {
                object = onError.apply((Object)e);
            }
            catch (Exception subException) {
                throw new UnitOfWorkException(MessageFormatter.msg((String)"[{}] Technical error handling onError related to a withUnitOfWork call that failed with '{}'", (Object[])new Object[]{this.lockManagerInstanceId, e.getMessage()}), subException);
            }
            return (R)object;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }
}

