/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.interceptor.micrometer;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptor;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptorChain;
import dk.cloudcreate.essentials.shared.measurement.LogThresholds;
import dk.cloudcreate.essentials.shared.measurement.LoggingMeasurementRecorder;
import dk.cloudcreate.essentials.shared.measurement.MeasurementRecorder;
import dk.cloudcreate.essentials.shared.measurement.MeasurementTaker;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class RecordExecutionTimeCommandBusInterceptor
implements CommandBusInterceptor {
    private final MeasurementTaker measurementTaker;
    public static final String MODULE_TAG_NAME = "Module";
    public static final String METRIC_PREFIX = "essentials.reactive.commandbus";
    private final boolean recordExecutionTimeEnabled;
    private final String moduleTag;

    public RecordExecutionTimeCommandBusInterceptor(Optional<MeterRegistry> meterRegistryOptional, boolean recordExecutionTimeEnabled, LogThresholds thresholds, String moduleTag) {
        this.recordExecutionTimeEnabled = recordExecutionTimeEnabled;
        this.moduleTag = moduleTag;
        this.measurementTaker = MeasurementTaker.builder().addRecorder((MeasurementRecorder)new LoggingMeasurementRecorder(LoggerFactory.getLogger(this.getClass()), thresholds)).withOptionalMicrometerMeasurementRecorder(meterRegistryOptional).build();
    }

    public Object interceptSend(Object command, CommandBusInterceptorChain commandBusInterceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return this.measurementTaker.context("essentials.reactive.commandbus.send").description("Time taken to handle a command sent using send").tag("command_type", command.getClass().getName()).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> ((CommandBusInterceptorChain)commandBusInterceptorChain).proceed());
        }
        return commandBusInterceptorChain.proceed();
    }

    public Object interceptSendAsync(Object command, CommandBusInterceptorChain commandBusInterceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return this.measurementTaker.context("essentials.reactive.commandbus.sendAsync").description("Time taken to handle a command sent using sendAsync").tag("command_type", command.getClass().getName()).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> ((CommandBusInterceptorChain)commandBusInterceptorChain).proceed());
        }
        return commandBusInterceptorChain.proceed();
    }

    public void interceptSendAndDontWait(Object commandMessage, CommandBusInterceptorChain commandBusInterceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            QueuedMessage queuedMessage;
            String commandType = commandMessage.getClass().getName();
            if (commandMessage instanceof QueuedMessage && (queuedMessage = (QueuedMessage)commandMessage).getMessage().getPayload() != null) {
                commandType = queuedMessage.getMessage().getPayload().getClass().getName();
            }
            this.measurementTaker.context("essentials.reactive.commandbus.sendAndDontWait").description("Time taken to handle a command sent using sendAndDontWait").tag("command_type", commandType).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> ((CommandBusInterceptorChain)commandBusInterceptorChain).proceed());
        } else {
            commandBusInterceptorChain.proceed();
        }
    }
}

