/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.interceptor.micrometer;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueues;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueuesInterceptor;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.AcknowledgeMessageAsHandled;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetNextMessageReadyForDelivery;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.HandleQueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.MarkAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessages;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.RetryMessage;
import dk.cloudcreate.essentials.shared.interceptor.InterceptorChain;
import dk.cloudcreate.essentials.shared.measurement.LogThresholds;
import dk.cloudcreate.essentials.shared.measurement.LoggingMeasurementRecorder;
import dk.cloudcreate.essentials.shared.measurement.MeasurementRecorder;
import dk.cloudcreate.essentials.shared.measurement.MeasurementTaker;
import dk.cloudcreate.essentials.shared.reflection.FunctionalInterfaceLoggingNameResolver;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class RecordExecutionTimeDurableQueueInterceptor
implements DurableQueuesInterceptor {
    public static final String MODULE_TAG_NAME = "Module";
    public static final String METRIC_PREFIX = "essentials.messaging.durable_queues";
    private static final QueueName UNKNOWN_QUEUE_NAME = QueueName.of("?");
    public static final String HANDLE_QUEUED_MSG = "handle_queued_message";
    public static final String GET_NEXT_MSG_RDY = "get_next_message_ready_for_delivery";
    public static final String QUEUE_MSG = "queue_message";
    public static final String QUEUE_MSGS = "queue_messages";
    public static final String ACK_MSG = "acknowledge_message_as_handled";
    public static final String RETRY_MSG = "retry_message";
    public static final String MARK_MSG = "mark_as_dead_letter_message";
    public static final String QUEUE_NAME = "queue_name";
    public static final String MESSAGE_PAYLOAD_TYPE = "message_payload_type";
    private DurableQueues durableQueues;
    private final String moduleTag;
    private final MeasurementTaker measurementTaker;
    private final boolean recordExecutionTimeEnabled;

    public RecordExecutionTimeDurableQueueInterceptor(Optional<MeterRegistry> meterRegistryOptional, boolean recordExecutionTimeEnabled, LogThresholds thresholds, String moduleTag) {
        this.recordExecutionTimeEnabled = recordExecutionTimeEnabled;
        this.moduleTag = moduleTag;
        this.measurementTaker = MeasurementTaker.builder().addRecorder((MeasurementRecorder)new LoggingMeasurementRecorder(LoggerFactory.getLogger(this.getClass()), thresholds)).withOptionalMicrometerMeasurementRecorder(meterRegistryOptional).build();
    }

    @Override
    public void setDurableQueues(DurableQueues durableQueues) {
        this.durableQueues = durableQueues;
    }

    @Override
    public Void intercept(HandleQueuedMessage operation, InterceptorChain<HandleQueuedMessage, Void, DurableQueuesInterceptor> interceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return (Void)this.measurementTaker.context("essentials.messaging.durable_queues.handle_queued_message").description("Time taken to handle a queued message by the QueuedMessageHandler").tag("message_handler", FunctionalInterfaceLoggingNameResolver.resolveLoggingName((Object)operation.messageHandler)).tag(MESSAGE_PAYLOAD_TYPE, operation.getMessage().getPayload() != null ? operation.getMessage().getPayload().getClass().getName() : "?").tag(QUEUE_NAME, (CharSequence)((Object)operation.message.getQueueName())).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> interceptorChain.proceed());
        }
        return (Void)interceptorChain.proceed();
    }

    @Override
    public Optional<QueuedMessage> intercept(GetNextMessageReadyForDelivery operation, InterceptorChain<GetNextMessageReadyForDelivery, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return (Optional)this.measurementTaker.context("essentials.messaging.durable_queues.get_next_message_ready_for_delivery").description("Time taken to query for the next message ready for delivery").tag(QUEUE_NAME, (CharSequence)((Object)operation.getQueueName())).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> interceptorChain.proceed());
        }
        return (Optional)interceptorChain.proceed();
    }

    @Override
    public QueueEntryId intercept(QueueMessage operation, InterceptorChain<QueueMessage, QueueEntryId, DurableQueuesInterceptor> interceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return (QueueEntryId)((Object)this.measurementTaker.context("essentials.messaging.durable_queues.queue_message").description("Time taken to queue a message").tag(QUEUE_NAME, (CharSequence)((Object)operation.getQueueName())).tag(MESSAGE_PAYLOAD_TYPE, operation.getMessage().getPayload() != null ? operation.getMessage().getPayload().getClass().getName() : "?").optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> interceptorChain.proceed()));
        }
        return (QueueEntryId)((Object)interceptorChain.proceed());
    }

    @Override
    public List<QueueEntryId> intercept(QueueMessages operation, InterceptorChain<QueueMessages, List<QueueEntryId>, DurableQueuesInterceptor> interceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return (List)this.measurementTaker.context("essentials.messaging.durable_queues.queue_messages").description("Time taken to queue a set of messages").tag(QUEUE_NAME, (CharSequence)((Object)operation.getQueueName())).tag("message_count", operation.getMessages().size()).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> interceptorChain.proceed());
        }
        return (List)interceptorChain.proceed();
    }

    @Override
    public boolean intercept(AcknowledgeMessageAsHandled operation, InterceptorChain<AcknowledgeMessageAsHandled, Boolean, DurableQueuesInterceptor> interceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return (Boolean)this.measurementTaker.context("essentials.messaging.durable_queues.acknowledge_message_as_handled").description("Time taken to acknowledge a message as handled and delete it").tag(QUEUE_NAME, (CharSequence)((Object)this.durableQueues.getQueueNameFor(operation.getQueueEntryId()).orElse(UNKNOWN_QUEUE_NAME))).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> interceptorChain.proceed());
        }
        return (Boolean)interceptorChain.proceed();
    }

    @Override
    public Optional<QueuedMessage> intercept(RetryMessage operation, InterceptorChain<RetryMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return (Optional)this.measurementTaker.context("essentials.messaging.durable_queues.retry_message").description("Time taken to mark a message for retry").tag(QUEUE_NAME, (CharSequence)((Object)this.durableQueues.getQueueNameFor(operation.getQueueEntryId()).orElse(UNKNOWN_QUEUE_NAME))).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> interceptorChain.proceed());
        }
        return (Optional)interceptorChain.proceed();
    }

    @Override
    public Optional<QueuedMessage> intercept(MarkAsDeadLetterMessage operation, InterceptorChain<MarkAsDeadLetterMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            return (Optional)this.measurementTaker.context("essentials.messaging.durable_queues.mark_as_dead_letter_message").description("Time taken to mark a message as a Dead Letter Message").tag(QUEUE_NAME, (CharSequence)((Object)this.durableQueues.getQueueNameFor(operation.getQueueEntryId()).orElse(UNKNOWN_QUEUE_NAME))).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> interceptorChain.proceed());
        }
        return (Optional)interceptorChain.proceed();
    }
}

