/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.interceptor.micrometer;

import dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward.MessageHandlerInterceptor;
import dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward.operation.InvokeMessageHandlerMethod;
import dk.cloudcreate.essentials.shared.interceptor.InterceptorChain;
import dk.cloudcreate.essentials.shared.measurement.LogThresholds;
import dk.cloudcreate.essentials.shared.measurement.LoggingMeasurementRecorder;
import dk.cloudcreate.essentials.shared.measurement.MeasurementRecorder;
import dk.cloudcreate.essentials.shared.measurement.MeasurementTaker;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class RecordExecutionTimeMessageHandlerInterceptor
implements MessageHandlerInterceptor {
    public static final String MODULE_TAG_NAME = "Module";
    public static final String METRIC = "essentials.messaging.message_handler";
    private final MeasurementTaker measurementTaker;
    private static final ConcurrentHashMap<Method, String> loggingNameCache = new ConcurrentHashMap();
    private final boolean recordExecutionTimeEnabled;
    private final String moduleTag;

    public RecordExecutionTimeMessageHandlerInterceptor(Optional<MeterRegistry> meterRegistryOptional, boolean recordExecutionTimeEnabled, LogThresholds thresholds, String moduleTag) {
        this.recordExecutionTimeEnabled = recordExecutionTimeEnabled;
        this.moduleTag = moduleTag;
        this.measurementTaker = MeasurementTaker.builder().addRecorder((MeasurementRecorder)new LoggingMeasurementRecorder(LoggerFactory.getLogger(this.getClass()), thresholds)).withOptionalMicrometerMeasurementRecorder(meterRegistryOptional).build();
    }

    @Override
    public void intercept(InvokeMessageHandlerMethod operation, InterceptorChain<InvokeMessageHandlerMethod, Void, MessageHandlerInterceptor> interceptorChain) {
        if (this.recordExecutionTimeEnabled) {
            String methodLoggingName = loggingNameCache.computeIfAbsent(operation.methodToInvoke, method -> RecordExecutionTimeMessageHandlerInterceptor.getMethodDescription(operation));
            this.measurementTaker.context(METRIC).description("Time taken to handle a message").tag("message_handler_class", operation.methodToInvoke.getDeclaringClass().getSimpleName()).tag("message_handler_method", methodLoggingName).tag("message_type", operation.resolvedInvokeMethodWithArgumentOfType.getName()).optionalTag(MODULE_TAG_NAME, this.moduleTag).record(() -> interceptorChain.proceed());
        } else {
            interceptorChain.proceed();
        }
    }

    private static String getMethodDescription(InvokeMessageHandlerMethod operation) {
        return operation.methodToInvoke.getName() + "(" + Arrays.stream(operation.methodToInvoke.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ")";
    }
}

