/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import dk.cloudcreate.essentials.components.foundation.json.JSONDeserializationException;
import dk.cloudcreate.essentials.components.foundation.json.JSONSerializationException;
import dk.cloudcreate.essentials.components.foundation.json.JSONSerializer;
import dk.cloudcreate.essentials.shared.Exceptions;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.Classes;

public class JacksonJSONSerializer
implements JSONSerializer {
    protected final ObjectMapper objectMapper;

    public JacksonJSONSerializer(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)FailFast.requireNonNull((Object)objectMapper, (String)"No object mapper instance provided");
        this.setClassLoader(this.getClass().getClassLoader());
    }

    @Override
    public String serialize(Object obj) {
        FailFast.requireNonNull((Object)obj, (String)"you must provide a non-null object");
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (Throwable e) {
            Exceptions.rethrowIfCriticalError((Throwable)e);
            throw new JSONSerializationException(MessageFormatter.msg((String)"Failed to serialize {} to JSON", (Object[])new Object[]{obj.getClass().getName()}), e);
        }
    }

    @Override
    public byte[] serializeAsBytes(Object obj) {
        FailFast.requireNonNull((Object)obj, (String)"you must provide a non-null object");
        try {
            return this.objectMapper.writeValueAsBytes(obj);
        }
        catch (Throwable e) {
            Exceptions.rethrowIfCriticalError((Throwable)e);
            throw new JSONSerializationException(MessageFormatter.msg((String)"Failed to serialize {} to JSON", (Object[])new Object[]{obj.getClass().getName()}), e);
        }
    }

    @Override
    public <T> T deserialize(String json, String javaType) {
        return this.deserialize(json, Classes.forName((String)((String)FailFast.requireNonNull((Object)javaType, (String)"No javaType provided")), (ClassLoader)this.getClassLoader()));
    }

    @Override
    public <T> T deserialize(String json, Class<T> javaType) {
        FailFast.requireNonNull((Object)json, (String)"No json provided");
        FailFast.requireNonNull(javaType, (String)"No javaType provided");
        try {
            return (T)this.objectMapper.readValue(json, javaType);
        }
        catch (Throwable e) {
            Exceptions.rethrowIfCriticalError((Throwable)e);
            throw new JSONDeserializationException(MessageFormatter.msg((String)"Failed to deserialize JSON to {}", (Object[])new Object[]{javaType.getName()}), e);
        }
    }

    @Override
    public <T> T deserialize(byte[] json, String javaType) {
        return this.deserialize(json, Classes.forName((String)((String)FailFast.requireNonNull((Object)javaType, (String)"No javaType provided")), (ClassLoader)this.getClassLoader()));
    }

    @Override
    public <T> T deserialize(byte[] json, Class<T> javaType) {
        FailFast.requireNonNull((Object)json, (String)"No json provided");
        FailFast.requireNonNull(javaType, (String)"No javaType provided");
        try {
            return (T)this.objectMapper.readValue(json, javaType);
        }
        catch (Throwable e) {
            Exceptions.rethrowIfCriticalError((Throwable)e);
            throw new JSONDeserializationException(MessageFormatter.msg((String)"Failed to deserialize JSON to {}", (Object[])new Object[]{javaType.getName()}), e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.objectMapper.getTypeFactory().getClassLoader();
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        FailFast.requireNonNull((Object)classLoader, (String)"No ClassLoader provided");
        this.objectMapper.setTypeFactory(TypeFactory.defaultInstance().withClassLoader(classLoader));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

