/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.lifecycle;

import dk.cloudcreate.essentials.components.foundation.lifecycle.LifecycleManager;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.Lifecycle;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;

public final class DefaultLifecycleManager
implements SmartLifecycle,
LifecycleManager,
ApplicationContextAware {
    public static final Logger log = LoggerFactory.getLogger(DefaultLifecycleManager.class);
    private ApplicationContext applicationContext;
    private boolean hasStartedLifeCycleBeans;
    private Map<String, Lifecycle> lifeCycleBeans;
    private final Consumer<ApplicationContext> contextRefreshedEventConsumer;
    private final boolean isStartLifecycles;
    private volatile boolean isRunning = false;

    public DefaultLifecycleManager(Consumer<ApplicationContext> contextRefreshedEventConsumer, boolean isStartLifecycles) {
        this.contextRefreshedEventConsumer = (Consumer)FailFast.requireNonNull(contextRefreshedEventConsumer);
        this.isStartLifecycles = isStartLifecycles;
        log.info("Initializing {} with isStartLifecycles = {}", (Object)this.getClass().getSimpleName(), (Object)isStartLifecycles);
    }

    public DefaultLifecycleManager(boolean isStartLifecycles) {
        this(event -> {}, isStartLifecycles);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void stop() {
        if (this.hasStartedLifeCycleBeans) {
            log.info("Stopping Essentials Lifecycle beans");
            this.lifeCycleBeans.forEach((beanName, lifecycleBean) -> {
                if (lifecycleBean.isStarted()) {
                    log.info("Stopping {} bean '{}' of type '{}'", new Object[]{Lifecycle.class.getSimpleName(), beanName, lifecycleBean.getClass().getName()});
                    lifecycleBean.stop();
                }
            });
            this.hasStartedLifeCycleBeans = false;
            log.info("Essentials Lifecycle beans have been stopped");
        }
        this.isRunning = false;
    }

    public void start() {
        if (!this.isStartLifecycles) {
            log.info("Start of lifecycle beans is disabled");
            return;
        }
        if (!this.hasStartedLifeCycleBeans) {
            log.info("Starting Essentials Lifecycle beans");
            this.hasStartedLifeCycleBeans = true;
            this.lifeCycleBeans = this.applicationContext.getBeansOfType(Lifecycle.class);
            this.lifeCycleBeans.forEach((beanName, lifecycleBean) -> {
                if (!lifecycleBean.isStarted()) {
                    log.info("Starting {} bean '{}' of type '{}'", new Object[]{Lifecycle.class.getSimpleName(), beanName, lifecycleBean.getClass().getName()});
                    lifecycleBean.start();
                }
            });
            log.info("Essentials Lifecycle beans have been started");
            log.info("Calling {} contextRefreshedEventConsumer", (Object)this.getClass().getSimpleName());
            this.contextRefreshedEventConsumer.accept(this.applicationContext);
            log.info("Completed calling {} contextRefreshedEventConsumer", (Object)this.getClass().getSimpleName());
        }
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getPhase() {
        return 0x7FFFFFFE;
    }
}

