/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging;

import dk.cloudcreate.essentials.components.foundation.messaging.MessageDeliveryErrorHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import java.time.Duration;

public final class ExponentialBackoffBuilder {
    private Duration initialRedeliveryDelay;
    private Duration followupRedeliveryDelay;
    private double followupRedeliveryDelayMultiplier;
    private Duration maximumFollowupRedeliveryDelayThreshold;
    private int maximumNumberOfRedeliveries;
    private MessageDeliveryErrorHandler deliveryErrorHandler = MessageDeliveryErrorHandler.alwaysRetry();

    public ExponentialBackoffBuilder setInitialRedeliveryDelay(Duration initialRedeliveryDelay) {
        this.initialRedeliveryDelay = initialRedeliveryDelay;
        return this;
    }

    public ExponentialBackoffBuilder setFollowupRedeliveryDelay(Duration followupRedeliveryDelay) {
        this.followupRedeliveryDelay = followupRedeliveryDelay;
        return this;
    }

    public ExponentialBackoffBuilder setFollowupRedeliveryDelayMultiplier(double followupRedeliveryDelayMultiplier) {
        this.followupRedeliveryDelayMultiplier = followupRedeliveryDelayMultiplier;
        return this;
    }

    public ExponentialBackoffBuilder setMaximumFollowupRedeliveryDelayThreshold(Duration maximumFollowupRedeliveryDelayThreshold) {
        this.maximumFollowupRedeliveryDelayThreshold = maximumFollowupRedeliveryDelayThreshold;
        return this;
    }

    public ExponentialBackoffBuilder setMaximumNumberOfRedeliveries(int maximumNumberOfRedeliveries) {
        this.maximumNumberOfRedeliveries = maximumNumberOfRedeliveries;
        return this;
    }

    public ExponentialBackoffBuilder setDeliveryErrorHandler(MessageDeliveryErrorHandler deliveryErrorHandler) {
        this.deliveryErrorHandler = deliveryErrorHandler;
        return this;
    }

    public RedeliveryPolicy build() {
        return RedeliveryPolicy.builder().setInitialRedeliveryDelay(this.initialRedeliveryDelay).setFollowupRedeliveryDelay(this.followupRedeliveryDelay).setFollowupRedeliveryDelayMultiplier(this.followupRedeliveryDelayMultiplier).setMaximumFollowupRedeliveryDelayThreshold(this.maximumFollowupRedeliveryDelayThreshold).setMaximumNumberOfRedeliveries(this.maximumNumberOfRedeliveries).setDeliveryErrorHandler(this.deliveryErrorHandler).build();
    }
}

