/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging;

import dk.cloudcreate.essentials.components.foundation.messaging.MessageDeliveryErrorHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import java.time.Duration;

public final class FixedBackoffBuilder {
    private Duration redeliveryDelay;
    private int maximumNumberOfRedeliveries;
    private MessageDeliveryErrorHandler deliveryErrorHandler = MessageDeliveryErrorHandler.alwaysRetry();

    public FixedBackoffBuilder setRedeliveryDelay(Duration redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
        return this;
    }

    public FixedBackoffBuilder setMaximumNumberOfRedeliveries(int maximumNumberOfRedeliveries) {
        this.maximumNumberOfRedeliveries = maximumNumberOfRedeliveries;
        return this;
    }

    public FixedBackoffBuilder setDeliveryErrorHandler(MessageDeliveryErrorHandler deliveryErrorHandler) {
        this.deliveryErrorHandler = deliveryErrorHandler;
        return this;
    }

    public RedeliveryPolicy build() {
        return RedeliveryPolicy.builder().setInitialRedeliveryDelay(this.redeliveryDelay).setFollowupRedeliveryDelay(this.redeliveryDelay).setFollowupRedeliveryDelayMultiplier(1.0).setMaximumFollowupRedeliveryDelayThreshold(this.redeliveryDelay).setMaximumNumberOfRedeliveries(this.maximumNumberOfRedeliveries).setDeliveryErrorHandler(this.deliveryErrorHandler).build();
    }
}

