/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging;

import dk.cloudcreate.essentials.components.foundation.messaging.ExponentialBackoffBuilder;
import dk.cloudcreate.essentials.components.foundation.messaging.FixedBackoffBuilder;
import dk.cloudcreate.essentials.components.foundation.messaging.LinearBackoffBuilder;
import dk.cloudcreate.essentials.components.foundation.messaging.MessageDeliveryErrorHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicyBuilder;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.util.Objects;

public final class RedeliveryPolicy {
    public final Duration initialRedeliveryDelay;
    public final Duration followupRedeliveryDelay;
    public final double followupRedeliveryDelayMultiplier;
    public final Duration maximumFollowupRedeliveryThreshold;
    public final int maximumNumberOfRedeliveries;
    public final MessageDeliveryErrorHandler deliveryErrorHandler;

    public static RedeliveryPolicyBuilder builder() {
        return new RedeliveryPolicyBuilder();
    }

    public static ExponentialBackoffBuilder exponentialBackoff() {
        return new ExponentialBackoffBuilder();
    }

    public static LinearBackoffBuilder linearBackoff() {
        return new LinearBackoffBuilder();
    }

    public static FixedBackoffBuilder fixedBackoff() {
        return new FixedBackoffBuilder();
    }

    public RedeliveryPolicy(Duration initialRedeliveryDelay, Duration followupRedeliveryDelay, double followupRedeliveryDelayMultiplier, Duration maximumFollowupRedeliveryDelayThreshold, int maximumNumberOfRedeliveries, MessageDeliveryErrorHandler deliveryErrorHandler) {
        this.initialRedeliveryDelay = (Duration)FailFast.requireNonNull((Object)initialRedeliveryDelay, (String)"You must specify an initialRedeliveryDelay");
        this.followupRedeliveryDelay = (Duration)FailFast.requireNonNull((Object)followupRedeliveryDelay, (String)"You must specify an followupRedeliveryDelay");
        this.followupRedeliveryDelayMultiplier = followupRedeliveryDelayMultiplier;
        this.maximumFollowupRedeliveryThreshold = (Duration)FailFast.requireNonNull((Object)maximumFollowupRedeliveryDelayThreshold, (String)"You must specify an maximumFollowupRedeliveryDelayThreshold");
        this.maximumNumberOfRedeliveries = maximumNumberOfRedeliveries;
        this.deliveryErrorHandler = (MessageDeliveryErrorHandler)FailFast.requireNonNull((Object)deliveryErrorHandler, (String)("You must specify a " + MessageDeliveryErrorHandler.class.getSimpleName()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedeliveryPolicy that = (RedeliveryPolicy)o;
        return Double.compare(that.followupRedeliveryDelayMultiplier, this.followupRedeliveryDelayMultiplier) == 0 && this.maximumNumberOfRedeliveries == that.maximumNumberOfRedeliveries && Objects.equals(this.initialRedeliveryDelay, that.initialRedeliveryDelay) && Objects.equals(this.followupRedeliveryDelay, that.followupRedeliveryDelay) && Objects.equals(this.maximumFollowupRedeliveryThreshold, that.maximumFollowupRedeliveryThreshold);
    }

    public int hashCode() {
        return Objects.hash(this.initialRedeliveryDelay, this.followupRedeliveryDelay, this.followupRedeliveryDelayMultiplier, this.maximumFollowupRedeliveryThreshold, this.maximumNumberOfRedeliveries);
    }

    public String toString() {
        return "RedeliveryPolicy{initialRedeliveryDelay=" + String.valueOf(this.initialRedeliveryDelay) + ", followupRedeliveryDelay=" + String.valueOf(this.followupRedeliveryDelay) + ", followupRedeliveryDelayMultiplier=" + this.followupRedeliveryDelayMultiplier + ", maximumFollowupRedeliveryThreshold=" + String.valueOf(this.maximumFollowupRedeliveryThreshold) + ", maximumNumberOfRedeliveries=" + this.maximumNumberOfRedeliveries + ", deliveryErrorHandler=" + String.valueOf(this.deliveryErrorHandler) + "}";
    }

    public Duration calculateNextRedeliveryDelay(int currentNumberOfRedeliveryAttempts) {
        FailFast.requireTrue((currentNumberOfRedeliveryAttempts >= 0 ? 1 : 0) != 0, (String)"currentNumberOfRedeliveryAttempts must be 0 or larger");
        if (currentNumberOfRedeliveryAttempts == 0) {
            return this.initialRedeliveryDelay;
        }
        Duration calculatedRedeliveryDelay = this.initialRedeliveryDelay.plus(Duration.ofMillis((long)((double)this.followupRedeliveryDelay.toMillis() * this.followupRedeliveryDelayMultiplier)));
        if (calculatedRedeliveryDelay.compareTo(this.maximumFollowupRedeliveryThreshold) >= 0) {
            return this.maximumFollowupRedeliveryThreshold;
        }
        return calculatedRedeliveryDelay;
    }

    public static RedeliveryPolicy fixedBackoff(Duration redeliveryDelay, int maximumNumberOfRedeliveries) {
        return RedeliveryPolicy.builder().setInitialRedeliveryDelay(redeliveryDelay).setFollowupRedeliveryDelay(redeliveryDelay).setFollowupRedeliveryDelayMultiplier(1.0).setMaximumFollowupRedeliveryDelayThreshold(redeliveryDelay).setMaximumNumberOfRedeliveries(maximumNumberOfRedeliveries).setDeliveryErrorHandler(MessageDeliveryErrorHandler.alwaysRetry()).build();
    }

    public static RedeliveryPolicy linearBackoff(Duration redeliveryDelay, Duration maximumFollowupRedeliveryDelayThreshold, int maximumNumberOfRedeliveries) {
        return RedeliveryPolicy.builder().setInitialRedeliveryDelay(redeliveryDelay).setFollowupRedeliveryDelay(redeliveryDelay).setFollowupRedeliveryDelayMultiplier(1.0).setMaximumFollowupRedeliveryDelayThreshold(maximumFollowupRedeliveryDelayThreshold).setMaximumNumberOfRedeliveries(maximumNumberOfRedeliveries).setDeliveryErrorHandler(MessageDeliveryErrorHandler.alwaysRetry()).build();
    }

    public static RedeliveryPolicy exponentialBackoff(Duration initialRedeliveryDelay, Duration followupRedeliveryDelay, double followupRedeliveryDelayMultiplier, Duration maximumFollowupRedeliveryDelayThreshold, int maximumNumberOfRedeliveries) {
        return RedeliveryPolicy.builder().setInitialRedeliveryDelay(initialRedeliveryDelay).setFollowupRedeliveryDelay(followupRedeliveryDelay).setFollowupRedeliveryDelayMultiplier(followupRedeliveryDelayMultiplier).setMaximumFollowupRedeliveryDelayThreshold(maximumFollowupRedeliveryDelayThreshold).setMaximumNumberOfRedeliveries(maximumNumberOfRedeliveries).setDeliveryErrorHandler(MessageDeliveryErrorHandler.alwaysRetry()).build();
    }

    public boolean isPermanentError(QueuedMessage queuedMessage, Throwable error) {
        return this.deliveryErrorHandler.isPermanentError(queuedMessage, error);
    }

    public Duration getInitialRedeliveryDelay() {
        return this.initialRedeliveryDelay;
    }

    public Duration getFollowupRedeliveryDelay() {
        return this.followupRedeliveryDelay;
    }

    public double getFollowupRedeliveryDelayMultiplier() {
        return this.followupRedeliveryDelayMultiplier;
    }

    public Duration getMaximumFollowupRedeliveryThreshold() {
        return this.maximumFollowupRedeliveryThreshold;
    }

    public int getMaximumNumberOfRedeliveries() {
        return this.maximumNumberOfRedeliveries;
    }

    public MessageDeliveryErrorHandler getDeliveryErrorHandler() {
        return this.deliveryErrorHandler;
    }
}

