/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward;

import dk.cloudcreate.essentials.components.foundation.messaging.MessageHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward.MessageHandlerInterceptor;
import dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward.operation.InvokeMessageHandlerMethod;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.Message;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.interceptor.InterceptorChain;
import dk.cloudcreate.essentials.shared.reflection.ReflectionException;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationStrategy;
import dk.cloudcreate.essentials.shared.reflection.invocation.MethodPatternMatcher;
import dk.cloudcreate.essentials.shared.reflection.invocation.PatternMatchingMethodInvoker;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class PatternMatchingMessageHandler
implements Consumer<Message> {
    private final PatternMatchingMethodInvoker<Object> invoker;
    private final Object invokeMessageHandlerMethodsOn;
    private final List<MessageHandlerInterceptor> interceptors;
    private boolean allowUnmatchedMessages = false;

    public PatternMatchingMessageHandler(Object invokeMessageHandlerMethodsOn) {
        this(invokeMessageHandlerMethodsOn, List.of());
    }

    public PatternMatchingMessageHandler(Object invokeMessageHandlerMethodsOn, List<MessageHandlerInterceptor> interceptors) {
        this.invokeMessageHandlerMethodsOn = FailFast.requireNonNull((Object)invokeMessageHandlerMethodsOn, (String)"No invokeMessageHandlerMethodsOn provided");
        this.interceptors = new CopyOnWriteArrayList<MessageHandlerInterceptor>((Collection)FailFast.requireNonNull(interceptors, (String)"No interceptors provided"));
        this.invoker = this.createMethodInvoker();
    }

    public PatternMatchingMessageHandler() {
        this(List.of());
    }

    public PatternMatchingMessageHandler(List<MessageHandlerInterceptor> interceptors) {
        this.invokeMessageHandlerMethodsOn = this;
        this.interceptors = new CopyOnWriteArrayList<MessageHandlerInterceptor>((Collection)FailFast.requireNonNull(interceptors, (String)"No interceptors provided"));
        this.invoker = this.createMethodInvoker();
    }

    private PatternMatchingMethodInvoker<Object> createMethodInvoker() {
        return new PatternMatchingMethodInvoker(this.invokeMessageHandlerMethodsOn, (MethodPatternMatcher)new MessageHandlerMethodPatternMatcher(), InvocationStrategy.InvokeMostSpecificTypeMatched);
    }

    public PatternMatchingMessageHandler addInterceptor(MessageHandlerInterceptor interceptor) {
        FailFast.requireNonNull((Object)interceptor, (String)"No interceptor provided");
        this.interceptors.add(interceptor);
        return this;
    }

    public PatternMatchingMessageHandler removeInterceptor(MessageHandlerInterceptor interceptor) {
        FailFast.requireNonNull((Object)interceptor, (String)"No interceptor provided");
        this.interceptors.remove(interceptor);
        return this;
    }

    public boolean isAllowUnmatchedMessages() {
        return this.allowUnmatchedMessages;
    }

    public void setAllowUnmatchedMessages(boolean allowUnmatchedMessages) {
        this.allowUnmatchedMessages = allowUnmatchedMessages;
    }

    public void allowUnmatchedMessages() {
        this.setAllowUnmatchedMessages(true);
    }

    @Override
    public void accept(Message message) {
        this.invoker.invoke((Object)message, unmatchedMessage -> this.handleUnmatchedMessage(message));
    }

    protected void handleUnmatchedMessage(Message message) {
        if (!this.allowUnmatchedMessages) {
            throw new IllegalArgumentException(MessageFormatter.msg((String)"Unmatched Message with payload-type: '{}'", (Object[])new Object[]{message.getPayload().getClass().getName()}));
        }
    }

    public boolean handlesMessageWithPayload(Class<?> payloadType) {
        return this.invoker.hasMatchingMethod(payloadType);
    }

    private class MessageHandlerMethodPatternMatcher
    implements MethodPatternMatcher<Object> {
        private MessageHandlerMethodPatternMatcher() {
        }

        public boolean isInvokableMethod(Method method) {
            boolean isCandidate;
            FailFast.requireNonNull((Object)method, (String)"No candidate method supplied");
            boolean bl = isCandidate = method.isAnnotationPresent(MessageHandler.class) && method.getParameterCount() >= 1 && method.getParameterCount() <= 2;
            if (isCandidate && method.getParameterCount() == 2) {
                return Message.class.isAssignableFrom(method.getParameterTypes()[1]);
            }
            return isCandidate;
        }

        public Class<?> resolveInvocationArgumentTypeFromMethodDefinition(Method method) {
            FailFast.requireNonNull((Object)method, (String)"No method supplied");
            return method.getParameterTypes()[0];
        }

        public Class<?> resolveInvocationArgumentTypeFromObject(Object argument) {
            FailFast.requireNonNull((Object)argument, (String)"No argument supplied");
            FailFast.requireMustBeInstanceOf((Object)argument, Message.class);
            Message message = (Message)((Object)argument);
            return message.getPayload().getClass();
        }

        public void invokeMethod(Method methodToInvoke, Object argument, Object invokeMethodOn, Class<?> resolvedInvokeMethodWithArgumentOfType) throws Exception {
            FailFast.requireNonNull((Object)methodToInvoke, (String)"No methodToInvoke supplied");
            FailFast.requireNonNull((Object)argument, (String)"No argument supplied");
            FailFast.requireMustBeInstanceOf((Object)argument, Message.class);
            FailFast.requireNonNull((Object)invokeMethodOn, (String)"No invokeMethodOn supplied");
            FailFast.requireNonNull(resolvedInvokeMethodWithArgumentOfType, (String)"No resolvedInvokeMethodWithArgumentOfType supplied");
            Message message = (Message)((Object)argument);
            Object payload = message.getPayload();
            InvokeMessageHandlerMethod operation = new InvokeMessageHandlerMethod(methodToInvoke, message, payload, invokeMethodOn, resolvedInvokeMethodWithArgumentOfType);
            InterceptorChain operationresultinterceptorTypeInterceptorChain = InterceptorChain.newInterceptorChainForOperation((Object)operation, PatternMatchingMessageHandler.this.interceptors, (interceptor, interceptorChain) -> {
                interceptor.intercept(operation, (InterceptorChain<InvokeMessageHandlerMethod, Void, MessageHandlerInterceptor>)interceptorChain);
                return null;
            }, () -> {
                try {
                    if (methodToInvoke.getParameterCount() == 1) {
                        methodToInvoke.invoke(invokeMethodOn, payload);
                    } else {
                        methodToInvoke.invoke(invokeMethodOn, new Object[]{payload, message});
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new ReflectionException(MessageFormatter.msg((String)"Failed to invoke method - {}", (Object[])new Object[]{operation}), (Throwable)e);
                }
            });
            operationresultinterceptorTypeInterceptorChain.proceed();
        }
    }
}

