/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.Message;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class DefaultQueuedMessage
implements QueuedMessage {
    public final QueueEntryId id;
    public final QueueName queueName;
    public final Message message;
    public final OffsetDateTime addedTimestamp;
    public final OffsetDateTime nextDeliveryTimestamp;
    public final OffsetDateTime deliveryTimestamp;
    public final String lastDeliveryError;
    public final int totalDeliveryAttempts;
    public final int redeliveryAttempts;
    public final boolean isDeadLetterMessage;
    public final boolean isBeingDelivered;
    private Duration manuallyRequestedRedeliveryDelay;

    public DefaultQueuedMessage(QueueEntryId id, QueueName queueName, Message message, OffsetDateTime addedTimestamp, OffsetDateTime nextDeliveryTimestamp, OffsetDateTime deliveryTimestamp, String lastDeliveryError, int totalDeliveryAttempts, int redeliveryAttempts, boolean isDeadLetterMessage, boolean isBeingDelivered) {
        this.id = (QueueEntryId)((Object)FailFast.requireNonNull((Object)((Object)id), (String)"No queue entry id provided"));
        this.queueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided"));
        this.message = (Message)((Object)FailFast.requireNonNull((Object)((Object)message), (String)"No message provided"));
        this.addedTimestamp = (OffsetDateTime)FailFast.requireNonNull((Object)addedTimestamp, (String)"No addedTimestamp provided");
        this.nextDeliveryTimestamp = nextDeliveryTimestamp;
        this.deliveryTimestamp = deliveryTimestamp;
        this.lastDeliveryError = lastDeliveryError;
        this.totalDeliveryAttempts = totalDeliveryAttempts;
        this.redeliveryAttempts = redeliveryAttempts;
        this.isDeadLetterMessage = isDeadLetterMessage;
        this.isBeingDelivered = isBeingDelivered;
    }

    @Override
    public QueueEntryId getId() {
        return this.id;
    }

    @Override
    public QueueName getQueueName() {
        return this.queueName;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public QueuedMessage.DeliveryMode getDeliveryMode() {
        return QueuedMessage.DeliveryMode.NORMAL;
    }

    @Override
    public boolean isBeingDelivered() {
        return this.isBeingDelivered;
    }

    @Override
    public OffsetDateTime getAddedTimestamp() {
        return this.addedTimestamp;
    }

    @Override
    public OffsetDateTime getNextDeliveryTimestamp() {
        return this.nextDeliveryTimestamp;
    }

    @Override
    public OffsetDateTime getDeliveryTimestamp() {
        return this.deliveryTimestamp;
    }

    @Override
    public void markForRedeliveryIn(Duration deliveryDelay) {
        this.manuallyRequestedRedeliveryDelay = deliveryDelay;
    }

    @Override
    public boolean isManuallyMarkedForRedelivery() {
        return this.manuallyRequestedRedeliveryDelay != null;
    }

    @Override
    public Duration getRedeliveryDelay() {
        return this.manuallyRequestedRedeliveryDelay;
    }

    @Override
    public String getLastDeliveryError() {
        return this.lastDeliveryError;
    }

    @Override
    public int getTotalDeliveryAttempts() {
        return this.totalDeliveryAttempts;
    }

    @Override
    public int getRedeliveryAttempts() {
        return this.redeliveryAttempts;
    }

    @Override
    public boolean isDeadLetterMessage() {
        return this.isDeadLetterMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultQueuedMessage)) {
            return false;
        }
        DefaultQueuedMessage that = (DefaultQueuedMessage)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id});
    }

    public String toString() {
        return "DefaultQueuedMessage{id=" + String.valueOf((Object)this.id) + ", queueName=" + String.valueOf((Object)this.queueName) + ", message=" + String.valueOf((Object)this.message) + ", addedTimestamp=" + String.valueOf(this.addedTimestamp) + ", nextDeliveryTimestamp=" + String.valueOf(this.nextDeliveryTimestamp) + ", deliveryTimestamp=" + String.valueOf(this.deliveryTimestamp) + ", lastDeliveryError='" + this.lastDeliveryError + "', totalDeliveryAttempts=" + this.totalDeliveryAttempts + ", redeliveryAttempts=" + this.redeliveryAttempts + ", isDeadLetterMessage=" + this.isDeadLetterMessage + ", isBeingDelivered=" + this.isBeingDelivered + ", manuallyRequestedRedeliveryDelay=" + String.valueOf(this.manuallyRequestedRedeliveryDelay) + "}";
    }
}

