/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueueConsumerNotifications;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.ConsumeFromQueue;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface QueuePollingOptimizer
extends DurableQueueConsumerNotifications {
    public static QueuePollingOptimizer None() {
        return new QueuePollingOptimizer(){

            @Override
            public void queuePollingReturnedNoMessages() {
            }

            @Override
            public void queuePollingReturnedMessage(QueuedMessage queuedMessage) {
            }

            @Override
            public boolean shouldSkipPolling() {
                return false;
            }

            @Override
            public void messageAdded(QueuedMessage queuedMessage) {
            }

            public String toString() {
                return "NoQueuePollingOptimizer";
            }
        };
    }

    public void queuePollingReturnedNoMessages();

    public void queuePollingReturnedMessage(QueuedMessage var1);

    public boolean shouldSkipPolling();

    public static class SimpleQueuePollingOptimizer
    implements QueuePollingOptimizer {
        private static Logger log = LoggerFactory.getLogger(SimpleQueuePollingOptimizer.class);
        private final AtomicLong pollingThreadDelay = new AtomicLong();
        private final AtomicLong shouldSkipPollCallCount = new AtomicLong();
        private final long delayIncrementMs;
        private final long maxDelayMs;
        private final ConsumeFromQueue consumeFromQueue;
        private final long pollingIntervalMs;

        public SimpleQueuePollingOptimizer(ConsumeFromQueue consumeFromQueue, long delayIncrementMs, long maxDelayMs) {
            this.consumeFromQueue = consumeFromQueue;
            this.pollingIntervalMs = consumeFromQueue.getPollingInterval().toMillis();
            this.delayIncrementMs = delayIncrementMs;
            this.maxDelayMs = maxDelayMs;
            if (this.pollingIntervalMs == 0L) {
                throw new IllegalArgumentException(MessageFormatter.msg((String)"pollingIntervalMs {} is zero", (Object[])new Object[]{this.pollingIntervalMs}));
            }
            if (this.pollingIntervalMs > maxDelayMs) {
                throw new IllegalArgumentException(MessageFormatter.msg((String)"pollingIntervalMs {} > maxDelayMs {}", (Object[])new Object[]{this.pollingIntervalMs, maxDelayMs}));
            }
            if (delayIncrementMs > maxDelayMs) {
                throw new IllegalArgumentException(MessageFormatter.msg((String)"delayIncrementMs {} > maxDelayMs {}", (Object[])new Object[]{delayIncrementMs, maxDelayMs}));
            }
        }

        @Override
        public void queuePollingReturnedNoMessages() {
            long currentDelay = this.pollingThreadDelay.get();
            if (currentDelay < this.maxDelayMs) {
                long newDelayMs = currentDelay + this.delayIncrementMs;
                this.pollingThreadDelay.set(newDelayMs);
                log.trace("[{}] {} - queuePollingReturnedNoMessages - increasing pollingThreadDelay to {} ms", new Object[]{this.consumeFromQueue.queueName, this.consumeFromQueue.consumerName, newDelayMs});
            } else {
                log.trace("[{}] {} - queuePollingReturnedNoMessages - retaining pollingThreadDelay at {} ms", new Object[]{this.consumeFromQueue.queueName, this.consumeFromQueue.consumerName, currentDelay});
            }
            this.shouldSkipPollCallCount.set(0L);
        }

        @Override
        public void queuePollingReturnedMessage(QueuedMessage queuedMessage) {
            log.trace("[{}] {} - queuePollingReturnedMessage - resetting pollingThreadDelay: 0 ms", (Object)this.consumeFromQueue.queueName, (Object)this.consumeFromQueue.consumerName);
            this.pollingThreadDelay.set(0L);
            this.shouldSkipPollCallCount.set(0L);
        }

        @Override
        public boolean shouldSkipPolling() {
            long pollingDelay = this.pollingThreadDelay.get();
            if (pollingDelay == 0L) {
                log.trace("[{}] {} - shouldSkipPolling: false - pollingDelay: 0 ms", (Object)this.consumeFromQueue.queueName, (Object)this.consumeFromQueue.consumerName);
                return false;
            }
            long callCount = this.shouldSkipPollCallCount.get();
            this.shouldSkipPollCallCount.set(++callCount);
            if (this.pollingIntervalMs * callCount > pollingDelay) {
                log.trace("[{}] {} - shouldSkipPolling: false - pollingInterval: {} ms * callCount: {} > pollingDelay: {} ms", new Object[]{this.consumeFromQueue.queueName, this.consumeFromQueue.consumerName, this.pollingIntervalMs, callCount, pollingDelay});
                return false;
            }
            log.trace("[{}] {} - shouldSkipPolling: true - pollingInterval: {} ms * callCount: {} <= pollingDelay: {} ms", new Object[]{this.consumeFromQueue.queueName, this.consumeFromQueue.consumerName, this.pollingIntervalMs, callCount, pollingDelay});
            return true;
        }

        @Override
        public void messageAdded(QueuedMessage queuedMessage) {
            log.trace("[{}] {} - messageAdded - resetting pollingThreadDelay: 0 ms and shouldSkipPollCallCount: 0. Message: {}", new Object[]{this.consumeFromQueue.queueName, this.consumeFromQueue.consumerName, queuedMessage});
            this.pollingThreadDelay.set(0L);
            this.shouldSkipPollCallCount.set(0L);
        }

        public String toString() {
            return "SimpleQueuePollingOptimizer{pollingIntervalMs=" + this.pollingIntervalMs + ", delayIncrementMs=" + this.delayIncrementMs + ", maxDelayMs=" + this.maxDelayMs + ", consumeFromQueue=" + String.valueOf(this.consumeFromQueue) + "}";
        }
    }
}

