/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue.micrometer;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueues;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueuesInterceptor;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessageCounts;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.AcknowledgeMessageAsHandled;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.DeleteMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.MarkAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessageAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessages;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.ResurrectDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.RetryMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.tuple.Pair;
import dk.cloudcreate.essentials.shared.interceptor.InterceptorChain;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class DurableQueuesMicrometerInterceptor
implements DurableQueuesInterceptor {
    private static final String QUEUED_MESSAGES_GAUGE_NAME = "DurableQueues_QueuedMessages_Size";
    private static final String DEAD_LETTER_MESSAGES_GAUGE_NAME = "DurableQueues_DeadLetterMessages_Size";
    public static final String PROCESSED_QUEUED_MESSAGES_COUNTER_NAME = "DurableQueues_QueuedMessages_Processed";
    public static final String PROCESSED_QUEUED_MESSAGES_RETRIES_COUNTER_NAME = "DurableQueues_QueuedMessages_Retries";
    public static final String PROCESSED_DEAD_LETTER_MESSAGES_COUNTER_NAME = "DurableQueues_DeadLetterMessages_Processed";
    public static final String QUEUE_NAME_TAG_NAME = "QueueName";
    public static final String MODULE_TAG_NAME = "Module";
    private final MeterRegistry meterRegistry;
    private final ConcurrentHashMap<QueueName, GaugeWrapper> queuedMessagesGauges = new ConcurrentHashMap();
    private final ConcurrentHashMap<QueueName, GaugeWrapper> deadLetterMessagesGauges = new ConcurrentHashMap();
    private DurableQueues durableQueues;
    private final List<Tag> commonTags = new ArrayList<Tag>();

    public DurableQueuesMicrometerInterceptor(MeterRegistry meterRegistry, String moduleTag) {
        this.meterRegistry = (MeterRegistry)FailFast.requireNonNull((Object)meterRegistry, (String)"No meterRegistry instance provided");
        Optional.ofNullable(moduleTag).map(t -> Tag.of((String)MODULE_TAG_NAME, (String)t)).ifPresent(this.commonTags::add);
    }

    @Override
    public void setDurableQueues(DurableQueues durableQueues) {
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
        durableQueues.getActiveQueueNames().forEach(this::updateQueueGaugeValues);
    }

    private void updateQueueGaugeValues(QueuedMessage message) {
        this.updateQueueGaugeValues(message.getQueueName());
    }

    private void updateQueueGaugeValues(QueueName queueName) {
        if (!this.durableQueues.getActiveQueueNames().contains((Object)queueName)) {
            return;
        }
        QueuedMessageCounts messageCounts = this.durableQueues.getQueuedMessageCountsFor(queueName);
        this.queuedMessagesGauges.computeIfAbsent(queueName, this::buildQueuedMessagesGauge).setMessageCount(messageCounts.numberOfQueuedMessages());
        this.deadLetterMessagesGauges.computeIfAbsent(queueName, this::buildDeadLetterMessagesGauge).setMessageCount(messageCounts.numberOfQueuedDeadLetterMessages());
    }

    private GaugeWrapper buildDeadLetterMessagesGauge(QueueName queueName) {
        AtomicLong deadLetterMessagesQueuedCount = new AtomicLong();
        Gauge gauge = Gauge.builder((String)DEAD_LETTER_MESSAGES_GAUGE_NAME, deadLetterMessagesQueuedCount::get).tags(this.buildTagList(QUEUE_NAME_TAG_NAME, queueName.toString())).register(this.meterRegistry);
        return new GaugeWrapper(gauge, deadLetterMessagesQueuedCount);
    }

    private GaugeWrapper buildQueuedMessagesGauge(QueueName queueName) {
        AtomicLong queuedMessagesQueuedCount = new AtomicLong();
        Gauge gauge = Gauge.builder((String)QUEUED_MESSAGES_GAUGE_NAME, queuedMessagesQueuedCount::get).tags(this.buildTagList(QUEUE_NAME_TAG_NAME, queueName.toString())).register(this.meterRegistry);
        return new GaugeWrapper(gauge, queuedMessagesQueuedCount);
    }

    @Override
    public QueueEntryId intercept(QueueMessage operation, InterceptorChain<QueueMessage, QueueEntryId, DurableQueuesInterceptor> interceptorChain) {
        QueueEntryId queueEntryId = (QueueEntryId)((Object)interceptorChain.proceed());
        this.updateQueueGaugeValues(operation.queueName);
        this.incProcessedQueuedMessagesCount(operation.queueName);
        return queueEntryId;
    }

    @Override
    public List<QueueEntryId> intercept(QueueMessages operation, InterceptorChain<QueueMessages, List<QueueEntryId>, DurableQueuesInterceptor> interceptorChain) {
        List queueEntryIds = (List)interceptorChain.proceed();
        this.updateQueueGaugeValues(operation.queueName);
        this.incProcessedQueuedMessagesCount(operation.queueName, queueEntryIds.size());
        return queueEntryIds;
    }

    @Override
    public QueueEntryId intercept(QueueMessageAsDeadLetterMessage operation, InterceptorChain<QueueMessageAsDeadLetterMessage, QueueEntryId, DurableQueuesInterceptor> interceptorChain) {
        QueueEntryId queueEntryId = (QueueEntryId)((Object)interceptorChain.proceed());
        this.updateQueueGaugeValues(operation.queueName);
        this.incProcessedQueuedDeadLetterMessagesCount(operation.queueName);
        return queueEntryId;
    }

    @Override
    public Optional<QueuedMessage> intercept(MarkAsDeadLetterMessage operation, InterceptorChain<MarkAsDeadLetterMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        Optional optionalQueuedMessage = (Optional)interceptorChain.proceed();
        optionalQueuedMessage.ifPresent(queuedMessage -> {
            this.updateQueueGaugeValues(queuedMessage.getQueueName());
            this.incProcessedQueuedDeadLetterMessagesCount(queuedMessage.getQueueName());
        });
        return optionalQueuedMessage;
    }

    @Override
    public boolean intercept(DeleteMessage operation, InterceptorChain<DeleteMessage, Boolean, DurableQueuesInterceptor> interceptorChain) {
        QueueName queueName = this.durableQueues.getQueueNameFor(operation.queueEntryId).orElse(null);
        Boolean succeeded = (Boolean)interceptorChain.proceed();
        if (succeeded.booleanValue() && queueName != null) {
            this.updateQueueGaugeValues(queueName);
        }
        return succeeded;
    }

    @Override
    public Optional<QueuedMessage> intercept(ResurrectDeadLetterMessage operation, InterceptorChain<ResurrectDeadLetterMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        Optional optionalQueuedMessage = (Optional)interceptorChain.proceed();
        optionalQueuedMessage.ifPresent(this::updateQueueGaugeValues);
        return optionalQueuedMessage;
    }

    @Override
    public Optional<QueuedMessage> intercept(RetryMessage operation, InterceptorChain<RetryMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        Optional optionalQueuedMessage = (Optional)interceptorChain.proceed();
        optionalQueuedMessage.ifPresent(this::updateQueueGaugeValues);
        return optionalQueuedMessage;
    }

    @Override
    public boolean intercept(AcknowledgeMessageAsHandled operation, InterceptorChain<AcknowledgeMessageAsHandled, Boolean, DurableQueuesInterceptor> interceptorChain) {
        QueueName queueName = this.durableQueues.getQueueNameFor(operation.queueEntryId).orElse(null);
        Boolean succeeded = (Boolean)interceptorChain.proceed();
        if (Boolean.TRUE.equals(succeeded) && queueName != null) {
            this.updateQueueGaugeValues(queueName);
        }
        return succeeded;
    }

    private void incProcessedQueuedMessagesCount(QueueName queueName) {
        FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided");
        this.meterRegistry.counter(PROCESSED_QUEUED_MESSAGES_COUNTER_NAME, this.buildTagList(QUEUE_NAME_TAG_NAME, queueName.toString())).increment();
    }

    private void incProcessedQueuedMessagesCount(QueueName queueName, int countIncrease) {
        FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided");
        this.meterRegistry.counter(PROCESSED_QUEUED_MESSAGES_COUNTER_NAME, this.buildTagList(QUEUE_NAME_TAG_NAME, queueName.toString())).increment((double)countIncrease);
    }

    private void incProcessedQueuedDeadLetterMessagesCount(QueueName queueName) {
        FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided");
        this.meterRegistry.counter(PROCESSED_DEAD_LETTER_MESSAGES_COUNTER_NAME, this.buildTagList(QUEUE_NAME_TAG_NAME, queueName.toString())).increment();
    }

    private void incQueuedMessagesRetriesCount(QueueName queueName) {
        FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided");
        this.meterRegistry.counter(PROCESSED_QUEUED_MESSAGES_RETRIES_COUNTER_NAME, this.buildTagList(QUEUE_NAME_TAG_NAME, queueName.toString())).increment();
    }

    private List<Tag> buildTagList(String key, String value) {
        ArrayList<Tag> tagList = new ArrayList<Tag>(this.commonTags);
        tagList.add(Tag.of((String)key, (String)value));
        return tagList;
    }

    private static class GaugeWrapper
    extends Pair<Gauge, AtomicLong> {
        private GaugeWrapper(Gauge gauge, AtomicLong messageCount) {
            super((Object)gauge, (Object)messageCount);
        }

        private void setMessageCount(long messageCount) {
            ((AtomicLong)this._2).set(messageCount);
        }
    }
}

