/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.mongo;

import dk.cloudcreate.essentials.components.foundation.mongo.InvalidCollectionNameException;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.Locale;
import java.util.regex.Pattern;
import org.springframework.data.mongodb.UncategorizedMongoDbException;

public final class MongoUtil {
    public static final int MAX_LENGTH = 64;
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$");

    public static void checkIsValidCollectionName(String collectionName) {
        if (collectionName == null || collectionName.trim().isEmpty()) {
            throw new InvalidCollectionNameException("Collection name cannot be null or empty.");
        }
        if (collectionName.length() > 64) {
            throw new InvalidCollectionNameException(MessageFormatter.msg((String)"Collection name: '{}' exceeds max length of {}", (Object[])new Object[]{collectionName, 64}));
        }
        if (collectionName.contains("$") || collectionName.contains("\u0000")) {
            throw new InvalidCollectionNameException(MessageFormatter.msg((String)"Invalid Collection name: '{}'. Contains $ or null characters", (Object[])new Object[]{collectionName}));
        }
        if (collectionName.toLowerCase(Locale.ROOT).startsWith("system.")) {
            throw new InvalidCollectionNameException(MessageFormatter.msg((String)"Invalid Collection name: '{}'. Starts with 'system.' which is not allowed", (Object[])new Object[]{collectionName}));
        }
        if (!VALID_NAME_PATTERN.matcher(collectionName).matches()) {
            throw new InvalidCollectionNameException(MessageFormatter.msg((String)"Invalid Collection name: '{}'. Names only contain letters, underscore or digits", (Object[])new Object[]{collectionName}));
        }
    }

    public static boolean isWriteConflict(Throwable e) {
        FailFast.requireNonNull((Object)e, (String)"No exception provided");
        return e instanceof UncategorizedMongoDbException && e.getMessage() != null && (e.getMessage().contains("WriteConflict") || e.getMessage().contains("Write Conflict"));
    }
}

