/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.postgresql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dk.cloudcreate.essentials.components.foundation.postgresql.NotificationDuplicationFilter;
import dk.cloudcreate.essentials.shared.FailFast;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class NotificationFilterChain {
    private final List<NotificationDuplicationFilter> filters = new ArrayList<NotificationDuplicationFilter>();
    private final ObjectMapper objectMapper;

    public NotificationFilterChain(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)FailFast.requireNonNull((Object)objectMapper, (String)"objectMapper must not be null");
    }

    public boolean addFilterAsFirst(NotificationDuplicationFilter filter) {
        if (!this.filters.contains(filter)) {
            this.filters.add(0, filter);
            return true;
        }
        return false;
    }

    public boolean addFilterAsLast(NotificationDuplicationFilter filter) {
        if (!this.filters.contains(filter)) {
            return this.filters.add(filter);
        }
        return false;
    }

    public void removeFilter(NotificationDuplicationFilter filter) {
        this.filters.remove(filter);
    }

    public Optional<String> extractDuplicationKey(String parameterJson) {
        FailFast.requireNonNull((Object)parameterJson, (String)"parameterJson must not be null");
        try {
            JsonNode jsonNode = this.objectMapper.readTree(parameterJson);
            for (NotificationDuplicationFilter filter : this.filters) {
                Optional<String> key = filter.extractDuplicationKey(jsonNode);
                if (!key.isPresent()) continue;
                return key;
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid JSON: " + parameterJson, e);
        }
    }

    public boolean hasDuplicationFilters() {
        return !this.filters.isEmpty();
    }
}

