/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.reactive.command;

import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueues;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.reactive.command.DurableLocalCommandBus;
import dk.cloudcreate.essentials.reactive.command.SendAndDontWaitErrorHandler;
import dk.cloudcreate.essentials.reactive.command.interceptor.CommandBusInterceptor;
import java.util.ArrayList;
import java.util.List;

public final class DurableLocalCommandBusBuilder {
    private DurableQueues durableQueues;
    private int parallelSendAndDontWaitConsumers = Runtime.getRuntime().availableProcessors();
    private QueueName commandQueueName = DurableLocalCommandBus.DEFAULT_COMMAND_QUEUE_NAME;
    private RedeliveryPolicy commandQueueRedeliveryPolicy = DurableLocalCommandBus.DEFAULT_REDELIVERY_POLICY;
    private SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler = new SendAndDontWaitErrorHandler.RethrowingSendAndDontWaitErrorHandler();
    private List<CommandBusInterceptor> interceptors = new ArrayList<CommandBusInterceptor>();

    public DurableLocalCommandBusBuilder setDurableQueues(DurableQueues durableQueues) {
        this.durableQueues = durableQueues;
        return this;
    }

    public DurableLocalCommandBusBuilder setParallelSendAndDontWaitConsumers(int parallelSendAndDontWaitConsumers) {
        this.parallelSendAndDontWaitConsumers = parallelSendAndDontWaitConsumers;
        return this;
    }

    public DurableLocalCommandBusBuilder setCommandQueueName(QueueName commandQueueName) {
        this.commandQueueName = commandQueueName;
        return this;
    }

    public DurableLocalCommandBusBuilder setCommandQueueRedeliveryPolicy(RedeliveryPolicy commandQueueRedeliveryPolicy) {
        this.commandQueueRedeliveryPolicy = commandQueueRedeliveryPolicy;
        return this;
    }

    public DurableLocalCommandBusBuilder setSendAndDontWaitErrorHandler(SendAndDontWaitErrorHandler sendAndDontWaitErrorHandler) {
        this.sendAndDontWaitErrorHandler = sendAndDontWaitErrorHandler;
        return this;
    }

    public DurableLocalCommandBusBuilder setInterceptors(List<CommandBusInterceptor> interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public DurableLocalCommandBusBuilder setInterceptors(CommandBusInterceptor ... interceptors) {
        this.interceptors = List.of(interceptors);
        return this;
    }

    public DurableLocalCommandBusBuilder addInterceptors(List<CommandBusInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this;
    }

    public DurableLocalCommandBusBuilder addInterceptors(CommandBusInterceptor ... interceptors) {
        this.interceptors.addAll(List.of(interceptors));
        return this;
    }

    public DurableLocalCommandBus build() {
        return new DurableLocalCommandBus(this.durableQueues, this.parallelSendAndDontWaitConsumers, this.commandQueueName, this.commandQueueRedeliveryPolicy, this.sendAndDontWaitErrorHandler, this.interceptors);
    }
}

