/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.transaction;

import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkException;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkStatus;
import dk.cloudcreate.essentials.shared.Exceptions;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.CheckedConsumer;
import dk.cloudcreate.essentials.shared.functional.CheckedFunction;
import dk.cloudcreate.essentials.shared.functional.CheckedRunnable;
import dk.cloudcreate.essentials.shared.functional.CheckedSupplier;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UnitOfWorkFactory<UOW extends UnitOfWork> {
    public static final Logger unitOfWorkLog = LoggerFactory.getLogger(UnitOfWorkFactory.class);

    public UOW getRequiredUnitOfWork();

    public UOW getOrCreateNewUnitOfWork();

    default public void usingUnitOfWork(CheckedRunnable action) {
        this.usingUnitOfWork(uow -> action.run());
    }

    default public <R> R withUnitOfWork(CheckedSupplier<R> action) {
        return this.withUnitOfWork(uow -> action.get());
    }

    default public void usingUnitOfWork(CheckedConsumer<UOW> unitOfWorkConsumer) {
        FailFast.requireNonNull(unitOfWorkConsumer, (String)"No unitOfWorkConsumer provided");
        Optional<UOW> existingUnitOfWork = this.getCurrentUnitOfWork();
        UnitOfWork unitOfWork = existingUnitOfWork.orElseGet(() -> {
            UOW uow = this.getOrCreateNewUnitOfWork();
            unitOfWorkLog.debug("Creating a new UnitOfWork for this usingUnitOfWork(CheckedConsumer) method call as there wasn't an existing UnitOfWork '{}'", (Object)uow.info());
            return uow;
        });
        existingUnitOfWork.ifPresent(uow -> unitOfWorkLog.debug("NestedUnitOfWork: Reusing existing UnitOfWork for this usingUnitOfWork(CheckedConsumer) method call '{}'", (Object)uow.info()));
        try {
            unitOfWorkConsumer.accept((Object)unitOfWork);
            if (existingUnitOfWork.isEmpty()) {
                unitOfWorkLog.debug("Committing the UnitOfWork created by this usingUnitOfWork(CheckedConsumer) method call '{}'", (Object)unitOfWork.info());
                unitOfWork.commit();
            } else {
                unitOfWorkLog.debug("NestedUnitOfWork: Won't commit the UnitOfWork as it wasn't created by this usingUnitOfWork(CheckedConsumer) method call '{}'", (Object)unitOfWork.info());
            }
        }
        catch (Throwable e) {
            if (existingUnitOfWork.isEmpty()) {
                if (unitOfWork.status() == UnitOfWorkStatus.RolledBack) {
                    unitOfWorkLog.debug("Committing the UnitOfWork created by this usingUnitOfWork(CheckedConsumer) failed - but the UnitOfWork is already rolled-back '{}'", (Object)unitOfWork.info());
                } else {
                    unitOfWorkLog.debug("Rolling back the UnitOfWork created by this usingUnitOfWork(CheckedConsumer) method call '{}'", (Object)unitOfWork.info());
                    unitOfWork.rollback(e);
                }
            } else {
                unitOfWorkLog.debug("NestedUnitOfWork: Marking UnitOfWork as rollback only as it wasn't created by this usingUnitOfWork(CheckedConsumer) method call '{}'", (Object)unitOfWork.info());
                unitOfWork.markAsRollbackOnly(e);
            }
            Exceptions.rethrowIfCriticalError((Throwable)e);
            throw new UnitOfWorkException(e);
        }
    }

    default public <R> R withUnitOfWork(CheckedFunction<UOW, R> unitOfWorkFunction) {
        FailFast.requireNonNull(unitOfWorkFunction, (String)"No unitOfWorkFunction provided");
        Optional<UOW> existingUnitOfWork = this.getCurrentUnitOfWork();
        UnitOfWork unitOfWork = existingUnitOfWork.orElseGet(() -> {
            UOW uow = this.getOrCreateNewUnitOfWork();
            unitOfWorkLog.debug("Creating a new UnitOfWork for this withUnitOfWork(CheckedFunction) method call as there wasn't an existing UnitOfWork '{}'", (Object)uow.info());
            return uow;
        });
        existingUnitOfWork.ifPresent(uow -> unitOfWorkLog.debug("NestedUnitOfWork: Reusing existing UnitOfWork for this withUnitOfWork(CheckedFunction) method call '{}'", (Object)uow.info()));
        try {
            Object result = unitOfWorkFunction.apply((Object)unitOfWork);
            if (existingUnitOfWork.isEmpty()) {
                unitOfWorkLog.debug("Committing the UnitOfWork created by this withUnitOfWork(CheckedFunction) method call '{}'", (Object)unitOfWork.info());
                unitOfWork.commit();
            } else {
                unitOfWorkLog.debug("NestedUnitOfWork: Won't commit the UnitOfWork as it wasn't created by this withUnitOfWork(CheckedFunction) method call '{}'", (Object)unitOfWork.info());
            }
            return (R)result;
        }
        catch (Throwable e) {
            if (existingUnitOfWork.isEmpty()) {
                if (unitOfWork.status() == UnitOfWorkStatus.RolledBack) {
                    unitOfWorkLog.debug("Committing the UnitOfWork created by this withUnitOfWork(CheckedFunction) failed - but the UnitOfWork is already rolled-back '{}'", (Object)unitOfWork.info());
                } else {
                    unitOfWorkLog.debug("Rolling back the UnitOfWork created by this withUnitOfWork(CheckedFunction) method call '{}'", (Object)unitOfWork.info());
                    unitOfWork.rollback(e);
                }
            } else {
                unitOfWorkLog.debug("NestedUnitOfWork: Marking UnitOfWork as rollback only as it wasn't created by this withUnitOfWork(CheckedFunction) method call '{}'", (Object)unitOfWork.info());
                unitOfWork.markAsRollbackOnly(e);
            }
            Exceptions.rethrowIfCriticalError((Throwable)e);
            throw new UnitOfWorkException(e);
        }
    }

    public Optional<UOW> getCurrentUnitOfWork();
}

