/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.transaction.jdbi;

import dk.cloudcreate.essentials.components.foundation.transaction.NoActiveUnitOfWorkException;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkException;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkLifecycleCallback;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkStatus;
import dk.cloudcreate.essentials.components.foundation.transaction.jdbi.HandleAwareUnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.jdbi.HandleAwareUnitOfWorkFactory;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericHandleAwareUnitOfWorkFactory<UOW extends HandleAwareUnitOfWork>
implements HandleAwareUnitOfWorkFactory<UOW> {
    private static final Logger log = LoggerFactory.getLogger(GenericHandleAwareUnitOfWorkFactory.class);
    private final Jdbi jdbi;
    private final ThreadLocal<UOW> unitOfWorks = new ThreadLocal();

    public GenericHandleAwareUnitOfWorkFactory(Jdbi jdbi) {
        this.jdbi = (Jdbi)FailFast.requireNonNull((Object)jdbi, (String)"No jdbi instance provided");
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    @Override
    public UOW getRequiredUnitOfWork() {
        HandleAwareUnitOfWork unitOfWork = (HandleAwareUnitOfWork)this.unitOfWorks.get();
        if (unitOfWork == null) {
            throw new NoActiveUnitOfWorkException();
        }
        return (UOW)unitOfWork;
    }

    @Override
    public UOW getOrCreateNewUnitOfWork() {
        HandleAwareUnitOfWork unitOfWork = (HandleAwareUnitOfWork)this.unitOfWorks.get();
        if (unitOfWork == null) {
            log.debug("Creating Managed UnitOfWork");
            unitOfWork = this.createNewUnitOfWorkInstance(this);
            unitOfWork.start();
            this.unitOfWorks.set(unitOfWork);
        }
        return (UOW)unitOfWork;
    }

    protected abstract UOW createNewUnitOfWorkInstance(GenericHandleAwareUnitOfWorkFactory<UOW> var1);

    private void removeUnitOfWork() {
        log.debug("Removing Managed UnitOfWork");
        this.unitOfWorks.remove();
    }

    @Override
    public Optional<UOW> getCurrentUnitOfWork() {
        return Optional.ofNullable((HandleAwareUnitOfWork)this.unitOfWorks.get());
    }

    public static class GenericHandleAwareUnitOfWork
    implements HandleAwareUnitOfWork {
        private final Logger log = LoggerFactory.getLogger(GenericHandleAwareUnitOfWork.class);
        private final GenericHandleAwareUnitOfWorkFactory<?> unitOfWorkFactory;
        private final Map<UnitOfWorkLifecycleCallback<Object>, List<Object>> unitOfWorkLifecycleCallbackResources;
        private UnitOfWorkStatus status;
        private Throwable causeOfRollback;
        private Handle handle;

        public GenericHandleAwareUnitOfWork(GenericHandleAwareUnitOfWorkFactory<?> unitOfWorkFactory) {
            this.unitOfWorkFactory = (GenericHandleAwareUnitOfWorkFactory)FailFast.requireNonNull(unitOfWorkFactory, (String)"No unitOfWorkFactory instance provided");
            this.status = UnitOfWorkStatus.Ready;
            this.unitOfWorkLifecycleCallbackResources = new HashMap<UnitOfWorkLifecycleCallback<Object>, List<Object>>();
        }

        @Override
        public void start() {
            if (this.status == UnitOfWorkStatus.Ready || this.status.isCompleted()) {
                this.log.debug("Starting Managed UnitOfWork with initial status {}: {}", (Object)this.status, (Object)this.info());
                this.log.trace("Opening JDBI handle and will begin a DB transaction");
                this.handle = this.unitOfWorkFactory.jdbi.open();
                this.handle.begin();
                this.status = UnitOfWorkStatus.Started;
            } else if (this.status == UnitOfWorkStatus.Started) {
                this.log.warn("The Managed UnitOfWork was already started");
            } else {
                this.close();
                this.unitOfWorkFactory.removeUnitOfWork();
                throw new UnitOfWorkException(MessageFormatter.msg((String)"Cannot start an Managed UnitOfWork as it has status {} and not the expected status {}, {} or {}", (Object[])new Object[]{this.status, UnitOfWorkStatus.Started, UnitOfWorkStatus.Committed, UnitOfWorkStatus.RolledBack}));
            }
        }

        private void close() {
            if (this.handle == null) {
                return;
            }
            this.log.trace("Closing JDBI handle");
            try {
                this.handle.close();
            }
            catch (Exception e) {
                this.log.error("Failed to close JDBI handle", (Throwable)e);
            }
            finally {
                this.unitOfWorkLifecycleCallbackResources.clear();
                this.afterClosingHandle();
            }
        }

        @Override
        public void commit() {
            if (this.status == UnitOfWorkStatus.Started) {
                this.log.trace("Calling UnitOfWorkLifecycleCallbacks#beforeCommit prior to committing the Managed UnitOfWork: {}", (Object)this.info());
                AtomicReference<UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus> processingStatus = new AtomicReference<UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus>(UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.REQUIRED);
                while (processingStatus.get() == UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.REQUIRED) {
                    this.log.trace("BeforeCommit: Performing BeforeCommitProcessing since processingStatus is {}", (Object)processingStatus.get());
                    processingStatus.set(UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.COMPLETED);
                    this.unitOfWorkLifecycleCallbackResources.forEach((key, resources) -> {
                        try {
                            this.log.trace("BeforeCommit: Calling {} with {} associated resource(s)", (Object)key.getClass().getName(), (Object)resources.size());
                            UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus newProcessingStatus = key.beforeCommit(this, resources);
                            if (newProcessingStatus == UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.REQUIRED && processingStatus.get() == UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.COMPLETED) {
                                this.log.trace("BeforeCommit: {} changed BeforeCommitProcessing processingStatus back to {}", (Object)key.getClass().getName(), (Object)newProcessingStatus);
                                processingStatus.set(newProcessingStatus);
                            }
                        }
                        catch (RuntimeException e) {
                            UnitOfWorkException unitOfWorkException = new UnitOfWorkException(MessageFormatter.msg((String)"{} failed during beforeCommit", (Object[])new Object[]{key.getClass().getName()}), e);
                            unitOfWorkException.fillInStackTrace();
                            this.rollback(unitOfWorkException);
                            throw unitOfWorkException;
                        }
                    });
                    this.beforeCommitting();
                }
                this.log.trace("Committing Managed UnitOfWork: {}", (Object)this.info());
                try {
                    this.handle.commit();
                }
                catch (Exception e) {
                    throw new UnitOfWorkException("Failed to commit UnitOfWork", e);
                }
                finally {
                    this.close();
                    this.unitOfWorkFactory.removeUnitOfWork();
                }
                this.status = UnitOfWorkStatus.Committed;
                this.unitOfWorkLifecycleCallbackResources.forEach((key, resources) -> {
                    try {
                        this.log.trace("AfterCommit: Calling {} with {} associated resource(s)", (Object)key.getClass().getName(), (Object)resources.size());
                        key.afterCommit(this, resources);
                    }
                    catch (RuntimeException e) {
                        this.log.error(MessageFormatter.msg((String)"Failed {} failed during afterCommit", (Object[])new Object[]{key.getClass().getName()}), (Throwable)e);
                    }
                });
                this.afterCommitting();
            } else if (this.status == UnitOfWorkStatus.MarkedForRollbackOnly) {
                this.rollback();
            } else {
                this.close();
                this.unitOfWorkFactory.removeUnitOfWork();
                throw new UnitOfWorkException(MessageFormatter.msg((String)"Cannot commit Managed UnitOfWork as it has status {} and not the expected status {}", (Object[])new Object[]{this.status, UnitOfWorkStatus.Started}));
            }
        }

        @Override
        public void rollback(Throwable cause) {
            if (this.status == UnitOfWorkStatus.Started || this.status == UnitOfWorkStatus.MarkedForRollbackOnly) {
                this.causeOfRollback = cause != null ? cause : this.causeOfRollback;
                String description = MessageFormatter.msg((String)"Rolling back Managed UnitOfWork with current status {}{}: {}", (Object[])new Object[]{this.status, cause != null ? " due to " + this.causeOfRollback.getMessage() : "", this.info()});
                if (this.log.isTraceEnabled()) {
                    this.log.trace(description, this.causeOfRollback);
                } else {
                    this.log.debug(description);
                }
                this.unitOfWorkLifecycleCallbackResources.entrySet().forEach(unitOfWorkLifecycleCallbackListEntry -> {
                    try {
                        this.log.trace("BeforeRollback: Calling {} with {} associated resource(s)", (Object)((UnitOfWorkLifecycleCallback)unitOfWorkLifecycleCallbackListEntry.getKey()).getClass().getName(), (Object)((List)unitOfWorkLifecycleCallbackListEntry.getValue()).size());
                        ((UnitOfWorkLifecycleCallback)unitOfWorkLifecycleCallbackListEntry.getKey()).beforeRollback(this, (List)unitOfWorkLifecycleCallbackListEntry.getValue(), cause);
                    }
                    catch (RuntimeException e) {
                        this.log.error(MessageFormatter.msg((String)"Failed {} failed during beforeRollback", (Object[])new Object[]{((UnitOfWorkLifecycleCallback)unitOfWorkLifecycleCallbackListEntry.getKey()).getClass().getName()}), (Throwable)e);
                    }
                });
                this.beforeRollback(cause);
                try {
                    this.handle.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } else {
                this.close();
                this.unitOfWorkFactory.removeUnitOfWork();
                throw new UnitOfWorkException(MessageFormatter.msg((String)"Cannot Rollback Managed UnitOfWork as it has status {} and not the expected status {} or {}", (Object[])new Object[]{this.status, UnitOfWorkStatus.Started, UnitOfWorkStatus.MarkedForRollbackOnly}), cause);
            }
            this.status = UnitOfWorkStatus.RolledBack;
            this.close();
            this.unitOfWorkLifecycleCallbackResources.entrySet().forEach(unitOfWorkLifecycleCallbackListEntry -> {
                try {
                    this.log.trace("AfterRollback: Calling {} with {} associated resource(s)", (Object)((UnitOfWorkLifecycleCallback)unitOfWorkLifecycleCallbackListEntry.getKey()).getClass().getName(), (Object)((List)unitOfWorkLifecycleCallbackListEntry.getValue()).size());
                    ((UnitOfWorkLifecycleCallback)unitOfWorkLifecycleCallbackListEntry.getKey()).afterRollback(this, (List)unitOfWorkLifecycleCallbackListEntry.getValue(), cause);
                }
                catch (RuntimeException e) {
                    this.log.error(MessageFormatter.msg((String)"Failed {} failed during afterRollback", (Object[])new Object[]{((UnitOfWorkLifecycleCallback)unitOfWorkLifecycleCallbackListEntry.getKey()).getClass().getName()}), (Throwable)e);
                }
            });
            this.afterRollback(cause);
            this.unitOfWorkFactory.removeUnitOfWork();
        }

        @Override
        public <T> T registerLifecycleCallbackForResource(T resource, UnitOfWorkLifecycleCallback<T> associatedUnitOfWorkCallback) {
            FailFast.requireNonNull(resource, (String)"You must provide a resource");
            FailFast.requireNonNull(associatedUnitOfWorkCallback, (String)"You must provide a UnitOfWorkLifecycleCallback");
            List resources = this.unitOfWorkLifecycleCallbackResources.computeIfAbsent(associatedUnitOfWorkCallback, callback -> new LinkedList());
            resources.add(resource);
            return resource;
        }

        @Override
        public String info() {
            return "TYPE:" + this.getClass().getSimpleName() + ":HASH:" + this.hashCode() + ":STATUS:" + String.valueOf((Object)this.status());
        }

        @Override
        public UnitOfWorkStatus status() {
            return this.status;
        }

        @Override
        public Throwable getCauseOfRollback() {
            return this.causeOfRollback;
        }

        @Override
        public void markAsRollbackOnly(Throwable cause) {
            if (this.status == UnitOfWorkStatus.Started) {
                String description = MessageFormatter.msg((String)"Marking Managed UnitOfWork for Rollback Only {}: {}", (Object[])new Object[]{cause != null ? "due to " + cause.getMessage() : "", this.info()});
                if (this.log.isTraceEnabled()) {
                    this.log.trace(description, cause);
                } else {
                    this.log.debug(description);
                }
                this.status = UnitOfWorkStatus.MarkedForRollbackOnly;
                this.causeOfRollback = cause;
            } else if (this.status == UnitOfWorkStatus.MarkedForRollbackOnly) {
                this.log.debug(MessageFormatter.msg((String)"Cannot Mark current Managed UnitOfWork for Rollback Only as it has already been marked as such: {}", (Object[])new Object[]{this.info()}), cause);
            } else {
                this.close();
                this.unitOfWorkFactory.removeUnitOfWork();
                throw new UnitOfWorkException(MessageFormatter.msg((String)"Cannot Mark Managed UnitOfWork for Rollback Only it has status {} and not the expected status {}", (Object[])new Object[]{this.status, UnitOfWorkStatus.Started}), cause);
            }
        }

        @Override
        public Handle handle() {
            if (this.handle == null) {
                throw new UnitOfWorkException("No active transaction");
            }
            return this.handle;
        }

        protected void afterClosingHandle() {
        }

        protected void afterCommitting() {
        }

        protected void beforeCommitting() {
        }

        protected void afterRollback(Throwable cause) {
        }

        protected void beforeRollback(Throwable cause) {
        }
    }
}

