/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.transaction.spring;

import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkException;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkLifecycleCallback;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkStatus;
import dk.cloudcreate.essentials.components.foundation.transaction.spring.SpringTransactionAwareUnitOfWorkFactory;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class SpringTransactionAwareUnitOfWork<TRX_MGR extends PlatformTransactionManager, UOW extends SpringTransactionAwareUnitOfWork<TRX_MGR, UOW>>
implements UnitOfWork {
    private static final Logger log = LoggerFactory.getLogger(SpringTransactionAwareUnitOfWork.class);
    protected SpringTransactionAwareUnitOfWorkFactory<TRX_MGR, UOW> unitOfWorkFactory;
    private Optional<TransactionStatus> manuallyStartedSpringTransaction;
    Throwable causeOfRollback;
    UnitOfWorkStatus status;
    protected Map<UnitOfWorkLifecycleCallback<Object>, List<Object>> unitOfWorkLifecycleCallbackResources;

    public SpringTransactionAwareUnitOfWork(SpringTransactionAwareUnitOfWorkFactory<TRX_MGR, UOW> unitOfWorkFactory) {
        this.unitOfWorkFactory = (SpringTransactionAwareUnitOfWorkFactory)FailFast.requireNonNull(unitOfWorkFactory, (String)"No unitOfWorkFactory provided");
        this.status = UnitOfWorkStatus.Ready;
        this.unitOfWorkLifecycleCallbackResources = new HashMap<UnitOfWorkLifecycleCallback<Object>, List<Object>>();
        this.manuallyStartedSpringTransaction = Optional.empty();
    }

    public SpringTransactionAwareUnitOfWork(SpringTransactionAwareUnitOfWorkFactory<TRX_MGR, UOW> unitOfWorkFactory, TransactionStatus manuallyManagedSpringTransaction) {
        this(unitOfWorkFactory);
        this.manuallyStartedSpringTransaction = Optional.of((TransactionStatus)FailFast.requireNonNull((Object)manuallyManagedSpringTransaction, (String)"No manuallyManagedSpringTransaction provided"));
    }

    @Override
    public void start() {
        if (this.status == UnitOfWorkStatus.Ready || this.status.isCompleted()) {
            log.debug("Starting {} manged Spring Transaction-Aware {} with initial status {}: {}", new Object[]{this.manuallyStartedSpringTransaction.isPresent() ? "manually" : "fully", this.getClass().getSimpleName(), this.status, this.info()});
            this.onStart();
            this.status = UnitOfWorkStatus.Started;
        } else if (this.status == UnitOfWorkStatus.Started) {
            log.warn("The Spring Transaction-Aware UnitOfWork was already started: {}", (Object)this.info());
        } else {
            this.cleanup();
            this.unitOfWorkFactory.removeUnitOfWork();
            throw new UnitOfWorkException(MessageFormatter.msg((String)"Cannot start an {} as it has status {} and not the expected status {}, {} or {}", (Object[])new Object[]{this.getClass().getSimpleName(), this.status, UnitOfWorkStatus.Started, UnitOfWorkStatus.Committed, UnitOfWorkStatus.RolledBack}));
        }
    }

    protected void onStart() {
    }

    protected void onCleanup() {
    }

    void cleanup() {
        log.trace("Cleaning up");
        try {
            this.onCleanup();
        }
        catch (Exception e) {
            log.error("Failed to cleanup", (Throwable)e);
        }
        finally {
            this.unitOfWorkLifecycleCallbackResources.clear();
        }
    }

    @Override
    public void commit() {
        if (this.status == UnitOfWorkStatus.Started && this.manuallyStartedSpringTransaction.isPresent()) {
            if (this.manuallyStartedSpringTransaction.get().isCompleted()) {
                log.warn("Cannot commit the already COMPLETED manually managed Spring Transaction, associated with this UnitOfWork: {}", (Object)this.info());
            } else if (this.manuallyStartedSpringTransaction.get().isRollbackOnly()) {
                log.info("Cannot commit the MARKED FOR ROLLBACK ONLY manually managed Spring Transaction, associated with this UnitOfWork: {}", (Object)this.info());
            } else {
                log.debug("Committing the manually managed Spring Transaction associated with this UnitOfWork: {}", (Object)this.info());
                this.unitOfWorkFactory.transactionManager.commit(this.manuallyStartedSpringTransaction.get());
            }
        } else if (this.status == UnitOfWorkStatus.MarkedForRollbackOnly) {
            log.debug("Rolling back UnitOfWork with status {}: {}", (Object)this.status, (Object)this.info());
            this.unitOfWorkFactory.transactionManager.rollback(this.manuallyStartedSpringTransaction.get());
        } else {
            log.debug("Ignoring call to commit for the fully Spring managed Transaction associated with UnitOfWork with status {}: {}", (Object)this.status, (Object)this.info());
        }
    }

    @Override
    public void rollback(Throwable cause) {
        boolean correctStatus;
        this.causeOfRollback = cause != null ? cause : this.causeOfRollback;
        boolean bl = correctStatus = this.status == UnitOfWorkStatus.Started || this.status == UnitOfWorkStatus.MarkedForRollbackOnly;
        if (correctStatus && this.manuallyStartedSpringTransaction.isPresent()) {
            if (this.manuallyStartedSpringTransaction.get().isCompleted()) {
                String description = MessageFormatter.msg((String)"Skipping rolling back the already COMPLETED manually managed Spring Transaction associated with UnitOfWork with status {}{}: {}", (Object[])new Object[]{this.status, this.causeOfRollback != null ? " due to " + this.causeOfRollback.getMessage() : "", this.info()});
                if (log.isTraceEnabled()) {
                    log.trace(description, this.causeOfRollback);
                } else {
                    log.debug(description);
                }
            } else {
                String description = MessageFormatter.msg((String)"Rolling back the manually managed Spring Transaction associated with UnitOfWork with status {}{}: {}", (Object[])new Object[]{this.status, this.causeOfRollback != null ? " due to " + this.causeOfRollback.getMessage() : "", this.info()});
                if (log.isTraceEnabled()) {
                    log.trace(description, this.causeOfRollback);
                } else {
                    log.debug(description);
                }
                this.unitOfWorkFactory.transactionManager.rollback(this.manuallyStartedSpringTransaction.get());
            }
        } else {
            log.debug(MessageFormatter.msg((String)"Ignoring call to rollback the fully Spring Managed Transaction associated with UnitOfWork with status {}: {}", (Object[])new Object[]{this.status, this.info()}), this.causeOfRollback);
        }
    }

    @Override
    public String info() {
        return "TYPE:" + this.getClass().getSimpleName() + ":HASH:" + this.hashCode() + ":STATUS:" + String.valueOf((Object)this.status());
    }

    @Override
    public UnitOfWorkStatus status() {
        return this.status;
    }

    @Override
    public Throwable getCauseOfRollback() {
        return this.causeOfRollback;
    }

    @Override
    public void markAsRollbackOnly(Throwable cause) {
        if (this.status == UnitOfWorkStatus.Started && this.manuallyStartedSpringTransaction.isPresent()) {
            String description = MessageFormatter.msg((String)"Marking the manually managed Spring Transaction associated with this UnitOfWork for Rollback Only {}: {}", (Object[])new Object[]{cause != null ? "due to " + cause.getMessage() : "", this.info()});
            if (log.isTraceEnabled()) {
                log.trace(description, cause);
            } else {
                log.debug(description);
            }
            this.status = UnitOfWorkStatus.MarkedForRollbackOnly;
            this.causeOfRollback = cause;
        } else {
            log.debug("Ignoring call to mark the fully Spring Managed Transaction, associated with this UnitOfWork, as rollbackOnly. Current UnitOfWork status {}: {}", (Object)this.status, (Object)this.info());
        }
    }

    @Override
    public <T> T registerLifecycleCallbackForResource(T resource, UnitOfWorkLifecycleCallback<T> associatedUnitOfWorkCallback) {
        FailFast.requireNonNull(resource, (String)"You must provide a resource");
        FailFast.requireNonNull(associatedUnitOfWorkCallback, (String)"You must provide a UnitOfWorkLifecycleCallback");
        List resources = this.unitOfWorkLifecycleCallbackResources.computeIfAbsent(associatedUnitOfWorkCallback, callback -> new LinkedList());
        resources.add(resource);
        return resource;
    }
}

