/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.transaction.spring;

import dk.cloudcreate.essentials.components.foundation.transaction.NoActiveUnitOfWorkException;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkException;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkFactory;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkLifecycleCallback;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkStatus;
import dk.cloudcreate.essentials.components.foundation.transaction.spring.SpringTransactionAwareUnitOfWork;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.types.GenericType;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class SpringTransactionAwareUnitOfWorkFactory<TRX_MGR extends PlatformTransactionManager, UOW extends SpringTransactionAwareUnitOfWork<TRX_MGR, UOW>>
implements UnitOfWorkFactory<UOW> {
    protected static final Logger log = LoggerFactory.getLogger(SpringTransactionAwareUnitOfWorkFactory.class);
    protected final TRX_MGR transactionManager;
    protected final DefaultTransactionDefinition defaultTransactionDefinition;
    protected final Class<?> unitOfWorkType;

    public SpringTransactionAwareUnitOfWorkFactory(TRX_MGR transactionManager) {
        this.transactionManager = (PlatformTransactionManager)FailFast.requireNonNull(transactionManager, (String)"No transactionManager provided");
        this.defaultTransactionDefinition = this.createDefaultTransactionDefinition();
        this.unitOfWorkType = this.resolveUnitOfWorkType();
        log.info("Configured '{}' with UnitOfWork type '{}' and defaultTransactionDefinition {}", new Object[]{this.getClass().getName(), this.unitOfWorkType.getName(), this.defaultTransactionDefinition});
    }

    protected Class<?> resolveUnitOfWorkType() {
        return GenericType.resolveGenericTypeForInterface(this.getClass(), UnitOfWorkFactory.class, (int)0);
    }

    protected DefaultTransactionDefinition createDefaultTransactionDefinition() {
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition(0);
        defaultTransactionDefinition.setIsolationLevel(2);
        return defaultTransactionDefinition;
    }

    public TRX_MGR getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public UOW getRequiredUnitOfWork() {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new NoActiveUnitOfWorkException();
        }
        return (UOW)this.getOrCreateNewUnitOfWork();
    }

    @Override
    public Optional<UOW> getCurrentUnitOfWork() {
        return Optional.ofNullable((SpringTransactionAwareUnitOfWork)TransactionSynchronizationManager.getResource(this.unitOfWorkType));
    }

    @Override
    public UOW getOrCreateNewUnitOfWork() {
        SpringTransactionAwareUnitOfWork unitOfWork;
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            log.debug("Manually starting a new Spring Transaction and associating it with a new Spring Transaction-Aware UnitOfWork");
            TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)this.defaultTransactionDefinition);
            unitOfWork = this.createUnitOfWorkForFactoryManagedTransaction(transaction);
            unitOfWork.start();
            TransactionSynchronizationManager.bindResource(this.unitOfWorkType, unitOfWork);
            log.trace("Registering a {} for the {}", (Object)SpringTransactionAwareUnitOfWorkSynchronization.class.getSimpleName(), (Object)this.unitOfWorkType.getSimpleName());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringTransactionAwareUnitOfWorkSynchronization(this, unitOfWork));
        } else {
            unitOfWork = (SpringTransactionAwareUnitOfWork)TransactionSynchronizationManager.getResource(this.unitOfWorkType);
            if (unitOfWork == null) {
                log.debug("Using the existing Spring Transaction and associating it with a new Spring Transaction-Aware UnitOfWork");
                unitOfWork = this.createUnitOfWorkForSpringManagedTransaction();
                unitOfWork.start();
                TransactionSynchronizationManager.bindResource(this.unitOfWorkType, unitOfWork);
                log.trace("Registering a {} for the {}", (Object)SpringTransactionAwareUnitOfWorkSynchronization.class.getSimpleName(), (Object)this.unitOfWorkType.getSimpleName());
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringTransactionAwareUnitOfWorkSynchronization(this, unitOfWork));
            }
        }
        return (UOW)unitOfWork;
    }

    protected abstract UOW createUnitOfWorkForFactoryManagedTransaction(TransactionStatus var1);

    protected abstract UOW createUnitOfWorkForSpringManagedTransaction();

    void removeUnitOfWork() {
        log.debug("Removing Spring Transaction-Aware UnitOfWork");
        Object resource = TransactionSynchronizationManager.unbindResource(this.unitOfWorkType);
        SpringTransactionAwareUnitOfWork uow = (SpringTransactionAwareUnitOfWork)resource;
        if (!uow.status.isCompleted) {
            log.error("UOW in not completed {}", (Object)uow.info());
        }
        log.debug("Removed Spring Transaction-Aware UnitOfWork: {}", (Object)uow.info());
    }

    protected void afterCommitAfterCallingLifecycleCallbackResources(UOW unitOfWork) {
    }

    protected void afterCommitBeforeCallingLifecycleCallbackResources(UOW unitOfWork) {
    }

    protected void beforeCommitAfterCallingLifecycleCallbackResources(UOW unitOfWork) {
    }

    protected void beforeCommitBeforeCallingLifecycleCallbackResources(UOW unitOfWork) {
    }

    protected void afterRollbackBeforeCallingLifecycleCallbackResources(UOW unitOfWork) {
    }

    protected void afterRollbackAfterCallingLifecycleCallbackResources(UOW unitOfWork) {
    }

    private static class SpringTransactionAwareUnitOfWorkSynchronization
    implements TransactionSynchronization {
        private final UOW unitOfWork;
        private boolean readOnly;
        final /* synthetic */ SpringTransactionAwareUnitOfWorkFactory this$0;

        public SpringTransactionAwareUnitOfWorkSynchronization(UOW unitOfWork) {
            this.this$0 = var1_1;
            this.unitOfWork = (SpringTransactionAwareUnitOfWork)FailFast.requireNonNull(unitOfWork, (String)"No unitOfWork provided");
        }

        public void beforeCommit(boolean readOnly) {
            this.readOnly = readOnly;
            if (readOnly) {
                log.debug("Ignoring beforeCommit as the transaction is readOnly");
                return;
            }
            log.trace("Calling UnitOfWorkLifecycleCallbacks#beforeCommit prior to committing the Spring Transaction-Aware UnitOfWork: {}", (Object)((SpringTransactionAwareUnitOfWork)this.unitOfWork).info());
            this.this$0.beforeCommitBeforeCallingLifecycleCallbackResources(this.unitOfWork);
            AtomicReference<UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus> processingStatus = new AtomicReference<UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus>(UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.REQUIRED);
            while (processingStatus.get() == UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.REQUIRED) {
                log.trace("BeforeCommit: Performing BeforeCommitProcessing since processingStatus is {}", (Object)processingStatus.get());
                processingStatus.set(UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.COMPLETED);
                ((SpringTransactionAwareUnitOfWork)this.unitOfWork).unitOfWorkLifecycleCallbackResources.forEach((key, resources) -> {
                    try {
                        log.trace("BeforeCommit: Calling {} with {} associated resource(s)", (Object)key.getClass().getName(), (Object)resources.size());
                        UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus newProcessingStatus = key.beforeCommit((UnitOfWork)this.unitOfWork, resources);
                        if (newProcessingStatus == UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.REQUIRED && processingStatus.get() == UnitOfWorkLifecycleCallback.BeforeCommitProcessingStatus.COMPLETED) {
                            log.trace("BeforeCommit: {} changed BeforeCommitProcessing processingStatus back to {}", (Object)key.getClass().getName(), (Object)newProcessingStatus);
                            processingStatus.set(newProcessingStatus);
                        }
                    }
                    catch (RuntimeException e) {
                        UnitOfWorkException unitOfWorkException = new UnitOfWorkException(MessageFormatter.msg((String)"{} failed during beforeCommit", (Object[])new Object[]{key.getClass().getName()}), e);
                        unitOfWorkException.fillInStackTrace();
                        throw unitOfWorkException;
                    }
                });
                this.this$0.beforeCommitAfterCallingLifecycleCallbackResources(this.unitOfWork);
            }
        }

        public void afterCommit() {
            if (this.readOnly) {
                log.debug("Ignoring afterCommit as the transaction is readOnly");
                return;
            }
            ((SpringTransactionAwareUnitOfWork)this.unitOfWork).status = UnitOfWorkStatus.Committed;
            log.trace("Calling UnitOfWorkLifecycleCallbacks#afterCommit of the Spring Transaction-Aware UnitOfWork");
            this.this$0.afterCommitBeforeCallingLifecycleCallbackResources(this.unitOfWork);
            ((SpringTransactionAwareUnitOfWork)this.unitOfWork).unitOfWorkLifecycleCallbackResources.forEach((key, resources) -> {
                try {
                    log.trace("AfterCommit: Calling {} with {} associated resource(s)", (Object)key.getClass().getName(), (Object)resources.size());
                    key.afterCommit((UnitOfWork)this.unitOfWork, resources);
                }
                catch (RuntimeException e) {
                    log.error(MessageFormatter.msg((String)"Failed {} failed during afterCommit", (Object[])new Object[]{key.getClass().getName()}), (Throwable)e);
                }
            });
            this.this$0.afterCommitAfterCallingLifecycleCallbackResources(this.unitOfWork);
        }

        public void afterCompletion(int status) {
            if (status == 1) {
                ((SpringTransactionAwareUnitOfWork)this.unitOfWork).status = UnitOfWorkStatus.RolledBack;
                this.this$0.afterRollbackBeforeCallingLifecycleCallbackResources(this.unitOfWork);
                log.trace("Calling UnitOfWorkLifecycleCallbacks#afterRollback and of the Spring Transaction-Aware UnitOfWork");
                ((SpringTransactionAwareUnitOfWork)this.unitOfWork).unitOfWorkLifecycleCallbackResources.forEach((key, resources) -> {
                    try {
                        log.trace("AfterRollback: Calling {} with {} associated resource(s)", (Object)key.getClass().getName(), (Object)resources.size());
                        key.afterRollback((UnitOfWork)this.unitOfWork, resources, ((SpringTransactionAwareUnitOfWork)this.unitOfWork).causeOfRollback);
                    }
                    catch (RuntimeException e) {
                        log.error(MessageFormatter.msg((String)"{} failed during afterRollback", (Object[])new Object[]{key.getClass().getName()}), (Throwable)e);
                    }
                });
                this.this$0.afterRollbackAfterCallingLifecycleCallbackResources(this.unitOfWork);
            } else if (status == 0) {
                ((SpringTransactionAwareUnitOfWork)this.unitOfWork).status = UnitOfWorkStatus.Committed;
            } else if (status == 2) {
                log.warn("Transaction status was UNKNOWN. Marking the UnitOfWork as Rolled-back as its assumed the transaction didn't commit on the DB server");
                ((SpringTransactionAwareUnitOfWork)this.unitOfWork).status = UnitOfWorkStatus.RolledBack;
            }
            ((SpringTransactionAwareUnitOfWork)this.unitOfWork).cleanup();
            this.this$0.removeUnitOfWork();
        }
    }
}

