/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.transaction.spring.jdbi;

import dk.cloudcreate.essentials.components.foundation.transaction.jdbi.HandleAwareUnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.jdbi.HandleAwareUnitOfWorkFactory;
import dk.cloudcreate.essentials.components.foundation.transaction.spring.SpringTransactionAwareUnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.spring.SpringTransactionAwareUnitOfWorkFactory;
import dk.cloudcreate.essentials.shared.FailFast;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

public class SpringTransactionAwareJdbiUnitOfWorkFactory
extends SpringTransactionAwareUnitOfWorkFactory<PlatformTransactionManager, SpringTransactionAwareHandleAwareUnitOfWork>
implements HandleAwareUnitOfWorkFactory<SpringTransactionAwareHandleAwareUnitOfWork> {
    private static final Logger log = LoggerFactory.getLogger(SpringTransactionAwareJdbiUnitOfWorkFactory.class);
    final Jdbi jdbi;

    public SpringTransactionAwareJdbiUnitOfWorkFactory(Jdbi jdbi, PlatformTransactionManager platformTransactionManager) {
        super(platformTransactionManager);
        this.jdbi = (Jdbi)FailFast.requireNonNull((Object)jdbi, (String)"No jdbi instance provided");
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    @Override
    protected SpringTransactionAwareHandleAwareUnitOfWork createUnitOfWorkForFactoryManagedTransaction(TransactionStatus transaction) {
        return new SpringTransactionAwareHandleAwareUnitOfWork(this, transaction);
    }

    @Override
    protected SpringTransactionAwareHandleAwareUnitOfWork createUnitOfWorkForSpringManagedTransaction() {
        return new SpringTransactionAwareHandleAwareUnitOfWork(this);
    }

    public static class SpringTransactionAwareHandleAwareUnitOfWork
    extends SpringTransactionAwareUnitOfWork<PlatformTransactionManager, SpringTransactionAwareHandleAwareUnitOfWork>
    implements HandleAwareUnitOfWork {
        private static final Logger log = LoggerFactory.getLogger(SpringTransactionAwareHandleAwareUnitOfWork.class);
        private Handle handle;

        public SpringTransactionAwareHandleAwareUnitOfWork(SpringTransactionAwareUnitOfWorkFactory<PlatformTransactionManager, SpringTransactionAwareHandleAwareUnitOfWork> unitOfWorkFactory) {
            super(unitOfWorkFactory);
        }

        public SpringTransactionAwareHandleAwareUnitOfWork(SpringTransactionAwareUnitOfWorkFactory<PlatformTransactionManager, SpringTransactionAwareHandleAwareUnitOfWork> unitOfWorkFactory, TransactionStatus manuallyManagedSpringTransaction) {
            super(unitOfWorkFactory, manuallyManagedSpringTransaction);
        }

        @Override
        public Handle handle() {
            if (this.handle == null) {
                throw new IllegalStateException("UnitOfWork hasn't been started");
            }
            return this.handle;
        }

        @Override
        protected void onStart() {
            log.trace("Opening JDBI handle");
            this.handle = ((SpringTransactionAwareJdbiUnitOfWorkFactory)this.unitOfWorkFactory).jdbi.open();
            this.handle.begin();
        }

        @Override
        protected void onCleanup() {
            if (this.handle == null) {
                return;
            }
            log.trace("Closing JDBI handle");
            try {
                this.handle.close();
            }
            catch (Exception e) {
                log.error("Failed to close JDBI handle", (Throwable)e);
            }
            finally {
                this.handle = null;
            }
        }
    }
}

