/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.fencedlock;

import dk.cloudcreate.essentials.components.foundation.fencedlock.FencedLock;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockCallbackBuilder;
import dk.cloudcreate.essentials.shared.FailFast;
import java.util.function.Consumer;

public interface LockCallback {
    public void lockAcquired(FencedLock var1);

    public void lockReleased(FencedLock var1);

    public static LockCallbackBuilder builder() {
        return new LockCallbackBuilder();
    }

    public static LockCallback lockCallback(final Consumer<FencedLock> onLockAcquired, final Consumer<FencedLock> onLockReleased) {
        FailFast.requireNonNull(onLockAcquired, (String)"No lockAcquired consumer provided");
        FailFast.requireNonNull(onLockReleased, (String)"No onLockReleased consumer provided");
        return new LockCallback(){

            @Override
            public void lockAcquired(FencedLock lock) {
                onLockAcquired.accept(lock);
            }

            @Override
            public void lockReleased(FencedLock lock) {
                onLockReleased.accept(lock);
            }
        };
    }
}

