/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward;

import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward.InboxConfigBuilder;
import dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward.InboxName;
import dk.cloudcreate.essentials.components.foundation.messaging.eip.store_and_forward.MessageConsumptionMode;
import dk.cloudcreate.essentials.shared.FailFast;
import java.util.Objects;

public class InboxConfig {
    public final InboxName inboxName;
    public final RedeliveryPolicy redeliveryPolicy;
    public final MessageConsumptionMode messageConsumptionMode;
    public final int numberOfParallelMessageConsumers;

    public InboxConfig(InboxName inboxName, RedeliveryPolicy redeliveryPolicy, MessageConsumptionMode messageConsumptionMode, int numberOfParallelMessageConsumers) {
        this.inboxName = (InboxName)((Object)FailFast.requireNonNull((Object)((Object)inboxName), (String)"No inboxName provided"));
        this.redeliveryPolicy = (RedeliveryPolicy)FailFast.requireNonNull((Object)redeliveryPolicy, (String)"No redeliveryPolicy provided");
        this.messageConsumptionMode = (MessageConsumptionMode)((Object)FailFast.requireNonNull((Object)((Object)messageConsumptionMode), (String)"No messageConsumptionMode specified"));
        FailFast.requireTrue((numberOfParallelMessageConsumers >= 1 ? 1 : 0) != 0, (String)"You must specify a number of parallelMessageConsumers >= 1");
        this.numberOfParallelMessageConsumers = numberOfParallelMessageConsumers;
    }

    public static InboxConfigBuilder builder() {
        return new InboxConfigBuilder();
    }

    public InboxName getInboxName() {
        return this.inboxName;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public MessageConsumptionMode getMessageConsumptionMode() {
        return this.messageConsumptionMode;
    }

    public int getNumberOfParallelMessageConsumers() {
        return this.numberOfParallelMessageConsumers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboxConfig that = (InboxConfig)o;
        return this.inboxName.equals((Object)that.inboxName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inboxName});
    }

    public String toString() {
        return "InboxConfig{inboxName=" + this.inboxName + ", redeliveryPolicy=" + this.redeliveryPolicy + ", messageConsumptionMode=" + this.messageConsumptionMode + ", numberOfParallelMessageConsumers=" + this.numberOfParallelMessageConsumers + "}";
    }
}

