/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.types;

import com.fasterxml.uuid.Generators;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.reflection.Classes;
import java.util.UUID;
import java.util.function.Supplier;

public final class RandomIdGenerator {
    private static Supplier<String> randomIdGenerator;
    private static boolean isSequentialIdGenerator;

    public static void overrideRandomIdGenerator(Supplier<String> randomIdGenerator, boolean isSequentialIdGenerator) {
        RandomIdGenerator.randomIdGenerator = (Supplier)FailFast.requireNonNull(randomIdGenerator, (String)"No randomIdGenerator instance provided");
        RandomIdGenerator.isSequentialIdGenerator = isSequentialIdGenerator;
    }

    public static String generate() {
        return randomIdGenerator.get();
    }

    public static boolean isOrderedIdGenerator() {
        return isSequentialIdGenerator;
    }

    static {
        if (Classes.doesClassExistOnClasspath((String)"com.fasterxml.uuid.Generators")) {
            randomIdGenerator = () -> Generators.timeBasedGenerator().generate().toString();
            isSequentialIdGenerator = true;
        } else {
            randomIdGenerator = () -> UUID.randomUUID().toString();
            isSequentialIdGenerator = false;
        }
    }
}

