/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.fencedlock;

import dk.cloudcreate.essentials.components.foundation.fencedlock.DBFencedLockManager;
import dk.cloudcreate.essentials.components.foundation.fencedlock.FencedLock;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockCallback;
import dk.cloudcreate.essentials.components.foundation.fencedlock.LockName;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DBFencedLock
implements FencedLock {
    private LockName lockName;
    private Long currentToken;
    private String lockedByLockManagerInstanceId;
    private OffsetDateTime lockAcquiredTimestamp;
    private OffsetDateTime lockLastConfirmedTimestamp;
    private transient DBFencedLockManager<? extends UnitOfWork, DBFencedLock> fencedLockManager;
    private transient List<LockCallback> lockCallbacks;

    public DBFencedLock(DBFencedLockManager<? extends UnitOfWork, DBFencedLock> fencedLockManager, LockName lockName, Long currentToken, String lockedByBusInstanceId, OffsetDateTime lockAcquiredTimestamp, OffsetDateTime lockLastConfirmedTimestamp) {
        this.fencedLockManager = fencedLockManager;
        this.lockName = lockName;
        this.currentToken = currentToken;
        this.lockedByLockManagerInstanceId = lockedByBusInstanceId;
        this.lockAcquiredTimestamp = lockAcquiredTimestamp;
        this.lockLastConfirmedTimestamp = lockLastConfirmedTimestamp;
        this.lockCallbacks = new ArrayList<LockCallback>();
    }

    @Override
    public LockName getName() {
        return this.lockName;
    }

    @Override
    public Long getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public String getLockedByLockManagerInstanceId() {
        return this.lockedByLockManagerInstanceId;
    }

    @Override
    public OffsetDateTime getLockAcquiredTimestamp() {
        return this.lockAcquiredTimestamp;
    }

    @Override
    public OffsetDateTime getLockLastConfirmedTimestamp() {
        return this.lockLastConfirmedTimestamp;
    }

    @Override
    public boolean isLocked() {
        return this.lockedByLockManagerInstanceId != null;
    }

    @Override
    public boolean isLockedByThisLockManagerInstance() {
        return this.isLocked() && Objects.equals(this.lockedByLockManagerInstanceId, this.fencedLockManager.getLockManagerInstanceId());
    }

    @Override
    public void release() {
        this.fencedLockManager.releaseLock(this);
    }

    @Override
    public void registerCallback(LockCallback lockCallback) {
        this.lockCallbacks.add(lockCallback);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBFencedLock that = (DBFencedLock)o;
        return this.getName().equals((Object)that.getName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName()});
    }

    public Duration getDurationSinceLastConfirmation() {
        FailFast.requireNonNull((Object)this.lockLastConfirmedTimestamp, (String)MessageFormatter.msg((String)"FencedLock '{}' doesn't have a lockLastConfirmedTimestamp", (Object[])new Object[]{this.getName()}));
        return Duration.between(this.lockLastConfirmedTimestamp, ZonedDateTime.now()).abs();
    }

    public void markAsReleased() {
        this.lockCallbacks.forEach(lockCallback -> lockCallback.lockReleased(this));
        this.lockedByLockManagerInstanceId = null;
    }

    DBFencedLock markAsConfirmed(OffsetDateTime confirmedTimestamp) {
        this.lockLastConfirmedTimestamp = (OffsetDateTime)FailFast.requireNonNull((Object)confirmedTimestamp, (String)"confirmedTimestamp is null");
        return this;
    }

    public DBFencedLock markAsLocked(OffsetDateTime lockTime, String lockedByLockManagerInstanceId, long currentToken) {
        this.lockAcquiredTimestamp = (OffsetDateTime)FailFast.requireNonNull((Object)lockTime, (String)"lockTime is null");
        this.lockLastConfirmedTimestamp = (OffsetDateTime)FailFast.requireNonNull((Object)lockTime, (String)"lockTime is null");
        this.lockedByLockManagerInstanceId = (String)FailFast.requireNonNull((Object)lockedByLockManagerInstanceId, (String)"lockedByLockManagerInstanceId is null");
        this.currentToken = currentToken;
        this.lockCallbacks.forEach(lockCallback -> lockCallback.lockAcquired(this));
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{lockName=" + this.lockName + ", currentTokenIssuedToThisLockInstance=" + this.currentToken + ", lockedByLockManagerInstanceId='" + this.lockedByLockManagerInstanceId + "', lockAcquiredTimestamp=" + this.lockAcquiredTimestamp + ", lockLastConfirmedTimestamp=" + this.lockLastConfirmedTimestamp + "}";
    }
}

