/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging;

import dk.cloudcreate.essentials.components.foundation.messaging.MessageDeliveryErrorHandlerBuilder;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import java.util.List;

@FunctionalInterface
public interface MessageDeliveryErrorHandler {
    public boolean isPermanentError(QueuedMessage var1, Exception var2);

    public static MessageDeliveryErrorHandler alwaysRetry() {
        return new AlwaysRetry();
    }

    public static MessageDeliveryErrorHandler stopRedeliveryOn(Class<? extends Exception> ... exceptions) {
        FailFast.requireNonNull(exceptions, (String)"Null provided instead of an array of exception classes");
        return MessageDeliveryErrorHandler.stopRedeliveryOn(List.of(exceptions));
    }

    public static MessageDeliveryErrorHandler stopRedeliveryOn(List<Class<? extends Exception>> exceptions) {
        FailFast.requireNonNull(exceptions, (String)"No exceptions list provided");
        return new StopRedeliveryOn(exceptions);
    }

    public static MessageDeliveryErrorHandlerBuilder builder() {
        return new MessageDeliveryErrorHandlerBuilder();
    }

    public static class NeverRetry
    implements MessageDeliveryErrorHandler {
        @Override
        public boolean isPermanentError(QueuedMessage queuedMessage, Exception error) {
            return true;
        }

        public String toString() {
            return "NeverRetry";
        }
    }

    public static class AlwaysRetry
    implements MessageDeliveryErrorHandler {
        @Override
        public boolean isPermanentError(QueuedMessage queuedMessage, Exception error) {
            return false;
        }

        public String toString() {
            return "AlwaysRetry";
        }
    }

    public static class StopRedeliveryOn
    implements MessageDeliveryErrorHandler {
        private final List<Class<? extends Exception>> exceptions;

        public StopRedeliveryOn(List<Class<? extends Exception>> exceptions) {
            this.exceptions = exceptions;
        }

        @Override
        public boolean isPermanentError(QueuedMessage queuedMessage, Exception error) {
            return this.exceptions.contains(error.getClass()) || this.exceptions.stream().anyMatch(exception -> exception.isAssignableFrom(error.getClass()));
        }

        public String toString() {
            return "StopRedeliveryOn{" + this.exceptions + "}";
        }
    }
}

