/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging;

import dk.cloudcreate.essentials.components.foundation.messaging.MessageDeliveryErrorHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import java.util.List;

public class MessageDeliveryErrorHandlerBuilder {
    private List<Class<? extends Exception>> alwaysRetryOnExceptions = List.of();
    private List<Class<? extends Exception>> stopRedeliveryOnExceptions = List.of();

    @SafeVarargs
    public final MessageDeliveryErrorHandlerBuilder alwaysRetryOn(Class<? extends Exception> ... exceptions) {
        return this.alwaysRetryOn(List.of(exceptions));
    }

    public MessageDeliveryErrorHandlerBuilder alwaysRetryOn(List<Class<? extends Exception>> exceptions) {
        this.alwaysRetryOnExceptions = (List)FailFast.requireNonNull(exceptions, (String)"No exceptions list provided");
        return this;
    }

    @SafeVarargs
    public final MessageDeliveryErrorHandlerBuilder stopRedeliveryOn(Class<? extends Exception> ... exceptions) {
        return this.stopRedeliveryOn(List.of(exceptions));
    }

    public MessageDeliveryErrorHandlerBuilder stopRedeliveryOn(List<Class<? extends Exception>> exceptions) {
        this.stopRedeliveryOnExceptions = (List)FailFast.requireNonNull(exceptions, (String)"No exceptions list provided");
        return this;
    }

    public String toString() {
        return "MessageDeliveryErrorHandlerBuilder{alwaysRetryOnExceptions=" + this.alwaysRetryOnExceptions + ", stopRedeliveryOnExceptions=" + this.stopRedeliveryOnExceptions + "}";
    }

    public MessageDeliveryErrorHandler build() {
        final MessageDeliveryErrorHandler stopRedeliveryOnHandler = MessageDeliveryErrorHandler.stopRedeliveryOn(this.stopRedeliveryOnExceptions);
        return new MessageDeliveryErrorHandler(){

            @Override
            public boolean isPermanentError(QueuedMessage queuedMessage, Exception error) {
                if (this.shouldAlwaysRetryOn(error)) {
                    return false;
                }
                return stopRedeliveryOnHandler.isPermanentError(queuedMessage, error);
            }

            private boolean shouldAlwaysRetryOn(Exception error) {
                return MessageDeliveryErrorHandlerBuilder.this.alwaysRetryOnExceptions.contains(error.getClass()) || MessageDeliveryErrorHandlerBuilder.this.alwaysRetryOnExceptions.stream().anyMatch(exception -> exception.isAssignableFrom(error.getClass()));
            }

            public String toString() {
                return "MessageDeliveryErrorHandler{alwaysRetryOnExceptions=" + MessageDeliveryErrorHandlerBuilder.this.alwaysRetryOnExceptions + ", stopRedeliveryOnExceptions=" + MessageDeliveryErrorHandlerBuilder.this.stopRedeliveryOnExceptions + "}";
            }
        };
    }
}

