/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue;

import dk.cloudcreate.essentials.components.foundation.Lifecycle;
import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueueConsumer;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueuesInterceptor;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.Message;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.NextQueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessageHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.TransactionalMode;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.AcknowledgeMessageAsHandled;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.ConsumeFromQueue;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.DeleteMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetDeadLetterMessages;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetNextMessageReadyForDelivery;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetQueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetQueuedMessages;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetTotalDeadLetterMessagesQueuedFor;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetTotalMessagesQueuedFor;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.MarkAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.PurgeQueue;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessageAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessages;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.ResurrectDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.RetryMessage;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkFactory;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface DurableQueues
extends Lifecycle {
    public Set<QueueName> getQueueNames();

    public DurableQueues addInterceptor(DurableQueuesInterceptor var1);

    default public DurableQueues addInterceptors(List<DurableQueuesInterceptor> interceptors) {
        FailFast.requireNonNull(interceptors, (String)"No interceptors list provided");
        interceptors.forEach(this::addInterceptor);
        return this;
    }

    public DurableQueues removeInterceptor(DurableQueuesInterceptor var1);

    public Optional<QueueName> getQueueNameFor(QueueEntryId var1);

    default public Optional<QueuedMessage> getDeadLetterMessage(QueueEntryId queueEntryId) {
        return this.getDeadLetterMessage(new GetDeadLetterMessage(queueEntryId));
    }

    public Optional<QueuedMessage> getDeadLetterMessage(GetDeadLetterMessage var1);

    default public Optional<QueuedMessage> getQueuedMessage(QueueEntryId queueEntryId) {
        return this.getQueuedMessage(new GetQueuedMessage(queueEntryId));
    }

    public Optional<QueuedMessage> getQueuedMessage(GetQueuedMessage var1);

    public TransactionalMode getTransactionalMode();

    public Optional<UnitOfWorkFactory<? extends UnitOfWork>> getUnitOfWorkFactory();

    default public DurableQueueConsumer consumeFromQueue(String consumerName, QueueName queueName, RedeliveryPolicy redeliveryPolicy, int parallelConsumers, QueuedMessageHandler queueMessageHandler) {
        return this.consumeFromQueue(ConsumeFromQueue.builder().setConsumerName(consumerName).setQueueName(queueName).setRedeliveryPolicy(redeliveryPolicy).setParallelConsumers(parallelConsumers).setQueueMessageHandler(queueMessageHandler).build());
    }

    default public DurableQueueConsumer consumeFromQueue(QueueName queueName, RedeliveryPolicy redeliveryPolicy, int parallelConsumers, QueuedMessageHandler queueMessageHandler) {
        return this.consumeFromQueue(ConsumeFromQueue.builder().setQueueName(queueName).setRedeliveryPolicy(redeliveryPolicy).setParallelConsumers(parallelConsumers).setQueueMessageHandler(queueMessageHandler).build());
    }

    public DurableQueueConsumer consumeFromQueue(ConsumeFromQueue var1);

    default public QueueEntryId queueMessage(QueueName queueName, Message message) {
        return this.queueMessage(queueName, message, Optional.empty(), Optional.empty());
    }

    public QueueEntryId queueMessage(QueueMessage var1);

    default public QueueEntryId queueMessage(QueueName queueName, Message message, Optional<Duration> deliveryDelay) {
        return this.queueMessage(queueName, message, Optional.empty(), deliveryDelay);
    }

    default public QueueEntryId queueMessage(QueueName queueName, Message message, Duration deliveryDelay) {
        return this.queueMessage(queueName, message, Optional.empty(), Optional.ofNullable(deliveryDelay));
    }

    default public QueueEntryId queueMessage(QueueName queueName, Message message, Optional<Exception> causeOfEnqueuing, Optional<Duration> deliveryDelay) {
        return this.queueMessage(new QueueMessage(queueName, message, causeOfEnqueuing, deliveryDelay));
    }

    default public QueueEntryId queueMessage(QueueName queueName, Message message, Exception causeOfEnqueuing, Duration deliveryDelay) {
        return this.queueMessage(queueName, message, Optional.ofNullable(causeOfEnqueuing), Optional.ofNullable(deliveryDelay));
    }

    default public QueueEntryId queueMessageAsDeadLetterMessage(QueueName queueName, Message message, Exception causeOfError) {
        return this.queueMessageAsDeadLetterMessage(new QueueMessageAsDeadLetterMessage(queueName, message, causeOfError));
    }

    public QueueEntryId queueMessageAsDeadLetterMessage(QueueMessageAsDeadLetterMessage var1);

    default public List<QueueEntryId> queueMessages(QueueName queueName, List<? extends Message> messages, Optional<Duration> deliveryDelay) {
        return this.queueMessages(new QueueMessages(queueName, messages, deliveryDelay));
    }

    default public List<QueueEntryId> queueMessages(QueueName queueName, List<? extends Message> messages, Duration deliveryDelay) {
        return this.queueMessages(queueName, messages, Optional.ofNullable(deliveryDelay));
    }

    default public List<QueueEntryId> queueMessages(QueueName queueName, List<? extends Message> messages) {
        return this.queueMessages(queueName, messages, Optional.empty());
    }

    public List<QueueEntryId> queueMessages(QueueMessages var1);

    default public Optional<QueuedMessage> retryMessage(QueueEntryId queueEntryId, Exception causeForRetry, Duration deliveryDelay) {
        return this.retryMessage(new RetryMessage(queueEntryId, causeForRetry, deliveryDelay));
    }

    public Optional<QueuedMessage> retryMessage(RetryMessage var1);

    default public Optional<QueuedMessage> markAsDeadLetterMessage(QueueEntryId queueEntryId, Exception causeForBeingMarkedAsDeadLetter) {
        return this.markAsDeadLetterMessage(new MarkAsDeadLetterMessage(queueEntryId, causeForBeingMarkedAsDeadLetter));
    }

    public Optional<QueuedMessage> markAsDeadLetterMessage(MarkAsDeadLetterMessage var1);

    default public Optional<QueuedMessage> resurrectDeadLetterMessage(QueueEntryId queueEntryId, Duration deliveryDelay) {
        return this.resurrectDeadLetterMessage(new ResurrectDeadLetterMessage(queueEntryId, deliveryDelay));
    }

    public Optional<QueuedMessage> resurrectDeadLetterMessage(ResurrectDeadLetterMessage var1);

    default public boolean acknowledgeMessageAsHandled(QueueEntryId queueEntryId) {
        return this.acknowledgeMessageAsHandled(new AcknowledgeMessageAsHandled(queueEntryId));
    }

    public boolean acknowledgeMessageAsHandled(AcknowledgeMessageAsHandled var1);

    default public boolean deleteMessage(QueueEntryId queueEntryId) {
        return this.deleteMessage(new DeleteMessage(queueEntryId));
    }

    public boolean deleteMessage(DeleteMessage var1);

    default public Optional<QueuedMessage> getNextMessageReadyForDelivery(QueueName queueName) {
        return this.getNextMessageReadyForDelivery(new GetNextMessageReadyForDelivery(queueName));
    }

    public Optional<QueuedMessage> getNextMessageReadyForDelivery(GetNextMessageReadyForDelivery var1);

    public boolean hasMessagesQueuedFor(QueueName var1);

    default public long getTotalMessagesQueuedFor(QueueName queueName) {
        return this.getTotalMessagesQueuedFor(new GetTotalMessagesQueuedFor(queueName));
    }

    public long getTotalMessagesQueuedFor(GetTotalMessagesQueuedFor var1);

    default public long getTotalDeadLetterMessagesQueuedFor(QueueName queueName) {
        return this.getTotalDeadLetterMessagesQueuedFor(new GetTotalDeadLetterMessagesQueuedFor(queueName));
    }

    public long getTotalDeadLetterMessagesQueuedFor(GetTotalDeadLetterMessagesQueuedFor var1);

    default public List<QueuedMessage> getQueuedMessages(QueueName queueName, QueueingSortOrder queueingSortOrder, long startIndex, long pageSize) {
        return this.getQueuedMessages(GetQueuedMessages.builder().setQueueName(queueName).setQueueingSortOrder(queueingSortOrder).setStartIndex(startIndex).setPageSize(pageSize).build());
    }

    public List<QueuedMessage> getQueuedMessages(GetQueuedMessages var1);

    default public List<QueuedMessage> getDeadLetterMessages(QueueName queueName, QueueingSortOrder queueingSortOrder, long startIndex, long pageSize) {
        return this.getDeadLetterMessages(GetDeadLetterMessages.builder().setQueueName(queueName).setQueueingSortOrder(queueingSortOrder).setStartIndex(startIndex).setPageSize(pageSize).build());
    }

    public List<QueuedMessage> getDeadLetterMessages(GetDeadLetterMessages var1);

    default public int purgeQueue(QueueName queueName) {
        return this.purgeQueue(new PurgeQueue(queueName));
    }

    public int purgeQueue(PurgeQueue var1);

    default public List<NextQueuedMessage> queryForMessagesSoonReadyForDelivery(QueueName queueName, int maxNumberOfMessagesToReturn) {
        return this.queryForMessagesSoonReadyForDelivery(queueName, Instant.now(), maxNumberOfMessagesToReturn);
    }

    public List<NextQueuedMessage> queryForMessagesSoonReadyForDelivery(QueueName var1, Instant var2, int var3);

    public static enum QueueingSortOrder {
        ASC,
        DESC;

    }
}

