/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Instant;
import java.util.Objects;

public class NextQueuedMessage
implements Comparable<NextQueuedMessage> {
    public final QueueEntryId id;
    public final QueueName queueName;
    public final Instant addedTimestamp;
    public final Instant nextDeliveryTimestamp;

    public NextQueuedMessage(QueueEntryId id, QueueName queueName, Instant addedTimestamp, Instant nextDeliveryTimestamp) {
        this.id = (QueueEntryId)((Object)FailFast.requireNonNull((Object)((Object)id), (String)"No id provided"));
        this.queueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided"));
        this.addedTimestamp = (Instant)FailFast.requireNonNull((Object)addedTimestamp, (String)"No addedTimestamp provided");
        this.nextDeliveryTimestamp = (Instant)FailFast.requireNonNull((Object)nextDeliveryTimestamp, (String)"No nextDeliveryTimestamp provided");
    }

    public NextQueuedMessage(QueuedMessage queuedMessage) {
        this(queuedMessage.getId(), queuedMessage.getQueueName(), queuedMessage.getAddedTimestamp().toInstant(), queuedMessage.getNextDeliveryTimestamp().toInstant());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NextQueuedMessage that = (NextQueuedMessage)o;
        return Objects.equals((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id});
    }

    public String toString() {
        return "NextQueuedMessage{id=" + this.id + ", queueName=" + this.queueName + ", addedTimestamp=" + this.addedTimestamp + ", nextDeliveryTimestamp=" + this.nextDeliveryTimestamp + "}";
    }

    @Override
    public int compareTo(NextQueuedMessage o) {
        return this.nextDeliveryTimestamp.compareTo(o.nextDeliveryTimestamp);
    }
}

