/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.Message;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.MessageMetaData;
import dk.cloudcreate.essentials.shared.FailFast;

public class OrderedMessage
extends Message {
    public final String key;
    public final long order;

    public OrderedMessage(Object payload, String key, long order) {
        super(payload);
        this.key = (String)FailFast.requireNonNull((Object)key, (String)"No message key provided");
        FailFast.requireTrue((order >= 0L ? 1 : 0) != 0, (String)"order must be >= 0");
        this.order = order;
    }

    public OrderedMessage(Object payload, String key, long order, MessageMetaData metaData) {
        super(payload, metaData);
        this.key = (String)FailFast.requireNonNull((Object)key, (String)"No message key provided");
        FailFast.requireTrue((order >= 0L ? 1 : 0) != 0, (String)"order must be >= 0");
        this.order = order;
    }

    public static OrderedMessage of(Object payload, String key, long order) {
        return new OrderedMessage(payload, key, order);
    }

    public static OrderedMessage of(Object payload, String key, long order, MessageMetaData metaData) {
        return new OrderedMessage(payload, key, order, metaData);
    }

    public String getKey() {
        return this.key;
    }

    public long getOrder() {
        return this.order;
    }

    @Override
    public String toString() {
        return "OrderedMessage{payload-type=" + this._1.getClass().getName() + ", key='" + this.key + "', order=" + this.order + ", metaData=" + this._2 + "}";
    }
}

