/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue;

import dk.cloudcreate.essentials.components.foundation.messaging.MessageHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessageHandler;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.invocation.InvocationStrategy;
import dk.cloudcreate.essentials.shared.reflection.invocation.MethodPatternMatcher;
import dk.cloudcreate.essentials.shared.reflection.invocation.PatternMatchingMethodInvoker;
import java.lang.reflect.Method;

public class PatternMatchingQueuedMessageHandler
implements QueuedMessageHandler {
    private final PatternMatchingMethodInvoker<Object> invoker;
    private final Object invokeMessageHandlerMethodsOn;
    private boolean allowUnmatchedMessages = false;

    public PatternMatchingQueuedMessageHandler(Object invokeMessageHandlerMethodsOn) {
        this.invokeMessageHandlerMethodsOn = FailFast.requireNonNull((Object)invokeMessageHandlerMethodsOn, (String)"No invokeMessageHandlerMethodsOn provided");
        this.invoker = this.createMethodInvoker();
    }

    public PatternMatchingQueuedMessageHandler() {
        this.invokeMessageHandlerMethodsOn = this;
        this.invoker = this.createMethodInvoker();
    }

    private PatternMatchingMethodInvoker<Object> createMethodInvoker() {
        return new PatternMatchingMethodInvoker(this.invokeMessageHandlerMethodsOn, (MethodPatternMatcher)new QueuedMessageHandlerMethodPatternMatcher(), InvocationStrategy.InvokeMostSpecificTypeMatched);
    }

    public boolean isAllowUnmatchedMessages() {
        return this.allowUnmatchedMessages;
    }

    public void setAllowUnmatchedMessages(boolean allowUnmatchedMessages) {
        this.allowUnmatchedMessages = allowUnmatchedMessages;
    }

    public void allowUnmatchedMessages() {
        this.setAllowUnmatchedMessages(true);
    }

    @Override
    public void handle(QueuedMessage queuedMessage) {
        this.invoker.invoke((Object)queuedMessage, unmatchedEvent -> this.handleUnmatchedMessage(queuedMessage));
    }

    protected void handleUnmatchedMessage(QueuedMessage queuedMessage) {
        if (!this.allowUnmatchedMessages) {
            throw new IllegalArgumentException(MessageFormatter.msg((String)"Unmatched Message with payload-type: '{}'", (Object[])new Object[]{queuedMessage.getMessage().getPayload().getClass().getName()}));
        }
    }

    private static class QueuedMessageHandlerMethodPatternMatcher
    implements MethodPatternMatcher<Object> {
        private QueuedMessageHandlerMethodPatternMatcher() {
        }

        public boolean isInvokableMethod(Method method) {
            boolean isCandidate;
            FailFast.requireNonNull((Object)method, (String)"No candidate method supplied");
            boolean bl = isCandidate = method.isAnnotationPresent(MessageHandler.class) && method.getParameterCount() >= 1 && method.getParameterCount() <= 2;
            if (isCandidate && method.getParameterCount() == 2) {
                return QueuedMessage.class.equals(method.getParameterTypes()[1]);
            }
            return isCandidate;
        }

        public Class<?> resolveInvocationArgumentTypeFromMethodDefinition(Method method) {
            FailFast.requireNonNull((Object)method, (String)"No method supplied");
            return method.getParameterTypes()[0];
        }

        public Class<?> resolveInvocationArgumentTypeFromObject(Object argument) {
            FailFast.requireNonNull((Object)argument, (String)"No argument supplied");
            FailFast.requireMustBeInstanceOf((Object)argument, QueuedMessage.class);
            QueuedMessage queuedMessage = (QueuedMessage)argument;
            return queuedMessage.getPayload().getClass();
        }

        public void invokeMethod(Method methodToInvoke, Object argument, Object invokeMethodOn, Class<?> resolvedInvokeMethodWithArgumentOfType) throws Exception {
            FailFast.requireNonNull((Object)methodToInvoke, (String)"No methodToInvoke supplied");
            FailFast.requireNonNull((Object)argument, (String)"No argument supplied");
            FailFast.requireMustBeInstanceOf((Object)argument, QueuedMessage.class);
            FailFast.requireNonNull((Object)invokeMethodOn, (String)"No invokeMethodOn supplied");
            FailFast.requireNonNull(resolvedInvokeMethodWithArgumentOfType, (String)"No resolvedInvokeMethodWithArgumentOfType supplied");
            QueuedMessage queuedMessage = (QueuedMessage)argument;
            Object payload = queuedMessage.getPayload();
            if (methodToInvoke.getParameterCount() == 1) {
                methodToInvoke.invoke(invokeMethodOn, payload);
            } else {
                methodToInvoke.invoke(invokeMethodOn, payload, queuedMessage);
            }
        }
    }
}

