/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue.micrometer;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueues;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueuesInterceptor;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.DeleteMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.MarkAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessageAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessages;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.ResurrectDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.RetryMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.interceptor.InterceptorChain;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class DurableQueuesMicrometerInterceptor
implements DurableQueuesInterceptor {
    public static final String PROCESSED_QUEUED_MESSAGES_COUNTER_NAME = "DurableQueues_QueuedMessages_Processed_";
    public static final String PROCESSED_QUEUED_MESSAGES_RETRIES_COUNTER_NAME = "DurableQueues_QueuedMessages_Retries_";
    public static final String PROCESSED_DEAD_LETTER_MESSAGES_COUNTER_NAME = "DurableQueues_DeadLetterMessages_Processed_";
    public static final String QUEUE_NAME_TAG_NAME = "QueueName";
    private final MeterRegistry meterRegistry;
    private final ConcurrentHashMap<QueueName, QueueGauges> queueGauges = new ConcurrentHashMap();
    private DurableQueues durableQueues;

    public DurableQueuesMicrometerInterceptor(MeterRegistry meterRegistry) {
        this.meterRegistry = (MeterRegistry)FailFast.requireNonNull((Object)meterRegistry, (String)"No meterRegistry instance provided");
    }

    @Override
    public void setDurableQueues(DurableQueues durableQueues) {
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
        durableQueues.getQueueNames().forEach(this::addQueueGaugeIfMissing);
    }

    private void addQueueGaugeIfMissing(QueueName queueName) {
        this.queueGauges.computeIfAbsent(queueName, _queueName -> {
            QueueGauges gauges = new QueueGauges();
            gauges.queuedMessagesGauge = Gauge.builder((String)("DurableQueues_QueuedMessages_Size_" + queueName.toString()), () -> this.durableQueues.getTotalMessagesQueuedFor(queueName)).register(this.meterRegistry);
            gauges.deadLetterMessagesGauge = Gauge.builder((String)("DurableQueues_DeadLetterMessages_Size_" + queueName.toString()), () -> this.durableQueues.getTotalMessagesQueuedFor(queueName)).register(this.meterRegistry);
            return gauges;
        });
    }

    @Override
    public QueueEntryId intercept(QueueMessage operation, InterceptorChain<QueueMessage, QueueEntryId, DurableQueuesInterceptor> interceptorChain) {
        QueueEntryId queueEntryId = (QueueEntryId)((Object)interceptorChain.proceed());
        this.addQueueGaugeIfMissing(operation.queueName);
        this.incProcessedQueuedMessagesCount(operation.queueName);
        return queueEntryId;
    }

    @Override
    public List<QueueEntryId> intercept(QueueMessages operation, InterceptorChain<QueueMessages, List<QueueEntryId>, DurableQueuesInterceptor> interceptorChain) {
        List queueEntryIds = (List)interceptorChain.proceed();
        this.addQueueGaugeIfMissing(operation.queueName);
        this.incProcessedQueuedMessagesCount(operation.queueName, queueEntryIds.size());
        return queueEntryIds;
    }

    @Override
    public QueueEntryId intercept(QueueMessageAsDeadLetterMessage operation, InterceptorChain<QueueMessageAsDeadLetterMessage, QueueEntryId, DurableQueuesInterceptor> interceptorChain) {
        QueueEntryId queueEntryId = (QueueEntryId)((Object)interceptorChain.proceed());
        this.addQueueGaugeIfMissing(operation.queueName);
        this.incProcessedQueuedDeadLetterMessagesCount(operation.queueName);
        return queueEntryId;
    }

    @Override
    public Optional<QueuedMessage> intercept(MarkAsDeadLetterMessage operation, InterceptorChain<MarkAsDeadLetterMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        Optional optionalQueuedMessage = (Optional)interceptorChain.proceed();
        optionalQueuedMessage.ifPresent(queuedMessage -> {
            this.addQueueGaugeIfMissing(queuedMessage.getQueueName());
            this.incProcessedQueuedDeadLetterMessagesCount(queuedMessage.getQueueName());
        });
        return optionalQueuedMessage;
    }

    @Override
    public boolean intercept(DeleteMessage operation, InterceptorChain<DeleteMessage, Boolean, DurableQueuesInterceptor> interceptorChain) {
        QueueName queueName = this.durableQueues.getQueueNameFor(operation.queueEntryId).orElse(null);
        Boolean succeeded = (Boolean)interceptorChain.proceed();
        if (succeeded.booleanValue() && queueName != null) {
            this.addQueueGaugeIfMissing(queueName);
        }
        return succeeded;
    }

    @Override
    public Optional<QueuedMessage> intercept(ResurrectDeadLetterMessage operation, InterceptorChain<ResurrectDeadLetterMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        Optional optionalQueuedMessage = (Optional)interceptorChain.proceed();
        optionalQueuedMessage.ifPresent(queuedMessage -> this.addQueueGaugeIfMissing(queuedMessage.getQueueName()));
        return optionalQueuedMessage;
    }

    @Override
    public Optional<QueuedMessage> intercept(RetryMessage operation, InterceptorChain<RetryMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        Optional optionalQueuedMessage = (Optional)interceptorChain.proceed();
        optionalQueuedMessage.ifPresent(queuedMessage -> this.addQueueGaugeIfMissing(queuedMessage.getQueueName()));
        return optionalQueuedMessage;
    }

    protected void incProcessedQueuedMessagesCount(QueueName queueName) {
        FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided");
        this.meterRegistry.counter(PROCESSED_QUEUED_MESSAGES_COUNTER_NAME + queueName.toString(), new String[]{QUEUE_NAME_TAG_NAME, queueName.toString()}).increment();
    }

    protected void incProcessedQueuedMessagesCount(QueueName queueName, int countIncrease) {
        FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided");
        this.meterRegistry.counter(PROCESSED_QUEUED_MESSAGES_COUNTER_NAME + queueName.toString(), new String[]{QUEUE_NAME_TAG_NAME, queueName.toString()}).increment((double)countIncrease);
    }

    protected void incProcessedQueuedDeadLetterMessagesCount(QueueName queueName) {
        FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided");
        this.meterRegistry.counter(PROCESSED_DEAD_LETTER_MESSAGES_COUNTER_NAME + queueName.toString(), new String[]{QUEUE_NAME_TAG_NAME, queueName.toString()}).increment();
    }

    protected void incQueuedMessagesRetriesCount(QueueName queueName) {
        FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided");
        this.meterRegistry.counter(PROCESSED_QUEUED_MESSAGES_RETRIES_COUNTER_NAME + queueName.toString(), new String[]{QUEUE_NAME_TAG_NAME, queueName.toString()}).increment();
    }

    private static class QueueGauges {
        private Gauge queuedMessagesGauge;
        private Gauge deadLetterMessagesGauge;

        private QueueGauges() {
        }
    }
}

