/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue.micrometer;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueues;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.DurableQueuesInterceptor;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.MessageMetaData;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueEntryId;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.AcknowledgeMessageAsHandled;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.DeleteMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetNextMessageReadyForDelivery;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.GetQueuedMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.MarkAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessageAsDeadLetterMessage;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessages;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.RetryMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.interceptor.InterceptorChain;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.transport.Kind;
import io.micrometer.observation.transport.ReceiverContext;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.propagation.Propagator;
import java.util.List;
import java.util.Optional;

public class DurableQueuesMicrometerTracingInterceptor
implements DurableQueuesInterceptor {
    public static final String QUEUE_ENTRY_ID = "queueEntryId";
    public static final String QUEUE_NAME = "queueName";
    private final Tracer tracer;
    private final Propagator propagator;
    private final ObservationRegistry observationRegistry;
    private final boolean verboseTracing;
    private final ThreadLocal<Observation.Scope> activeObservationScope = new ThreadLocal();
    private DurableQueues durableQueues;

    public DurableQueuesMicrometerTracingInterceptor(Tracer tracer, Propagator propagator, ObservationRegistry observationRegistry, boolean verboseTracing) {
        this.tracer = (Tracer)FailFast.requireNonNull((Object)tracer, (String)"No tracer instance provided");
        this.propagator = (Propagator)FailFast.requireNonNull((Object)propagator, (String)"No propagator instance provided");
        this.observationRegistry = (ObservationRegistry)FailFast.requireNonNull((Object)observationRegistry, (String)"No observationRegistry instance provided");
        this.verboseTracing = verboseTracing;
    }

    @Override
    public void setDurableQueues(DurableQueues durableQueues) {
        this.durableQueues = (DurableQueues)FailFast.requireNonNull((Object)durableQueues, (String)"No durableQueues instance provided");
    }

    @Override
    public QueueEntryId intercept(QueueMessage operation, InterceptorChain<QueueMessage, QueueEntryId, DurableQueuesInterceptor> interceptorChain) {
        this.storeTraceContext(operation.getMetaData());
        Observation observation = Observation.createNotStarted((String)("QueueMessage:" + operation.queueName.toString()), (ObservationRegistry)this.observationRegistry).lowCardinalityKeyValue(QUEUE_NAME, operation.queueName.toString());
        return (QueueEntryId)((Object)observation.observe(() -> {
            QueueEntryId queueEntryId = (QueueEntryId)((Object)((Object)interceptorChain.proceed()));
            observation.highCardinalityKeyValue(QUEUE_ENTRY_ID, queueEntryId.toString());
            return queueEntryId;
        }));
    }

    @Override
    public List<QueueEntryId> intercept(QueueMessages operation, InterceptorChain<QueueMessages, List<QueueEntryId>, DurableQueuesInterceptor> interceptorChain) {
        operation.messages.forEach(message -> this.storeTraceContext(message.getMetaData()));
        return (List)Observation.createNotStarted((String)("QueueMessages:" + operation.queueName.toString()), (ObservationRegistry)this.observationRegistry).highCardinalityKeyValue("numberOfMessages", Integer.toString(operation.messages.size())).lowCardinalityKeyValue(QUEUE_NAME, operation.queueName.toString()).observe(() -> interceptorChain.proceed());
    }

    @Override
    public Optional<QueuedMessage> intercept(GetDeadLetterMessage operation, InterceptorChain<GetDeadLetterMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        if (this.verboseTracing) {
            Optional potentialMessage = (Optional)Observation.createNotStarted((String)"GetDeadLetterMessage", (ObservationRegistry)this.observationRegistry).highCardinalityKeyValue(QUEUE_ENTRY_ID, operation.queueEntryId.toString()).observe(() -> interceptorChain.proceed());
            return potentialMessage.map(queuedMessage -> this.restoreTraceContext((QueuedMessage)queuedMessage, "DeadLetterMessage"));
        }
        return (Optional)interceptorChain.proceed();
    }

    @Override
    public Optional<QueuedMessage> intercept(GetQueuedMessage operation, InterceptorChain<GetQueuedMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        if (this.verboseTracing) {
            Optional potentialMessage = (Optional)Observation.createNotStarted((String)"GetQueuedMessage", (ObservationRegistry)this.observationRegistry).highCardinalityKeyValue(QUEUE_ENTRY_ID, operation.queueEntryId.toString()).observe(() -> interceptorChain.proceed());
            return potentialMessage.map(queuedMessage -> this.restoreTraceContext((QueuedMessage)queuedMessage, "GetQueuedMessage"));
        }
        return (Optional)interceptorChain.proceed();
    }

    @Override
    public Optional<QueuedMessage> intercept(GetNextMessageReadyForDelivery operation, InterceptorChain<GetNextMessageReadyForDelivery, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        Optional potentialMessage = (Optional)interceptorChain.proceed();
        return potentialMessage.map(queuedMessage -> this.restoreTraceContext((QueuedMessage)queuedMessage, "DeliverMessage"));
    }

    @Override
    public QueueEntryId intercept(QueueMessageAsDeadLetterMessage operation, InterceptorChain<QueueMessageAsDeadLetterMessage, QueueEntryId, DurableQueuesInterceptor> interceptorChain) {
        this.storeTraceContext(operation.getMetaData());
        return (QueueEntryId)((Object)Observation.createNotStarted((String)("QueueMessageAsDeadLetterMessage:" + operation.queueName.toString()), (ObservationRegistry)this.observationRegistry).lowCardinalityKeyValue(QUEUE_NAME, operation.queueName.toString()).observe(() -> interceptorChain.proceed()));
    }

    @Override
    public Optional<QueuedMessage> intercept(RetryMessage operation, InterceptorChain<RetryMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        return (Optional)Observation.createNotStarted((String)"RetryMessage", (ObservationRegistry)this.observationRegistry).highCardinalityKeyValue(QUEUE_ENTRY_ID, operation.queueEntryId.toString()).observe(() -> {
            Optional result = (Optional)interceptorChain.proceed();
            this.closeAnyActiveObservationScope();
            return result;
        });
    }

    @Override
    public Optional<QueuedMessage> intercept(MarkAsDeadLetterMessage operation, InterceptorChain<MarkAsDeadLetterMessage, Optional<QueuedMessage>, DurableQueuesInterceptor> interceptorChain) {
        return (Optional)Observation.createNotStarted((String)"MarkAsDeadLetterMessage", (ObservationRegistry)this.observationRegistry).highCardinalityKeyValue(QUEUE_ENTRY_ID, operation.queueEntryId.toString()).observe(() -> {
            Optional result = (Optional)interceptorChain.proceed();
            this.closeAnyActiveObservationScope();
            return result;
        });
    }

    @Override
    public boolean intercept(AcknowledgeMessageAsHandled operation, InterceptorChain<AcknowledgeMessageAsHandled, Boolean, DurableQueuesInterceptor> interceptorChain) {
        if (this.verboseTracing) {
            return Boolean.TRUE.equals(Observation.createNotStarted((String)"AcknowledgeMessageAsHandled", (ObservationRegistry)this.observationRegistry).highCardinalityKeyValue(QUEUE_ENTRY_ID, operation.queueEntryId.toString()).observe(() -> {
                Boolean result = (Boolean)interceptorChain.proceed();
                this.closeAnyActiveObservationScope();
                return result;
            }));
        }
        Boolean result = (Boolean)interceptorChain.proceed();
        this.closeAnyActiveObservationScope();
        return result;
    }

    @Override
    public boolean intercept(DeleteMessage operation, InterceptorChain<DeleteMessage, Boolean, DurableQueuesInterceptor> interceptorChain) {
        if (this.verboseTracing) {
            return Boolean.TRUE.equals(Observation.createNotStarted((String)"DeleteMessage", (ObservationRegistry)this.observationRegistry).highCardinalityKeyValue(QUEUE_ENTRY_ID, operation.queueEntryId.toString()).observe(() -> {
                Boolean result = (Boolean)interceptorChain.proceed();
                this.closeAnyActiveObservationScope();
                return result;
            }));
        }
        Boolean result = (Boolean)interceptorChain.proceed();
        this.closeAnyActiveObservationScope();
        return result;
    }

    protected void storeTraceContext(MessageMetaData messageMetaData) {
        CurrentTraceContext currentTraceContext;
        if (messageMetaData != null && (currentTraceContext = this.tracer.currentTraceContext()) != null && currentTraceContext.context() != null) {
            this.propagator.inject(currentTraceContext.context(), (Object)messageMetaData, MessageMetaData::put);
        }
    }

    protected QueuedMessage restoreTraceContext(QueuedMessage queuedMessage, String contextDescription) {
        FailFast.requireNonNull((Object)queuedMessage, (String)"No queuedMessage provided");
        FailFast.requireNonNull((Object)contextDescription, (String)"No contextDescription provided");
        this.closeAnyActiveObservationScope();
        Observation observation = Observation.start((String)(contextDescription + ":" + queuedMessage.getQueueName().toString()), () -> this.createTraceContextForMessage(queuedMessage), (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue(QUEUE_NAME, queuedMessage.getQueueName().toString());
        observation.highCardinalityKeyValue(QUEUE_ENTRY_ID, queuedMessage.getId().toString());
        observation.highCardinalityKeyValue("addedTimestamp", queuedMessage.getAddedTimestamp().toString());
        observation.highCardinalityKeyValue("deliveryTimestamp", queuedMessage.getDeliveryTimestamp() != null ? queuedMessage.getDeliveryTimestamp().toString() : "");
        observation.highCardinalityKeyValue("totalDeliveryAttempts", Integer.toString(queuedMessage.getTotalDeliveryAttempts()));
        observation.highCardinalityKeyValue("redeliveryAttempts", Integer.toString(queuedMessage.getRedeliveryAttempts()));
        this.activeObservationScope.set(observation.openScope());
        return queuedMessage;
    }

    private ReceiverContext<MessageMetaData> createTraceContextForMessage(QueuedMessage queuedMessage) {
        FailFast.requireNonNull((Object)queuedMessage, (String)"No queuedMessage provided");
        ReceiverContext context = new ReceiverContext(MessageMetaData::get, Kind.CONSUMER);
        context.setCarrier((Object)queuedMessage.getMetaData());
        return context;
    }

    private void closeAnyActiveObservationScope() {
        Observation.Scope activeScope = this.activeObservationScope.get();
        if (activeScope != null) {
            activeScope.close();
            activeScope.getCurrentObservation().stop();
            this.activeObservationScope.remove();
        }
    }
}

