/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue.operations;

import dk.cloudcreate.essentials.components.foundation.messaging.RedeliveryPolicy;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueuedMessageHandler;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.ConsumeFromQueueBuilder;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;

public class ConsumeFromQueue {
    public final String consumerName;
    public final QueueName queueName;
    private RedeliveryPolicy redeliveryPolicy;
    public final QueuedMessageHandler queueMessageHandler;
    private final int parallelConsumers;
    private Optional<ScheduledExecutorService> consumerExecutorService = Optional.empty();
    private final Duration pollingInterval;

    public static ConsumeFromQueueBuilder builder() {
        return new ConsumeFromQueueBuilder();
    }

    public ConsumeFromQueue(String consumerName, QueueName queueName, RedeliveryPolicy redeliveryPolicy, int parallelConsumers, QueuedMessageHandler queueMessageHandler, Duration pollingInterval) {
        this.consumerName = (String)FailFast.requireNonNull((Object)consumerName, (String)"No consumerName provided");
        this.queueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided"));
        this.redeliveryPolicy = (RedeliveryPolicy)FailFast.requireNonNull((Object)redeliveryPolicy, (String)"No redeliveryPolicy provided");
        this.parallelConsumers = parallelConsumers;
        this.queueMessageHandler = (QueuedMessageHandler)FailFast.requireNonNull((Object)queueMessageHandler, (String)"No queueMessageHandler provided");
        this.pollingInterval = (Duration)FailFast.requireNonNull((Object)pollingInterval, (String)"No pollingInterval provided");
    }

    public ConsumeFromQueue(String consumerName, QueueName queueName, RedeliveryPolicy redeliveryPolicy, int parallelConsumers, ScheduledExecutorService consumerExecutorService, QueuedMessageHandler queueMessageHandler, Duration pollingInterval) {
        this.consumerName = (String)FailFast.requireNonNull((Object)consumerName, (String)"No consumerName provided");
        this.queueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided"));
        this.redeliveryPolicy = (RedeliveryPolicy)FailFast.requireNonNull((Object)redeliveryPolicy, (String)"No redeliveryPolicy provided");
        this.parallelConsumers = parallelConsumers;
        this.consumerExecutorService = Optional.of(consumerExecutorService);
        this.queueMessageHandler = (QueuedMessageHandler)FailFast.requireNonNull((Object)queueMessageHandler, (String)"No queueMessageHandler provided");
        this.pollingInterval = (Duration)FailFast.requireNonNull((Object)pollingInterval, (String)"No pollingInterval provided");
    }

    public ConsumeFromQueue(String consumerName, QueueName queueName, RedeliveryPolicy redeliveryPolicy, int parallelConsumers, Optional<ScheduledExecutorService> consumerExecutorService, QueuedMessageHandler queueMessageHandler, Duration pollingInterval) {
        this.consumerName = (String)FailFast.requireNonNull((Object)consumerName, (String)"No consumerName provided");
        this.queueName = (QueueName)((Object)FailFast.requireNonNull((Object)((Object)queueName), (String)"No queueName provided"));
        this.redeliveryPolicy = (RedeliveryPolicy)FailFast.requireNonNull((Object)redeliveryPolicy, (String)"No redeliveryPolicy provided");
        this.queueMessageHandler = (QueuedMessageHandler)FailFast.requireNonNull((Object)queueMessageHandler, (String)"No queueMessageHandler provided");
        this.parallelConsumers = parallelConsumers;
        this.consumerExecutorService = (Optional)FailFast.requireNonNull(consumerExecutorService, (String)"No consumerExecutorService Optional provided");
        this.pollingInterval = (Duration)FailFast.requireNonNull((Object)pollingInterval, (String)"No pollingInterval provided");
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public Duration getPollingInterval() {
        return this.pollingInterval;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = (RedeliveryPolicy)FailFast.requireNonNull((Object)redeliveryPolicy, (String)"No redeliveryPolicy provided");
    }

    public QueueName getQueueName() {
        return this.queueName;
    }

    public int getParallelConsumers() {
        return this.parallelConsumers;
    }

    public Optional<ScheduledExecutorService> getConsumerExecutorService() {
        return this.consumerExecutorService;
    }

    public QueuedMessageHandler getQueueMessageHandler() {
        return this.queueMessageHandler;
    }

    public String toString() {
        return "ConsumeFromQueue{consumerName='" + this.consumerName + "', queueName=" + this.queueName + ", redeliveryPolicy=" + this.redeliveryPolicy + ", queueMessageHandler=" + this.queueMessageHandler + ", parallelConsumers=" + this.parallelConsumers + ", consumerExecutorService=" + this.consumerExecutorService + "}";
    }

    public void validate() {
        FailFast.requireNonNull((Object)this.consumerName, (String)"You must provide a consumerName");
        FailFast.requireNonNull((Object)((Object)this.queueName), (String)"You must provide a queueName");
        FailFast.requireNonNull((Object)this.redeliveryPolicy, (String)"You must provide a redeliveryPolicy");
        FailFast.requireNonNull((Object)this.queueMessageHandler, (String)"You must provide a queueMessageHandler");
        FailFast.requireNonNull((Object)this.pollingInterval, (String)"You must provide a pollingInterval");
        FailFast.requireTrue((this.parallelConsumers >= 1 ? 1 : 0) != 0, (String)"parallelConsumers must be >= 1");
        FailFast.requireTrue((this.pollingInterval.toMillis() >= 10L ? 1 : 0) != 0, (String)"pollingInterval must be >= 10 ms");
    }
}

