/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.messaging.queue.operations;

import dk.cloudcreate.essentials.components.foundation.messaging.queue.Message;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.MessageMetaData;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.QueueName;
import dk.cloudcreate.essentials.components.foundation.messaging.queue.operations.QueueMessage;
import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;
import java.util.Optional;

public class QueueMessageBuilder {
    private QueueName queueName;
    private Object payload;
    private Optional<Exception> causeOfEnqueuing = Optional.empty();
    private Optional<Duration> deliveryDelay = Optional.empty();
    private MessageMetaData metaData = new MessageMetaData();

    public QueueMessageBuilder setQueueName(QueueName queueName) {
        this.queueName = queueName;
        return this;
    }

    public QueueMessageBuilder setPayload(Object payload) {
        this.payload = payload;
        return this;
    }

    public QueueMessageBuilder setMessage(Message message) {
        FailFast.requireNonNull((Object)((Object)message), (String)"No message supplied");
        this.payload = message.getPayload();
        this.metaData = message.getMetaData();
        return this;
    }

    public QueueMessageBuilder setCauseOfEnqueuing(Optional<Exception> causeOfEnqueuing) {
        this.causeOfEnqueuing = (Optional)FailFast.requireNonNull(causeOfEnqueuing, (String)"No causeOfEnqueuing provided");
        return this;
    }

    public QueueMessageBuilder setDeliveryDelay(Optional<Duration> deliveryDelay) {
        this.deliveryDelay = (Optional)FailFast.requireNonNull(deliveryDelay, (String)"No deliveryDelay provided");
        return this;
    }

    public QueueMessageBuilder setCauseOfEnqueuing(Exception causeOfEnqueuing) {
        this.causeOfEnqueuing = Optional.ofNullable(causeOfEnqueuing);
        return this;
    }

    public QueueMessageBuilder setDeliveryDelay(Duration deliveryDelay) {
        this.deliveryDelay = Optional.ofNullable(deliveryDelay);
        return this;
    }

    public QueueMessageBuilder setMetaData(MessageMetaData metaData) {
        this.metaData = (MessageMetaData)FailFast.requireNonNull((Object)metaData, (String)"No metaData provided");
        return this;
    }

    public QueueMessage build() {
        return new QueueMessage(this.queueName, new Message(this.payload, this.metaData), this.causeOfEnqueuing, this.deliveryDelay);
    }
}

