/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.components.foundation.transaction;

import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWork;
import dk.cloudcreate.essentials.components.foundation.transaction.UnitOfWorkException;
import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.CheckedConsumer;
import dk.cloudcreate.essentials.shared.functional.CheckedFunction;
import dk.cloudcreate.essentials.shared.functional.CheckedRunnable;
import dk.cloudcreate.essentials.shared.functional.CheckedSupplier;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UnitOfWorkFactory<UOW extends UnitOfWork> {
    public static final Logger unitOfWorkLog = LoggerFactory.getLogger(UnitOfWorkFactory.class);

    public UOW getRequiredUnitOfWork();

    public UOW getOrCreateNewUnitOfWork();

    default public void usingUnitOfWork(CheckedRunnable action) {
        this.usingUnitOfWork(uow -> action.run());
    }

    default public <R> R withUnitOfWork(CheckedSupplier<R> action) {
        return this.withUnitOfWork(uow -> action.get());
    }

    default public void usingUnitOfWork(CheckedConsumer<UOW> unitOfWorkConsumer) {
        FailFast.requireNonNull(unitOfWorkConsumer, (String)"No unitOfWorkConsumer provided");
        Optional<UOW> existingUnitOfWork = this.getCurrentUnitOfWork();
        UnitOfWork unitOfWork = existingUnitOfWork.orElseGet(() -> {
            unitOfWorkLog.debug("Creating a new UnitOfWork for this usingUnitOfWork(CheckedConsumer) method call as there wasn't an existing UnitOfWork");
            return this.getOrCreateNewUnitOfWork();
        });
        existingUnitOfWork.ifPresent(uow -> unitOfWorkLog.debug("NestedUnitOfWork: Reusing existing UnitOfWork for this usingUnitOfWork(CheckedConsumer) method call"));
        try {
            unitOfWorkConsumer.accept((Object)unitOfWork);
            if (existingUnitOfWork.isEmpty()) {
                unitOfWorkLog.debug("Committing the UnitOfWork created by this usingUnitOfWork(CheckedConsumer) method call");
                unitOfWork.commit();
            } else {
                unitOfWorkLog.debug("NestedUnitOfWork: Won't commit the UnitOfWork as it wasn't created by this usingUnitOfWork(CheckedConsumer) method call");
            }
        }
        catch (Exception e) {
            if (existingUnitOfWork.isEmpty()) {
                unitOfWorkLog.debug("Rolling back the UnitOfWork created by this usingUnitOfWork(CheckedConsumer) method call");
                unitOfWork.rollback(e);
            } else {
                unitOfWorkLog.debug("NestedUnitOfWork: Marking UnitOfWork as rollback only as it wasn't created by this usingUnitOfWork(CheckedConsumer) method call");
                unitOfWork.markAsRollbackOnly(e);
            }
            throw new UnitOfWorkException(e);
        }
    }

    default public <R> R withUnitOfWork(CheckedFunction<UOW, R> unitOfWorkFunction) {
        FailFast.requireNonNull(unitOfWorkFunction, (String)"No unitOfWorkFunction provided");
        Optional<UOW> existingUnitOfWork = this.getCurrentUnitOfWork();
        UnitOfWork unitOfWork = existingUnitOfWork.orElseGet(() -> {
            unitOfWorkLog.debug("Creating a new UnitOfWork for this withUnitOfWork(CheckedFunction) method call as there wasn't an existing UnitOfWork");
            return this.getOrCreateNewUnitOfWork();
        });
        existingUnitOfWork.ifPresent(uow -> unitOfWorkLog.debug("NestedUnitOfWork: Reusing existing UnitOfWork for this withUnitOfWork(CheckedFunction) method call"));
        try {
            Object result = unitOfWorkFunction.apply((Object)unitOfWork);
            if (existingUnitOfWork.isEmpty()) {
                unitOfWorkLog.debug("Committing the UnitOfWork created by this withUnitOfWork(CheckedFunction) method call");
                unitOfWork.commit();
            } else {
                unitOfWorkLog.debug("NestedUnitOfWork: Won't commit the UnitOfWork as it wasn't created by this withUnitOfWork(CheckedFunction) method call");
            }
            return (R)result;
        }
        catch (Exception e) {
            if (existingUnitOfWork.isEmpty()) {
                unitOfWorkLog.debug("Rolling back the UnitOfWork created by this withUnitOfWork(CheckedFunction) method call");
                unitOfWork.rollback(e);
            } else {
                unitOfWorkLog.debug("NestedUnitOfWork: Marking UnitOfWork as rollback only as it wasn't created by this withUnitOfWork(CheckedFunction) method call");
                unitOfWork.markAsRollbackOnly(e);
            }
            throw new UnitOfWorkException(e);
        }
    }

    public Optional<UOW> getCurrentUnitOfWork();
}

